/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.internal.ExamplesMessages;
import org.eclipse.rap.examples.pages.internal.ImageUtil;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ClientInfo;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class InternationalizationExamplePage
implements IExamplePage {
    private Language[] languages;
    private Composite parentContainer;
    private Composite contentContainer;
    private final float EQUATOR = 40075.016f;

    public void createControl(Composite parent) {
        this.initLanguages((Device)parent.getDisplay());
        this.parentContainer = parent;
        this.parentContainer.addListener(12, (Listener)new LocaleResetListener());
        this.parentContainer.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        this.createLocaleSwitcherArea();
        this.createContentArea();
    }

    private void initLanguages(Device device) {
        this.languages = new Language[]{new Language(null, ImageUtil.getImage(device, "no-flag.png")), new Language(Locale.US, ImageUtil.getImage(device, "en-flag.png")), new Language(Locale.GERMANY, ImageUtil.getImage(device, "de-flag.png")), new Language(Locale.FRANCE, ImageUtil.getImage(device, "fr-flag.png")), new Language(new Locale("bg", "BG", ""), ImageUtil.getImage(device, "bg-flag.png")), new Language(Locale.CHINA, ImageUtil.getImage(device, "zh-flag.png"))};
    }

    private void createLocaleSwitcherArea() {
        Composite container = new Composite(this.parentContainer, 0);
        container.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        container.setLayoutData((Object)ExampleUtil.createHorzFillData());
        Label clientLanguage = new Label(container, 0);
        clientLanguage.setLayoutData((Object)this.createClientLanguageGridData());
        ClientInfo clientInfo = (ClientInfo)RWT.getClient().getService(ClientInfo.class);
        clientLanguage.setText("Browser default language: " + clientInfo.getLocale().getDisplayLanguage());
        new Label(container, 0).setText("Select language: ");
        ToolBar toolBar = new ToolBar(container, 0);
        toolBar.setLayoutData((Object)this.createToolBarGridData());
        ToolItem dropDown = new ToolItem(toolBar, 4);
        dropDown.setText(this.languages[0].name);
        dropDown.setImage(this.languages[0].flag);
        Menu dropDownMenu = this.createDropDownMenu(dropDown);
        dropDown.addListener(13, (Listener)new DropDownSelectionListener(dropDownMenu));
    }

    private Menu createDropDownMenu(ToolItem dropDown) {
        Menu menu = new Menu((Decorations)dropDown.getParent().getShell(), 8);
        int i = 0;
        while (i < this.languages.length) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText(this.languages[i].name);
            item.setImage(this.languages[i].flag);
            item.setData((Object)this.languages[i]);
            item.addListener(13, (Listener)new MenuItemSelectionListener(dropDown));
            ++i;
        }
        return menu;
    }

    private void createContentArea() {
        if (this.contentContainer != null) {
            this.contentContainer.dispose();
        }
        this.contentContainer = new Composite(this.parentContainer, 0);
        this.contentContainer.setLayoutData((Object)ExampleUtil.createFillData());
        this.contentContainer.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        this.createTextArea();
        this.createCurrentDataArea();
        this.parentContainer.layout();
    }

    private void createTextArea() {
        Group area = new Group(this.contentContainer, 0);
        area.setLayoutData((Object)new GridData(128, 4, true, false));
        area.setText("Text");
        area.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)true));
        Label title = new Label((Composite)area, 0x1000000);
        title.setLayoutData((Object)ExampleUtil.createHorzFillData());
        title.setData("org.eclipse.rap.rwt.customVariant", (Object)"heading");
        title.setText(ExamplesMessages.get().WhatIsUnicode_Title);
        Label text = new Label((Composite)area, 64);
        text.setLayoutData((Object)ExampleUtil.createFillData());
        text.setText(ExamplesMessages.get().WhatIsUnicode_Descritption);
    }

    private void createCurrentDataArea() {
        Group area = new Group(this.contentContainer, 0);
        area.setLayoutData((Object)new GridData(128, 4, false, false));
        area.setText("Data");
        area.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        Locale locale = RWT.getLocale();
        Calendar calendar = Calendar.getInstance(locale);
        DateFormat dateFormatter = DateFormat.getDateInstance(0, locale);
        this.addDataEntry(area, "Date:", dateFormatter.format(calendar.getTime()));
        DateFormat timeFormatter = DateFormat.getTimeInstance(3, locale);
        this.addDataEntry(area, "Time:", timeFormatter.format(calendar.getTime()));
        NumberFormat numberFormatter = NumberFormat.getNumberInstance(locale);
        this.addDataEntry(area, "Equator:", String.valueOf(numberFormatter.format(40075.015625)) + " km");
        try {
            Currency currentCurrency = Currency.getInstance(locale);
            this.addDataEntry(area, "Currency:", currentCurrency.getCurrencyCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void addDataEntry(Group area, String heading, String data) {
        Label title = new Label((Composite)area, 131072);
        title.setText(heading);
        title.setData("org.eclipse.rap.rwt.customVariant", (Object)"heading");
        Label today = new Label((Composite)area, 131072);
        today.setText(data);
    }

    private GridData createClientLanguageGridData() {
        return new GridData(4, 0x1000000, true, false);
    }

    private GridData createToolBarGridData() {
        return new GridData(180, -1);
    }

    private final class DropDownSelectionListener
    implements Listener {
        private final Menu menu;

        public DropDownSelectionListener(Menu menu) {
            this.menu = menu;
        }

        public void handleEvent(Event event) {
            ToolItem dropDown = (ToolItem)event.widget;
            if (event.detail == 4) {
                Point point = dropDown.getParent().toDisplay(event.x, event.y);
                this.menu.setLocation(point);
                this.menu.setVisible(true);
            }
        }
    }

    private final class Language {
        public final String name;
        public final Locale locale;
        public final Image flag;

        public Language(Locale locale, Image flag) {
            this.name = locale == null ? "Default" : locale.getDisplayLanguage();
            this.locale = locale;
            this.flag = flag;
        }
    }

    private final class LocaleResetListener
    implements Listener {
        private LocaleResetListener() {
        }

        public void handleEvent(Event event) {
            RWT.setLocale(null);
        }
    }

    private final class MenuItemSelectionListener
    implements Listener {
        private final ToolItem dropDown;

        public MenuItemSelectionListener(ToolItem dropDown) {
            this.dropDown = dropDown;
        }

        public void handleEvent(Event event) {
            MenuItem item = (MenuItem)event.widget;
            Language language = (Language)item.getData();
            this.dropDown.setText(language.name);
            this.dropDown.setImage(language.flag);
            RWT.setLocale((Locale)language.locale);
            InternationalizationExamplePage.this.createContentArea();
        }
    }
}

