/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.osgi.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceContainer<S> {
    private final Set<ServiceHolder<S>> services;
    private final BundleContext bundleContext;

    ServiceContainer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.services = new HashSet<ServiceHolder<S>>();
    }

    ServiceHolder<S> add(S service) {
        return this.add(service, null);
    }

    ServiceHolder<S> add(ServiceReference<S> reference) {
        return this.add(this.bundleContext.getService(reference), reference);
    }

    void remove(S service) {
        this.services.remove(this.find(service));
    }

    ServiceHolder<S>[] getServices() {
        HashSet<ServiceHolder<S>> result = new HashSet<ServiceHolder<S>>();
        Iterator<ServiceHolder<S>> iterator = this.services.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result.toArray(new ServiceHolder[result.size()]);
    }

    ServiceHolder<S> find(S service) {
        Finder finder = new Finder();
        return finder.findServiceHolder(service, this.services);
    }

    void clear() {
        this.services.clear();
    }

    int size() {
        return this.services.size();
    }

    private ServiceHolder<S> add(S service, ServiceReference<S> reference) {
        ServiceHolder<S> result = this.find(service);
        if (this.notFound(result)) {
            result = new ServiceHolder(service, reference);
            this.services.add(result);
        } else if (this.referenceIsMissing(reference, result)) {
            ((ServiceHolder)result).setServiceReference(reference);
        }
        return result;
    }

    private boolean notFound(ServiceHolder<S> result) {
        return result == null;
    }

    private boolean referenceIsMissing(ServiceReference<S> reference, ServiceHolder<S> result) {
        return reference != null && ((ServiceHolder)result).serviceReference == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Finder<S> {
        private Finder() {
        }

        private ServiceHolder<S> findServiceHolder(S service, Set<ServiceHolder<S>> collection) {
            Iterator<ServiceHolder<S>> iterator = collection.iterator();
            ServiceHolder<S> result = null;
            while (iterator.hasNext()) {
                ServiceHolder<S> serviceHolder = iterator.next();
                S found = serviceHolder.getService();
                if (!service.equals(found)) continue;
                result = serviceHolder;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServiceHolder<S> {
        private ServiceReference<S> serviceReference;
        private final S service;

        private ServiceHolder(S service, ServiceReference<S> serviceReference) {
            this.service = service;
            this.serviceReference = serviceReference;
        }

        S getService() {
            return this.service;
        }

        ServiceReference<S> getReference() {
            return this.serviceReference;
        }

        private void setServiceReference(ServiceReference<S> serviceReference) {
            this.serviceReference = serviceReference;
        }
    }
}

