/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.application;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.application.ExceptionHandler;
import org.eclipse.rap.rwt.internal.application.ApplicationImpl;
import org.eclipse.rap.rwt.internal.client.ClientSelector;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterFactory;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseListenerManager;
import org.eclipse.rap.rwt.internal.remote.MessageChainElement;
import org.eclipse.rap.rwt.internal.remote.MessageChainReference;
import org.eclipse.rap.rwt.internal.remote.MessageFilter;
import org.eclipse.rap.rwt.internal.remote.MessageFilterChain;
import org.eclipse.rap.rwt.internal.resources.ClientResources;
import org.eclipse.rap.rwt.internal.resources.ResourceDirectory;
import org.eclipse.rap.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rap.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rap.rwt.internal.serverpush.ServerPushServiceHandler;
import org.eclipse.rap.rwt.internal.service.ApplicationStoreImpl;
import org.eclipse.rap.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rap.rwt.internal.service.RWTMessageHandler;
import org.eclipse.rap.rwt.internal.service.ServiceManagerImpl;
import org.eclipse.rap.rwt.internal.service.SettingStoreManager;
import org.eclipse.rap.rwt.internal.service.StartupPage;
import org.eclipse.rap.rwt.internal.textsize.ProbeStore;
import org.eclipse.rap.rwt.internal.textsize.TextSizeStorage;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.internal.util.SerializableLock;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.ApplicationContextEvent;
import org.eclipse.rap.rwt.service.ApplicationContextListener;
import org.eclipse.rap.rwt.service.FileSettingStoreFactory;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.internal.graphics.FontDataFactory;
import org.eclipse.swt.internal.graphics.ImageDataFactory;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.graphics.InternalImageFactory;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.DisplaysHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContextImpl
implements ApplicationContext {
    private static final String ATTR_APPLICATION_CONTEXT = String.valueOf(ApplicationContextImpl.class.getName()) + "#instance";
    public static ResourceManager testResourceManager;
    public static boolean skipResoureRegistration;
    public static boolean skipResoureDeletion;
    private ThemeManager themeManager;
    private final ApplicationConfiguration applicationConfiguration;
    private final ResourceDirectory resourceDirectory;
    private final ResourceManagerImpl resourceManager;
    private final PhaseListenerManager phaseListenerManager;
    private final LifeCycleFactory lifeCycleFactory;
    private final MessageChainReference messageChainReference;
    private final EntryPointManager entryPointManager;
    private final LifeCycleAdapterFactory lifeCycleAdapterFactory;
    private final SettingStoreManager settingStoreManager;
    private final ServiceManagerImpl serviceManager;
    private final ResourceRegistry resourceRegistry;
    private final ApplicationStoreImpl applicationStore;
    private final ResourceFactory resourceFactory;
    private final ImageFactory imageFactory;
    private final InternalImageFactory internalImageFactory;
    private final ImageDataFactory imageDataFactory;
    private final FontDataFactory fontDataFactory;
    private final StartupPage startupPage;
    private final DisplaysHolder displaysHolder;
    private final TextSizeStorage textSizeStorage;
    private final ProbeStore probeStore;
    private final ServletContext servletContext;
    private final ClientSelector clientSelector;
    private final Set<ApplicationContextListener> listeners;
    private final SerializableLock listenersLock;
    private final AtomicReference<State> state;
    private ExceptionHandler exceptionHandler;

    public ApplicationContextImpl(ApplicationConfiguration applicationConfiguration, ServletContext servletContext) {
        this.applicationConfiguration = applicationConfiguration;
        this.servletContext = servletContext;
        this.applicationStore = new ApplicationStoreImpl();
        this.resourceDirectory = new ResourceDirectory();
        this.resourceManager = new ResourceManagerImpl(this.resourceDirectory);
        this.phaseListenerManager = new PhaseListenerManager();
        this.entryPointManager = new EntryPointManager();
        this.lifeCycleFactory = new LifeCycleFactory(this);
        RWTMessageHandler rwtHandler = new RWTMessageHandler(this.lifeCycleFactory);
        this.messageChainReference = new MessageChainReference(new MessageChainElement(rwtHandler, null));
        this.themeManager = new ThemeManager();
        this.resourceFactory = new ResourceFactory();
        this.imageFactory = new ImageFactory();
        this.internalImageFactory = new InternalImageFactory();
        this.imageDataFactory = new ImageDataFactory(this.resourceManager);
        this.fontDataFactory = new FontDataFactory();
        this.lifeCycleAdapterFactory = new LifeCycleAdapterFactory();
        this.settingStoreManager = new SettingStoreManager();
        this.resourceRegistry = new ResourceRegistry(this.getResourceManager());
        this.startupPage = new StartupPage(this);
        this.serviceManager = this.createServiceManager();
        this.displaysHolder = new DisplaysHolder();
        this.textSizeStorage = new TextSizeStorage();
        this.probeStore = new ProbeStore(this.textSizeStorage);
        this.clientSelector = new ClientSelector();
        this.listeners = new HashSet<ApplicationContextListener>();
        this.listenersLock = new SerializableLock();
        this.state = new AtomicReference<State>(State.INACTIVE);
    }

    public static ApplicationContextImpl getFrom(ServletContext servletContext) {
        return (ApplicationContextImpl)servletContext.getAttribute(ATTR_APPLICATION_CONTEXT);
    }

    public void attachToServletContext() {
        this.servletContext.setAttribute(ATTR_APPLICATION_CONTEXT, (Object)this);
    }

    public void removeFromServletContext() {
        this.servletContext.removeAttribute(ATTR_APPLICATION_CONTEXT);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.applicationStore.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.applicationStore.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.applicationStore.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addApplicationContextListener(ApplicationContextListener listener) {
        ParamCheck.notNull(listener, "listener");
        boolean result = false;
        SerializableLock serializableLock = this.listenersLock;
        synchronized (serializableLock) {
            if (this.state.get().equals((Object)State.ACTIVE)) {
                result = true;
                this.listeners.add(listener);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeApplicationContextListener(ApplicationContextListener listener) {
        ParamCheck.notNull(listener, "listener");
        boolean result = false;
        SerializableLock serializableLock = this.listenersLock;
        synchronized (serializableLock) {
            if (this.state.get().equals((Object)State.ACTIVE)) {
                result = true;
                this.listeners.remove(listener);
            }
        }
        return result;
    }

    public boolean isActive() {
        State currentState = this.state.get();
        return currentState.equals((Object)State.ACTIVE) || currentState.equals((Object)State.ABOUT_TO_DEACTIVATE);
    }

    public boolean allowsRequests() {
        return this.state.get().equals((Object)State.ACTIVE);
    }

    public void activate() {
        if (this.state.compareAndSet(State.INACTIVE, State.ACTIVATING)) {
            try {
                this.doActivate();
                this.state.set(State.ACTIVE);
            }
            catch (RuntimeException rte) {
                this.state.set(State.INACTIVE);
                throw rte;
            }
        }
    }

    public void deactivate() {
        if (this.state.compareAndSet(State.ACTIVE, State.ABOUT_TO_DEACTIVATE)) {
            try {
                this.fireBeforeDestroy();
                this.state.set(State.DEACTIVATING);
                this.doDeactivate();
            }
            finally {
                this.state.set(State.INACTIVE);
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ResourceDirectory getResourceDirectory() {
        return this.resourceDirectory;
    }

    @Override
    public ResourceManager getResourceManager() {
        return testResourceManager != null ? testResourceManager : this.resourceManager;
    }

    public EntryPointManager getEntryPointManager() {
        return this.entryPointManager;
    }

    public SettingStoreManager getSettingStoreManager() {
        return this.settingStoreManager;
    }

    public PhaseListenerManager getPhaseListenerManager() {
        return this.phaseListenerManager;
    }

    public LifeCycleAdapterFactory getLifeCycleAdapterFactory() {
        return this.lifeCycleAdapterFactory;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    @Override
    public ServiceManagerImpl getServiceManager() {
        return this.serviceManager;
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public LifeCycleFactory getLifeCycleFactory() {
        return this.lifeCycleFactory;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public ImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public InternalImageFactory getInternalImageFactory() {
        return this.internalImageFactory;
    }

    public ImageDataFactory getImageDataFactory() {
        return this.imageDataFactory;
    }

    public FontDataFactory getFontDataFactory() {
        return this.fontDataFactory;
    }

    public StartupPage getStartupPage() {
        return this.startupPage;
    }

    public DisplaysHolder getDisplaysHolder() {
        return this.displaysHolder;
    }

    public TextSizeStorage getTextSizeStorage() {
        return this.textSizeStorage;
    }

    public ProbeStore getProbeStore() {
        return this.probeStore;
    }

    public ClientSelector getClientSelector() {
        return this.clientSelector;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public MessageFilterChain getHandlerChain() {
        return this.messageChainReference.get();
    }

    public void addMessageFilter(MessageFilter filter) {
        ParamCheck.notNull(filter, "filter");
        this.messageChainReference.add(filter);
    }

    public void removeMessageFilter(MessageFilter filter) {
        ParamCheck.notNull(filter, "filter");
        this.messageChainReference.remove(filter);
    }

    void doActivate() {
        this.themeManager.initialize();
        this.applicationConfiguration.configure(new ApplicationImpl(this, this.applicationConfiguration));
        this.resourceDirectory.configure(this.getContextDirectory());
        this.addInternalServiceHandlers();
        this.setInternalSettingStoreFactory();
        this.startupPage.activate();
        this.lifeCycleFactory.activate();
        this.themeManager.activate();
        if (!skipResoureRegistration) {
            ClientResources clientResources = new ClientResources(this);
            clientResources.registerResources();
        }
        this.resourceRegistry.registerResources();
        this.clientSelector.activate();
    }

    void doDeactivate() {
        this.startupPage.deactivate();
        this.lifeCycleFactory.deactivate();
        this.serviceManager.clear();
        this.themeManager.deactivate();
        if (!skipResoureDeletion) {
            this.resourceDirectory.deleteDirectory();
        }
        this.entryPointManager.deregisterAll();
        this.phaseListenerManager.clear();
        this.resourceRegistry.clear();
        this.settingStoreManager.deregisterFactory();
        this.resourceDirectory.reset();
        this.applicationStore.reset();
    }

    private ServiceManagerImpl createServiceManager() {
        return new ServiceManagerImpl(new LifeCycleServiceHandler(this.messageChainReference, this.startupPage));
    }

    private String getContextDirectory() {
        String location = (String)this.servletContext.getAttribute("resource_root_location");
        if (location == null) {
            location = this.servletContext.getRealPath("/");
        }
        return location;
    }

    private void addInternalServiceHandlers() {
        this.serviceManager.registerServiceHandler("org.eclipse.rap.serverpush", new ServerPushServiceHandler());
    }

    private void setInternalSettingStoreFactory() {
        if (!this.settingStoreManager.hasFactory()) {
            this.settingStoreManager.register(new FileSettingStoreFactory());
        }
    }

    private void fireBeforeDestroy() {
        ApplicationContextEvent event = new ApplicationContextEvent(this);
        for (ApplicationContextListener listener : this.copyListeners()) {
            try {
                listener.beforeDestroy(event);
            }
            catch (RuntimeException exception) {
                this.handleBeforeDestroyException(listener, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApplicationContextListener> copyListeners() {
        SerializableLock serializableLock = this.listenersLock;
        synchronized (serializableLock) {
            return new ArrayList<ApplicationContextListener>(this.listeners);
        }
    }

    private void handleBeforeDestroyException(ApplicationContextListener listener, RuntimeException exception) {
        String txt = "Could not execute {0}.beforeDestroy(ApplicationContextEvent).";
        Object[] param = new Object[]{listener.getClass().getName()};
        String msg = MessageFormat.format(txt, param);
        this.servletContext.log(msg, (Throwable)exception);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INACTIVE,
        ACTIVATING,
        ACTIVE,
        ABOUT_TO_DEACTIVATE,
        DEACTIVATING;

    }
}

