/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.lang.reflect.Field;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.ActiveKeysUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ControlUtil;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.IControlHolderAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ControlLCAUtil {
    private static final String PROP_ACTIVATE_LISTENER = "Activate";
    private static final String PROP_DEACTIVATE_LISTENER = "Deactivate";
    private static final String PROP_FOCUS_IN_LISTENER = "FocusIn";
    private static final String PROP_FOCUS_OUT_LISTENER = "FocusOut";
    private static final String PROP_MOUSE_DOWN_LISTENER = "MouseDown";
    private static final String PROP_MOUSE_DOUBLE_CLICK_LISTENER = "MouseDoubleClick";
    private static final String PROP_MOUSE_UP_LISTENER = "MouseUp";
    private static final String PROP_KEY_LISTENER = "KeyDown";
    private static final String PROP_TRAVERSE_LISTENER = "Traverse";
    private static final String PROP_MENU_DETECT_LISTENER = "MenuDetect";
    private static final String PROP_TAB_INDEX = "tabIndex";
    private static final String PROP_CURSOR = "cursor";
    private static final String PROP_BACKGROUND_IMAGE = "backgroundImage";
    private static final String PROP_CHILDREN = "children";
    private static final String CURSOR_UPARROW = "rwt-resources/resource/widget/rap/cursors/up_arrow.cur";

    private ControlLCAUtil() {
    }

    public static void preserveValues(Control control) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(control);
        WidgetLCAUtil.preserveBounds(control, control.getBounds());
        adapter.preserve(PROP_CHILDREN, ControlLCAUtil.getChildren(control));
        adapter.preserve(PROP_TAB_INDEX, new Integer(ControlLCAUtil.getTabIndex(control)));
        WidgetLCAUtil.preserveToolTipText(control, control.getToolTipText());
        adapter.preserve("menu", control.getMenu());
        adapter.preserve("visible", ControlLCAUtil.getVisible(control));
        WidgetLCAUtil.preserveEnabled(control, control.getEnabled());
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.preserveForeground(control, controlAdapter.getUserForeground());
        WidgetLCAUtil.preserveBackground(control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
        ControlLCAUtil.preserveBackgroundImage(control);
        WidgetLCAUtil.preserveFont(control, controlAdapter.getUserFont());
        adapter.preserve(PROP_CURSOR, control.getCursor());
        ControlLCAUtil.preserveActivateListeners(control);
        ControlLCAUtil.preserveMouseListeners(control);
        if ((control.getStyle() & 0x80000) == 0) {
            ControlLCAUtil.preserveFocusListeners(control);
        }
        WidgetLCAUtil.preserveListener(control, PROP_KEY_LISTENER, ControlLCAUtil.hasKeyListener(control));
        WidgetLCAUtil.preserveListener(control, PROP_TRAVERSE_LISTENER, EventLCAUtil.isListening(control, 31));
        WidgetLCAUtil.preserveListener(control, PROP_MENU_DETECT_LISTENER, EventLCAUtil.isListening(control, 35));
        WidgetLCAUtil.preserveHelpListener(control);
        ActiveKeysUtil.preserveActiveKeys(control);
        ActiveKeysUtil.preserveCancelKeys(control);
        WidgetLCAUtil.preserveData(control);
    }

    public static void preserveBackgroundImage(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image image = controlAdapter.getUserBackgroundImage();
        WidgetAdapter adapter = WidgetUtil.getAdapter(control);
        adapter.preserve(PROP_BACKGROUND_IMAGE, image);
    }

    public static void renderChanges(Control control) {
        ControlLCAUtil.renderBounds(control);
        ControlLCAUtil.renderChildren(control);
        ControlLCAUtil.renderTabIndex(control);
        ControlLCAUtil.renderToolTip(control);
        ControlLCAUtil.renderMenu(control);
        ControlLCAUtil.renderVisible(control);
        ControlLCAUtil.renderEnabled(control);
        ControlLCAUtil.renderForeground(control);
        ControlLCAUtil.renderBackground(control);
        ControlLCAUtil.renderBackgroundImage(control);
        ControlLCAUtil.renderFont(control);
        ControlLCAUtil.renderCursor(control);
        ActiveKeysUtil.renderActiveKeys(control);
        ActiveKeysUtil.renderCancelKeys(control);
        ControlLCAUtil.renderListenActivate(control);
        ControlLCAUtil.renderListenFocus(control);
        ControlLCAUtil.renderListenMouse(control);
        ControlLCAUtil.renderListenKey(control);
        ControlLCAUtil.renderListenTraverse(control);
        ControlLCAUtil.renderListenMenuDetect(control);
        WidgetLCAUtil.renderListenHelp(control);
        WidgetLCAUtil.renderData(control);
    }

    public static void renderBounds(Control control) {
        WidgetLCAUtil.renderBounds(control, control.getBounds());
    }

    static void renderChildren(Control control) {
        if (control instanceof Composite) {
            String[] newValue = ControlLCAUtil.getChildren(control);
            WidgetLCAUtil.renderProperty((Widget)control, PROP_CHILDREN, newValue, null);
        }
    }

    static void renderTabIndex(Control control) {
        int tabIndex;
        Integer newValue;
        if (control instanceof Shell) {
            ControlLCAUtil.resetTabIndices((Shell)control);
            ControlLCAUtil.computeTabIndices((Shell)control, 1);
        }
        if (WidgetLCAUtil.hasChanged(control, PROP_TAB_INDEX, newValue = new Integer(tabIndex = ControlLCAUtil.getTabIndex(control)))) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_TAB_INDEX, tabIndex);
        }
    }

    public static void renderToolTip(Control control) {
        WidgetLCAUtil.renderToolTip(control, control.getToolTipText());
    }

    public static void renderMenu(Control control) {
        WidgetLCAUtil.renderMenu(control, control.getMenu());
    }

    public static void renderVisible(Control control) {
        Boolean defValue;
        boolean visible = ControlLCAUtil.getVisible(control);
        Boolean newValue = visible;
        Boolean bl = defValue = control instanceof Shell ? Boolean.FALSE : Boolean.TRUE;
        if (WidgetLCAUtil.hasChanged(control, "visible", newValue, defValue)) {
            RemoteObjectFactory.getRemoteObject(control).set("visibility", visible);
        }
    }

    public static void renderEnabled(Control control) {
        WidgetLCAUtil.renderEnabled(control, control.getEnabled());
    }

    public static void renderForeground(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.renderForeground(control, controlAdapter.getUserForeground());
    }

    public static void renderBackground(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.renderBackground(control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
    }

    public static void renderBackgroundImage(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image image = controlAdapter.getUserBackgroundImage();
        WidgetLCAUtil.renderProperty((Widget)control, PROP_BACKGROUND_IMAGE, image, null);
    }

    public static void renderFont(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Font newValue = controlAdapter.getUserFont();
        WidgetLCAUtil.renderFont(control, newValue);
    }

    static void renderCursor(Control control) {
        Cursor newValue = control.getCursor();
        if (WidgetLCAUtil.hasChanged(control, PROP_CURSOR, newValue, null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_CURSOR, ControlLCAUtil.getQxCursor(newValue));
        }
    }

    static void renderListenActivate(Control control) {
        if (!control.isDisposed() && !(control instanceof Shell)) {
            ControlLCAUtil.renderListen(control, 26, PROP_ACTIVATE_LISTENER);
            ControlLCAUtil.renderListen(control, 27, PROP_DEACTIVATE_LISTENER);
        }
    }

    static void renderListenFocus(Control control) {
        if ((control.getStyle() & 0x80000) == 0) {
            ControlLCAUtil.renderListen(control, 15, PROP_FOCUS_IN_LISTENER);
            ControlLCAUtil.renderListen(control, 16, PROP_FOCUS_OUT_LISTENER);
        }
    }

    static void renderListenMouse(Control control) {
        ControlLCAUtil.renderListen(control, 3, PROP_MOUSE_DOWN_LISTENER);
        ControlLCAUtil.renderListen(control, 4, PROP_MOUSE_UP_LISTENER);
        ControlLCAUtil.renderListen(control, 8, PROP_MOUSE_DOUBLE_CLICK_LISTENER);
    }

    static void renderListenKey(Control control) {
        boolean newValue = ControlLCAUtil.hasKeyListener(control);
        WidgetLCAUtil.renderListener(control, PROP_KEY_LISTENER, newValue, false);
    }

    static void renderListenTraverse(Control control) {
        boolean newValue = EventLCAUtil.isListening(control, 31);
        WidgetLCAUtil.renderListener(control, PROP_TRAVERSE_LISTENER, newValue, false);
    }

    static void renderListenMenuDetect(Control control) {
        boolean newValue = EventLCAUtil.isListening(control, 35);
        WidgetLCAUtil.renderListener(control, PROP_MENU_DETECT_LISTENER, newValue, false);
    }

    private static void renderListen(Control control, int eventType, String eventName) {
        WidgetLCAUtil.renderListener(control, eventName, EventLCAUtil.isListening(control, eventType), false);
    }

    private static String[] getChildren(Control control) {
        String[] result = null;
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            IControlHolderAdapter controlHolder = composite.getAdapter(IControlHolderAdapter.class);
            Control[] children = controlHolder.getControls();
            result = new String[children.length];
            int i = 0;
            while (i < result.length) {
                result[i] = WidgetUtil.getId(children[i]);
                ++i;
            }
        }
        return result;
    }

    private static boolean getVisible(Control control) {
        Point size = control.getSize();
        return control.getVisible() && size.x > 0 && size.y > 0;
    }

    private static boolean takesFocus(Control control) {
        boolean result = true;
        result &= (control.getStyle() & 0x80000) == 0;
        result &= control.getClass() != Composite.class;
        return result &= control.getClass() != SashForm.class;
    }

    private static int getTabIndex(Control control) {
        int result = -1;
        if (ControlLCAUtil.takesFocus(control)) {
            result = ControlUtil.getControlAdapter(control).getTabIndex();
        }
        return result;
    }

    private static void resetTabIndices(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            ControlUtil.getControlAdapter(control).setTabIndex(-1);
            if (control instanceof Composite) {
                ControlLCAUtil.resetTabIndices((Composite)control);
            }
            ++n2;
        }
    }

    private static int computeTabIndices(Composite composite, int startIndex) {
        int result = startIndex;
        Control[] controlArray = composite.getTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
            controlAdapter.setTabIndex(result);
            result += control instanceof Link ? 300 : 1;
            if (control instanceof Composite) {
                result = ControlLCAUtil.computeTabIndices((Composite)control, result);
            }
            ++n2;
        }
        return result;
    }

    private static String getQxCursor(Cursor newValue) {
        String result = null;
        if (newValue != null) {
            int value = 0;
            try {
                Class<Cursor> cursorClass = Cursor.class;
                Field field = cursorClass.getDeclaredField("value");
                field.setAccessible(true);
                value = field.getInt(newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            switch (value) {
                case 0: {
                    result = "default";
                    break;
                }
                case 1: {
                    result = "wait";
                    break;
                }
                case 3: {
                    result = "progress";
                    break;
                }
                case 2: {
                    result = "crosshair";
                    break;
                }
                case 4: {
                    result = "help";
                    break;
                }
                case 5: {
                    result = "move";
                    break;
                }
                case 7: {
                    result = "row-resize";
                    break;
                }
                case 9: {
                    result = "col-resize";
                    break;
                }
                case 10: {
                    result = "n-resize";
                    break;
                }
                case 11: {
                    result = "s-resize";
                    break;
                }
                case 12: {
                    result = "e-resize";
                    break;
                }
                case 13: {
                    result = "w-resize";
                    break;
                }
                case 6: 
                case 14: {
                    result = "ne-resize";
                    break;
                }
                case 15: {
                    result = "se-resize";
                    break;
                }
                case 16: {
                    result = "sw-resize";
                    break;
                }
                case 8: 
                case 17: {
                    result = "nw-resize";
                    break;
                }
                case 19: {
                    result = "text";
                    break;
                }
                case 21: {
                    result = "pointer";
                    break;
                }
                case 20: {
                    result = "not-allowed";
                    break;
                }
                case 18: {
                    result = CURSOR_UPARROW;
                }
            }
        }
        return result;
    }

    private static boolean hasKeyListener(Control control) {
        return EventLCAUtil.isListening(control, 2) || EventLCAUtil.isListening(control, 1);
    }

    private static void preserveMouseListeners(Control control) {
        WidgetLCAUtil.preserveListener(control, PROP_MOUSE_DOWN_LISTENER, EventLCAUtil.isListening(control, 3));
        WidgetLCAUtil.preserveListener(control, PROP_MOUSE_UP_LISTENER, EventLCAUtil.isListening(control, 4));
        WidgetLCAUtil.preserveListener(control, PROP_MOUSE_DOUBLE_CLICK_LISTENER, EventLCAUtil.isListening(control, 8));
    }

    private static void preserveFocusListeners(Control control) {
        WidgetLCAUtil.preserveListener(control, PROP_FOCUS_IN_LISTENER, EventLCAUtil.isListening(control, 15));
        WidgetLCAUtil.preserveListener(control, PROP_FOCUS_OUT_LISTENER, EventLCAUtil.isListening(control, 16));
    }

    private static void preserveActivateListeners(Control control) {
        if (!(control instanceof Shell)) {
            WidgetLCAUtil.preserveListener(control, PROP_ACTIVATE_LISTENER, EventLCAUtil.isListening(control, 26));
            WidgetLCAUtil.preserveListener(control, PROP_DEACTIVATE_LISTENER, EventLCAUtil.isListening(control, 27));
        }
    }
}

