/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.rap.rwt.client.Client;
import org.eclipse.rap.rwt.client.service.ClientInfo;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.client.ClientMessages;
import org.eclipse.rap.rwt.internal.client.ClientSelector;
import org.eclipse.rap.rwt.internal.lifecycle.ContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rap.rwt.internal.remote.ConnectionImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.internal.util.SerializableLock;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.service.ApplicationContextEvent;
import org.eclipse.rap.rwt.service.ApplicationContextListener;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.eclipse.swt.internal.SerializableCompatibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISessionImpl
implements UISession,
ApplicationContextListener,
HttpSessionBindingListener,
SerializableCompatibility {
    private static final String ATTR_UI_SESSION = String.valueOf(UISessionImpl.class.getName()) + "#uisession:";
    private static final String ATTR_LOCALE = String.valueOf(UISessionImpl.class.getName()) + "#locale";
    private final SerializableLock requestLock;
    private final SerializableLock lock;
    private final Map<String, Object> attributes;
    private final Set<UISessionListener> listeners;
    private final String id;
    private final String connectionId;
    private Connection connection;
    private boolean bound;
    private boolean inDestroy;
    private transient HttpSession httpSession;
    private transient ISessionShutdownAdapter shutdownAdapter;
    private transient ApplicationContextImpl applicationContext;

    public UISessionImpl(ApplicationContextImpl applicationContext, HttpSession httpSession) {
        this(applicationContext, httpSession, null);
    }

    public UISessionImpl(ApplicationContextImpl applicationContext, HttpSession httpSession, String connectionId) {
        this.setApplicationContext(applicationContext);
        this.httpSession = httpSession;
        this.connectionId = connectionId;
        this.requestLock = new SerializableLock();
        this.lock = new SerializableLock();
        this.attributes = new HashMap<String, Object>();
        this.listeners = new HashSet<UISessionListener>();
        this.id = Integer.toHexString(this.hashCode());
        this.bound = true;
        this.connection = new ConnectionImpl();
    }

    public static UISessionImpl getInstanceFromSession(HttpSession httpSession, String connectionId) {
        return (UISessionImpl)httpSession.getAttribute(UISessionImpl.getUISessionAttributeName(connectionId));
    }

    public void attachToHttpSession() {
        this.httpSession.setAttribute(UISessionImpl.getUISessionAttributeName(this.connectionId), (Object)this);
    }

    public void setApplicationContext(ApplicationContextImpl applicationContext) {
        if (this.applicationContext != null) {
            this.applicationContext.removeApplicationContextListener(this);
        }
        this.applicationContext = applicationContext;
        if (this.applicationContext != null) {
            this.applicationContext.addApplicationContextListener(this);
        }
    }

    @Override
    public ApplicationContextImpl getApplicationContext() {
        return this.applicationContext;
    }

    public void setShutdownAdapter(ISessionShutdownAdapter adapter) {
        this.shutdownAdapter = adapter;
        if (this.shutdownAdapter != null) {
            this.shutdownAdapter.setUISession(this);
            this.shutdownAdapter.setShutdownCallback(new Runnable(){

                public void run() {
                    UISessionImpl.this.destroy();
                }
            });
        }
    }

    public ISessionShutdownAdapter getShutdownAdapter() {
        return this.shutdownAdapter;
    }

    @Override
    public void beforeDestroy(ApplicationContextEvent event) {
        this.shutdown();
    }

    public void shutdown() {
        this.getHttpSession().removeAttribute(UISessionImpl.getUISessionAttributeName(this.connectionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        ParamCheck.notNull(name, "name");
        Object result = null;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            result = this.attributes.get(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttribute(String name, Object value) {
        ParamCheck.notNull(name, "name");
        boolean result = false;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (this.bound) {
                result = true;
                this.attributes.put(name, value);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttribute(String name) {
        ParamCheck.notNull(name, "name");
        boolean result = false;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (this.bound) {
                result = true;
                this.attributes.remove(name);
            }
        }
        return result;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.createAttributeNameEnumeration();
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpSession getHttpSession() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return this.httpSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpSession(HttpSession httpSession) {
        ParamCheck.notNull(httpSession, "httpSession");
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.httpSession = httpSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBound() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return this.bound;
        }
    }

    @Override
    public Client getClient() {
        ClientSelector clientSelector = this.applicationContext.getClientSelector();
        return clientSelector.getSelectedClient(this);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Locale getLocale() {
        Locale locale = (Locale)this.getAttribute(ATTR_LOCALE);
        if (locale == null) {
            ClientInfo clientInfo = this.getClient().getService(ClientInfo.class);
            if (clientInfo != null) {
                locale = clientInfo.getLocale();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    @Override
    public void setLocale(Locale locale) {
        ClientMessages messages;
        Locale oldLocale = this.getLocale();
        this.setAttribute(ATTR_LOCALE, locale);
        Locale newLocale = this.getLocale();
        if (!newLocale.equals(oldLocale) && (messages = this.getClient().getService(ClientMessages.class)) != null) {
            messages.update(newLocale);
        }
    }

    @Override
    public void exec(Runnable runnable) {
        ParamCheck.notNull(runnable, "runnable");
        ContextUtil.runNonUIThreadWithFakeContext(this, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUISessionListener(UISessionListener listener) {
        ParamCheck.notNull(listener, "listener");
        boolean result = false;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (this.bound && !this.inDestroy) {
                result = true;
                this.listeners.add(listener);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUISessionListener(UISessionListener listener) {
        ParamCheck.notNull(listener, "listener");
        boolean result = false;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (this.bound && !this.inDestroy) {
                result = true;
                this.listeners.remove(listener);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueBound(HttpSessionBindingEvent event) {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.bound = true;
            this.inDestroy = false;
        }
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this.shutdownAdapter != null) {
            this.shutdownAdapter.interceptShutdown();
        } else {
            boolean fakeContext = false;
            if (!ContextProvider.hasContext()) {
                fakeContext = true;
                ServiceContext context = ContextUtil.createFakeContext(this);
                ContextProvider.setContext(context);
            }
            try {
                this.destroy();
            }
            finally {
                if (fakeContext) {
                    ContextProvider.releaseContextHolder();
                }
            }
        }
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    Object getRequestLock() {
        return this.requestLock;
    }

    private static String getUISessionAttributeName(String connectionId) {
        return String.valueOf(ATTR_UI_SESSION) + (connectionId == null ? "" : connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.inDestroy = true;
        }
        this.fireBeforeDestroy();
        serializableLock = this.lock;
        synchronized (serializableLock) {
            this.setApplicationContext(null);
            this.attributes.clear();
            this.listeners.clear();
            this.bound = false;
            this.inDestroy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeforeDestroy() {
        UISessionListener[] listenersCopy;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            int size = this.listeners.size();
            listenersCopy = this.listeners.toArray(new UISessionListener[size]);
        }
        UISessionEvent event = new UISessionEvent(this);
        UISessionListener[] uISessionListenerArray = listenersCopy;
        int n = listenersCopy.length;
        int n2 = 0;
        while (n2 < n) {
            UISessionListener listener = uISessionListenerArray[n2];
            try {
                listener.beforeDestroy(event);
            }
            catch (RuntimeException exception) {
                this.handleBeforeDestroyException(listener, exception);
            }
            ++n2;
        }
    }

    private void handleBeforeDestroyException(UISessionListener listener, RuntimeException exception) {
        String txt = "Could not execute {0}.beforeDestroy(UISessionEvent).";
        Object[] param = new Object[]{listener.getClass().getName()};
        String msg = MessageFormat.format(txt, param);
        this.httpSession.getServletContext().log(msg, (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration<String> createAttributeNameEnumeration() {
        HashSet<String> names;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            names = new HashSet<String>(this.attributes.keySet());
        }
        final Iterator iterator = names.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }
}

