/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetAdapter;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Widget;

public final class WidgetAdapterImpl
implements WidgetAdapter,
SerializableCompatibility {
    private static final Runnable[] EMPTY = new Runnable[0];
    private final String id;
    private boolean initialized;
    private transient Map<String, Object> preservedValues;
    private transient Runnable[] renderRunnables;
    private transient String cachedVariant;
    private Widget parent;

    public WidgetAdapterImpl(String id) {
        this.id = id;
        this.initialize();
    }

    private void initialize() {
        this.preservedValues = new HashMap<String, Object>();
    }

    public String getId() {
        return this.id;
    }

    public void setParent(Widget parent) {
        this.parent = parent;
    }

    public Widget getParent() {
        return this.parent;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void preserve(String propertyName, Object value) {
        this.preservedValues.put(propertyName, value);
    }

    public Object getPreserved(String propertyName) {
        return this.preservedValues.get(propertyName);
    }

    public void clearPreserved() {
        this.preservedValues.clear();
    }

    public void addRenderRunnable(Runnable renderRunnable) {
        if (this.renderRunnables == null) {
            this.renderRunnables = new Runnable[]{renderRunnable};
        } else {
            Runnable[] newRunnables = new Runnable[this.renderRunnables.length + 1];
            System.arraycopy(this.renderRunnables, 0, newRunnables, 0, this.renderRunnables.length);
            newRunnables[newRunnables.length - 1] = renderRunnable;
            this.renderRunnables = newRunnables;
        }
    }

    public Runnable[] getRenderRunnables() {
        return this.renderRunnables == null ? EMPTY : this.renderRunnables;
    }

    public void clearRenderRunnables() {
        this.renderRunnables = null;
    }

    public String getCachedVariant() {
        return this.cachedVariant;
    }

    public void setCachedVariant(String cachedVariant) {
        this.cachedVariant = cachedVariant;
    }

    public void markDisposed(Widget widget) {
        if (this.initialized) {
            DisposedWidgets.add(widget);
        }
    }

    private Object readResolve() {
        this.initialize();
        return this;
    }
}

