/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.io.IOException;
import java.util.List;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rap.rwt.internal.lifecycle.RequestCounter;
import org.eclipse.rap.rwt.internal.lifecycle.UITestUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.util.ActiveKeysUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapterImpl;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.displaykit.DNDSupport;
import org.eclipse.swt.internal.widgets.displaykit.DisplayOperationHandler;
import org.eclipse.swt.internal.widgets.displaykit.ServerPushRenderer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DisplayLCA
implements DisplayLifeCycleAdapter {
    private static final String PROP_REQUEST_COUNTER = "requestCounter";
    static final String PROP_FOCUS_CONTROL = "focusControl";
    static final String PROP_EXIT_CONFIRMATION = "exitConfirmation";
    private static final String METHOD_BEEP = "beep";
    private static final String PROP_RESIZE_LISTENER = "listener_Resize";

    public void readData(Display display) {
        DisplayLCA.handleOperations(display);
        DisplayLCA.visitWidgets(display);
        DNDSupport.handleOperations();
        RemoteObjectLifeCycleAdapter.readData(ProtocolUtil.getClientMessage());
    }

    public void preserveValues(Display display) {
        WidgetAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_FOCUS_CONTROL, display.getFocusControl());
        adapter.preserve(PROP_EXIT_CONFIRMATION, DisplayLCA.getExitConfirmation());
        adapter.preserve(PROP_RESIZE_LISTENER, DisplayLCA.hasResizeListener(display));
        ActiveKeysUtil.preserveActiveKeys(display);
        ActiveKeysUtil.preserveCancelKeys(display);
        ActiveKeysUtil.preserveMnemonicActivator(display);
        if (adapter.isInitialized()) {
            Shell[] shellArray = DisplayLCA.getShells(display);
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                WidgetTreeVisitor.accept(shell, new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                    public boolean doVisit(Widget widget) {
                        WidgetUtil.getLCA(widget).preserveValues(widget);
                        return true;
                    }
                });
                ++n2;
            }
        }
    }

    public void render(Display display) throws IOException {
        DisplayLCA.disposeWidgets();
        DisplayLCA.renderRequestCounter();
        DisplayLCA.renderExitConfirmation(display);
        DisplayLCA.renderEnableUiTests(display);
        DisplayLCA.renderShells(display);
        DisplayLCA.renderFocus(display);
        DisplayLCA.renderBeep(display);
        DisplayLCA.renderResizeListener(display);
        DisplayLCA.renderUICallBack(display);
        ActiveKeysUtil.renderActiveKeys(display);
        ActiveKeysUtil.renderCancelKeys(display);
        ActiveKeysUtil.renderMnemonicActivator(display);
        RemoteObjectLifeCycleAdapter.render();
        MeasurementUtil.renderMeasurementItems();
        DisplayLCA.runRenderRunnables(display);
        DisplayLCA.markInitialized(display);
    }

    public void clearPreserved(Display display) {
        ((WidgetAdapterImpl)DisplayUtil.getAdapter(display)).clearPreserved();
        Shell[] shellArray = DisplayLCA.getShells(display);
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            WidgetTreeVisitor.accept(shell, new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    ((WidgetAdapterImpl)WidgetUtil.getAdapter(widget)).clearPreserved();
                    return true;
                }
            });
            ++n2;
        }
    }

    private static void handleOperations(Display display) {
        ClientMessage clientMessage = ProtocolUtil.getClientMessage();
        List<Operation> operations = clientMessage.getAllOperationsFor(DisplayUtil.getId(display));
        if (!operations.isEmpty()) {
            DisplayOperationHandler handler = new DisplayOperationHandler(display);
            for (Operation operation : operations) {
                ProtocolUtil.handleOperation(handler, operation);
            }
        }
    }

    private static void visitWidgets(Display display) {
        WidgetTreeVisitor.AllWidgetTreeVisitor visitor = new WidgetTreeVisitor.AllWidgetTreeVisitor(){

            public boolean doVisit(Widget widget) {
                WidgetUtil.getLCA(widget).readData(widget);
                return true;
            }
        };
        Shell[] shellArray = DisplayLCA.getShells(display);
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            WidgetTreeVisitor.accept(shell, visitor);
            ++n2;
        }
    }

    private static void renderShells(Display display) throws IOException {
        RenderVisitor visitor = new RenderVisitor();
        Shell[] shellArray = DisplayLCA.getShells(display);
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            WidgetTreeVisitor.accept(shell, visitor);
            visitor.reThrowProblem();
            ++n2;
        }
    }

    private static void renderRequestCounter() {
        ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
        int requestId = RequestCounter.getInstance().nextRequestId();
        protocolWriter.appendHead(PROP_REQUEST_COUNTER, requestId);
    }

    private static void renderExitConfirmation(Display display) {
        boolean hasChanged;
        String exitConfirmation = DisplayLCA.getExitConfirmation();
        WidgetAdapter adapter = DisplayUtil.getAdapter(display);
        Object oldExitConfirmation = adapter.getPreserved(PROP_EXIT_CONFIRMATION);
        boolean bl = exitConfirmation == null ? oldExitConfirmation != null : (hasChanged = !exitConfirmation.equals(oldExitConfirmation));
        if (hasChanged) {
            RemoteObjectFactory.getRemoteObject(display).set(PROP_EXIT_CONFIRMATION, exitConfirmation);
        }
    }

    private static String getExitConfirmation() {
        ExitConfirmation exitConfirmation = RWT.getClient().getService(ExitConfirmation.class);
        return exitConfirmation == null ? null : exitConfirmation.getMessage();
    }

    private static void disposeWidgets() throws IOException {
        Widget[] widgetArray = DisposedWidgets.getAll();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            WidgetUtil.getLCA(widget).renderDispose(widget);
            ++n2;
        }
    }

    private static void renderFocus(Display display) {
        if (!display.isDisposed()) {
            Control focusControl;
            IDisplayAdapter displayAdapter = DisplayLCA.getDisplayAdapter(display);
            WidgetAdapter widgetAdapter = DisplayUtil.getAdapter(display);
            Object oldValue = widgetAdapter.getPreserved(PROP_FOCUS_CONTROL);
            if ((!widgetAdapter.isInitialized() || oldValue != display.getFocusControl() || displayAdapter.isFocusInvalidated()) && (focusControl = display.getFocusControl()) != null) {
                RemoteObjectFactory.getRemoteObject(display).set(PROP_FOCUS_CONTROL, WidgetUtil.getId(display.getFocusControl()));
            }
        }
    }

    private static void renderBeep(Display display) {
        IDisplayAdapter displayAdapter = DisplayLCA.getDisplayAdapter(display);
        if (displayAdapter.isBeepCalled()) {
            displayAdapter.resetBeep();
            RemoteObjectFactory.getRemoteObject(display).call(METHOD_BEEP, null);
        }
    }

    private static void renderResizeListener(Display display) {
        Boolean newValue;
        WidgetAdapter adapter = DisplayUtil.getAdapter(display);
        Boolean oldValue = (Boolean)adapter.getPreserved(PROP_RESIZE_LISTENER);
        if (oldValue == null) {
            oldValue = Boolean.FALSE;
        }
        if (!oldValue.equals(newValue = Boolean.valueOf(DisplayLCA.hasResizeListener(display)))) {
            RemoteObjectFactory.getRemoteObject(display).listen("Resize", newValue);
        }
    }

    private static void renderUICallBack(Display display) {
        new ServerPushRenderer().render();
    }

    private static void renderEnableUiTests(Display display) {
        if (UITestUtil.isEnabled() && !DisplayUtil.getAdapter(display).isInitialized()) {
            RemoteObjectFactory.getRemoteObject(display).set("enableUiTests", true);
        }
    }

    private static void runRenderRunnables(Display display) {
        WidgetAdapterImpl adapter = (WidgetAdapterImpl)DisplayUtil.getAdapter(display);
        Runnable[] runnableArray = adapter.getRenderRunnables();
        int n = runnableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable runnable = runnableArray[n2];
            runnable.run();
            ++n2;
        }
        adapter.clearRenderRunnables();
    }

    private static void markInitialized(Display display) {
        ((WidgetAdapterImpl)DisplayUtil.getAdapter(display)).setInitialized(true);
    }

    private static boolean hasResizeListener(Display display) {
        return DisplayLCA.getDisplayAdapter(display).isListening(11);
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        return display.getAdapter(IDisplayAdapter.class);
    }

    private static Shell[] getShells(Display display) {
        return DisplayLCA.getDisplayAdapter(display).getShells();
    }

    private static final class RenderVisitor
    extends WidgetTreeVisitor.AllWidgetTreeVisitor {
        private IOException ioProblem;

        private RenderVisitor() {
        }

        public boolean doVisit(Widget widget) {
            this.ioProblem = null;
            boolean result = true;
            try {
                RenderVisitor.render(widget);
                RenderVisitor.runRenderRunnables(widget);
            }
            catch (IOException ioe) {
                this.ioProblem = ioe;
                result = false;
            }
            return result;
        }

        private void reThrowProblem() throws IOException {
            if (this.ioProblem != null) {
                throw this.ioProblem;
            }
        }

        private static void render(Widget widget) throws IOException {
            WidgetUtil.getLCA(widget).render(widget);
        }

        private static void runRenderRunnables(Widget widget) {
            WidgetAdapterImpl adapter = (WidgetAdapterImpl)WidgetUtil.getAdapter(widget);
            Runnable[] runnableArray = adapter.getRenderRunnables();
            int n = runnableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Runnable runnable = runnableArray[n2];
                runnable.run();
                ++n2;
            }
            adapter.clearRenderRunnables();
        }
    }
}

