/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.application.EntryPointFactory;
import org.eclipse.rap.rwt.internal.lifecycle.DefaultEntryPointFactory;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.SettingStoreFactory;
import org.eclipse.rap.ui.internal.application.EntryPointApplicationWrapper;
import org.eclipse.rap.ui.internal.branding.AbstractBranding;
import org.eclipse.rap.ui.internal.branding.BrandingExtension;
import org.eclipse.rap.ui.internal.branding.BrandingManager;
import org.eclipse.rap.ui.internal.branding.BrandingUtil;
import org.eclipse.rap.ui.internal.preferences.WorkbenchFileSettingStoreFactory;
import org.eclipse.rap.ui.internal.servlet.ResourceReader;
import org.eclipse.rap.ui.internal.servlet.ResourceRegisterer;
import org.eclipse.rap.ui.resources.IResource;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbenchApplicationConfiguration
implements ApplicationConfiguration {
    private static final String ID_ENTRY_POINT = "org.eclipse.rap.ui.entrypoint";
    private static final String ID_THEMES = "org.eclipse.rap.ui.themes";
    private static final String ELEMENT_THEME = "theme";
    private static final String ELEMENT_THEME_CONTRIBUTION = "themeContribution";
    private static final String ID_THEMEABLE_WIDGETS = "org.eclipse.rap.ui.themeableWidgets";
    private static final String ID_SERVICE_HANDLER = "org.eclipse.rap.ui.serviceHandler";
    private static final String ID_SETTING_STORES = "org.eclipse.rap.ui.settingstores";
    private static final String PROP_SETTING_STORES_FACTORY = "org.eclipse.rap.rwt.settingStoreFactory";
    private static final String RUN = "run";
    private static final String PI_RUNTIME = "org.eclipse.core.runtime";
    private static final String PT_APPLICATIONS = "applications";
    private static final String PT_APP_VISIBLE = "visible";
    private final ServiceReference<HttpService> httpServiceReference;

    public WorkbenchApplicationConfiguration() {
        this.httpServiceReference = null;
    }

    public WorkbenchApplicationConfiguration(ServiceReference<HttpService> httpServiceReference) {
        this.httpServiceReference = httpServiceReference;
    }

    public void configure(Application application) {
        application.setOperationMode(Application.OperationMode.SWT_COMPATIBILITY);
        this.registerSettingStoreFactory(application);
        this.registerThemeableWidgets(application);
        this.registerThemes(application);
        this.registerThemeContributions(application);
        WorkbenchApplicationConfiguration.registerResources(application);
        this.registerServiceHandlers(application);
        this.registerBrandings(application);
        this.registerEntryPoints(application);
    }

    private void registerSettingStoreFactory(Application application) {
        SettingStoreFactory result = null;
        String factoryId = WorkbenchApplicationConfiguration.getOSGiProperty(PROP_SETTING_STORES_FACTORY);
        if (factoryId != null) {
            result = this.loadSettingStoreFactory(factoryId);
        }
        if (result == null) {
            result = new WorkbenchFileSettingStoreFactory();
        }
        application.setSettingStoreFactory(result);
    }

    private SettingStoreFactory loadSettingStoreFactory(String factoryId) {
        SettingStoreFactory result = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_SETTING_STORES);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute("id");
            if (factoryId.equals(id)) {
                result = this.loadSettingStoreFactory(elements[i]);
            }
            ++i;
        }
        if (result == null) {
            String msg = "Unable to find setting store factory with id '" + factoryId + "'.";
            WorkbenchPlugin.log(msg);
        }
        return result;
    }

    private SettingStoreFactory loadSettingStoreFactory(IConfigurationElement element) {
        SettingStoreFactory result = null;
        try {
            result = (SettingStoreFactory)element.createExecutableExtension("class");
        }
        catch (CoreException cex) {
            WorkbenchPlugin.log(cex.getStatus());
        }
        return result;
    }

    private static String getOSGiProperty(String name) {
        Bundle systemBundle = Platform.getBundle((String)"system.bundle");
        return systemBundle.getBundleContext().getProperty(name);
    }

    private void registerEntryPoints(Application application) {
        IConfigurationElement[] iConfigurationElementArray = WorkbenchApplicationConfiguration.getEntryPointExtensions();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute("id");
            String path = element.getAttribute("path");
            String className = element.getAttribute("class");
            String applicationId = element.getAttribute("applicationId");
            String brandingId = element.getAttribute("brandingId");
            try {
                EntryPointFactory entryPointFactory;
                if (className != null) {
                    Class entryPointClass = (Class)WorkbenchApplicationConfiguration.loadClass(className, element);
                    entryPointFactory = new DefaultEntryPointFactory(entryPointClass);
                } else if (applicationId != null) {
                    entryPointFactory = this.createEntryPointFactoryForApplication(applicationId);
                } else {
                    throw new IllegalArgumentException("Neither class nor applicationId specified");
                }
                Map<String, String> properties = this.getBrandingProperties(brandingId);
                application.addEntryPoint(path, entryPointFactory, properties);
            }
            catch (Throwable thr) {
                String text = "Could not register entry point ''{0}'' with id ''{1}''.";
                Object[] param = new Object[]{className, id};
                WorkbenchApplicationConfiguration.logProblem(text, param, thr, element.getContributor().getName());
            }
            ++n2;
        }
    }

    private EntryPointFactory createEntryPointFactoryForApplication(String applicationId) throws ClassNotFoundException {
        String extensionPointId;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtension extension = extensionRegistry.getExtension(extensionPointId = "org.eclipse.core.runtime.applications", applicationId);
        if (extension == null) {
            String message = "Application extension not found by id: " + applicationId;
            throw new IllegalArgumentException(message);
        }
        IConfigurationElement configElement = extension.getConfigurationElements()[0];
        String isVisible = configElement.getAttribute(PT_APP_VISIBLE);
        if (isVisible != null && !Boolean.valueOf(isVisible).booleanValue()) {
            throw new IllegalArgumentException("Application is not visible:" + applicationId);
        }
        IConfigurationElement[] runElement = configElement.getChildren(RUN);
        String className = runElement[0].getAttribute("class");
        Class applicationClass = (Class)WorkbenchApplicationConfiguration.loadClass(className, configElement);
        return WorkbenchApplicationConfiguration.createApplicationEntryPointFactory(applicationClass);
    }

    private static EntryPointFactory createApplicationEntryPointFactory(final Class<? extends IApplication> applicationClass) {
        return new EntryPointFactory(){

            public EntryPoint create() {
                return new EntryPointApplicationWrapper(applicationClass);
            }
        };
    }

    private void registerThemeableWidgets(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMEABLE_WIDGETS);
        IConfigurationElement[] widgetExts = ep.getConfigurationElements();
        int i = 0;
        while (i < widgetExts.length) {
            String contributorName = widgetExts[i].getContributor().getName();
            String widgetClass = widgetExts[i].getAttribute("class");
            try {
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class widget = bundle.loadClass(widgetClass);
                application.addThemableWidget(widget);
            }
            catch (Throwable thr) {
                String text = "Could not register themeable widget ''{0}''.";
                Object[] param = new Object[]{widgetClass};
                WorkbenchApplicationConfiguration.logProblem(text, param, thr, contributorName);
            }
            ++i;
        }
    }

    private void registerThemes(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (ELEMENT_THEME.equals(elements[i].getName())) {
                String contributorName = elements[i].getContributor().getName();
                String themeId = elements[i].getAttribute("id");
                String themeFile = elements[i].getAttribute("file");
                try {
                    Bundle bundle = Platform.getBundle((String)contributorName);
                    ResourceLoader resourceLoader = WorkbenchApplicationConfiguration.createThemeResourceLoader(bundle);
                    application.addStyleSheet(themeId, themeFile, resourceLoader);
                }
                catch (Exception e) {
                    String text = "Could not register custom theme ''{0}'' from file ''{1}''.";
                    Object[] param = new Object[]{themeId, themeFile};
                    WorkbenchApplicationConfiguration.logProblem(text, param, e, contributorName);
                }
            }
            ++i;
        }
    }

    private void registerThemeContributions(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (ELEMENT_THEME_CONTRIBUTION.equals(elements[i].getName())) {
                String contributorName = elements[i].getContributor().getName();
                String themeId = elements[i].getAttribute("themeId");
                String themeFile = elements[i].getAttribute("file");
                try {
                    Bundle bundle = Platform.getBundle((String)contributorName);
                    ResourceLoader loader = WorkbenchApplicationConfiguration.createThemeResourceLoader(bundle);
                    application.addStyleSheet(themeId, themeFile, loader);
                }
                catch (Exception e) {
                    String text = "Could not register contribution for theme ''{0}'' from file ''{1}''.";
                    Object[] param = new Object[]{themeId, themeFile};
                    WorkbenchApplicationConfiguration.logProblem(text, param, e, contributorName);
                }
            }
            ++i;
        }
    }

    private static void registerResources(Application application) {
        List<IResource> resources = ResourceReader.readResources();
        new ResourceRegisterer(application).registerResources(resources);
    }

    private static ResourceLoader createThemeResourceLoader(final Bundle bundle) {
        ResourceLoader result = new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                InputStream result = null;
                Path path = new Path(resourceName);
                URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                if (url != null) {
                    result = url.openStream();
                }
                return result;
            }
        };
        return result;
    }

    private void registerServiceHandlers(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_SERVICE_HANDLER);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            try {
                String id = elements[i].getAttribute("id");
                if (id != null) {
                    Object extObject = elements[i].createExecutableExtension("class");
                    ServiceHandler handler = (ServiceHandler)extObject;
                    application.addServiceHandler(id, handler);
                }
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }

    private void registerBrandings(Application application) {
        try {
            new BrandingExtension(application, this.httpServiceReference).read();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to read branding extension", ioe);
        }
    }

    private static AbstractBranding findBrandingById(String id) {
        AbstractBranding[] brandings;
        AbstractBranding result = null;
        AbstractBranding[] abstractBrandingArray = brandings = BrandingManager.getInstance().getAll();
        int n = brandings.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractBranding branding = abstractBrandingArray[n2];
            if (branding.getId() != null && branding.getId().equals(id)) {
                result = branding;
            }
            ++n2;
        }
        return result;
    }

    private Map<String, String> getBrandingProperties(String brandingId) {
        AbstractBranding branding = WorkbenchApplicationConfiguration.findBrandingById(brandingId);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("org.eclipse.rap.ui.branding", brandingId);
        if (branding != null) {
            result.put("org.eclipse.rap.rwt.webclient.themeId", branding.getThemeId());
            result.put("org.eclipse.rap.rwt.webclient.bodyHtml", branding.getBody());
            result.put("org.eclipse.rap.rwt.webclient.pageTitle", branding.getTitle());
            result.put("org.eclipse.rap.rwt.webclient.favicon", branding.getFavIcon());
            result.put("org.eclipse.rap.rwt.webclient.additionalHeaders", BrandingUtil.headerMarkup(branding));
        }
        return result;
    }

    private static IConfigurationElement[] getEntryPointExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ID_ENTRY_POINT);
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        return elements;
    }

    private static void logProblem(String text, Object[] textParams, Throwable problem, String bundleId) {
        String msg = MessageFormat.format(text, textParams);
        Status status = new Status(4, bundleId, 0, msg, problem);
        WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
    }

    private static <T> T loadClass(String className, IConfigurationElement element) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        return (T)bundle.loadClass(className);
    }
}

