/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ScriptingTab
extends ExampleTab {
    private static final String[] WIDGETS = new String[]{"Text", "Button", "Label", "Canvas"};
    private static final int WIDGET_TEXT = 0;
    private static final int WIDGET_BUTTON = 1;
    private static final int WIDGET_LABEL = 2;
    private static final int WIDGET_CANVAS = 3;
    private static final String[] EVENT_TYPES = new String[]{"KeyDown", "KeyUp", "MouseDown", "MouseUp", "MouseMove", "MouseEnter", "MouseExit", "MouseDoubleClick", "Paint", "Selection", "DefaultSelection", "FocusIn", "FocusOut", "Show", "Hide", "Modify", "Verify", "MouseWheel"};
    private Button button;
    private String buttonScript;
    private int[] buttonEventTypeIndex;
    private Text text;
    private String textScript;
    private int[] textEventTypeIndex;
    private Label label;
    private String labelScript;
    private int[] labelEventTypeIndex;
    private Canvas canvas;
    private String canvasScript;
    private int[] canvasEventTypeIndex;
    private Text script;
    private Combo widgetCombo;
    private List typeList;

    public ScriptingTab() {
        super("Scripting");
        WidgetUtil.registerDataKeys((String[])new String[]{"text", "button", "label", "canvas"});
        this.initListener();
    }

    protected void createStyleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.widgetCombo = new Combo(parent, 12);
        this.widgetCombo.setItems(WIDGETS);
        this.widgetCombo.select(1);
        this.widgetCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ScriptingTab.this.fillStyleControls();
            }
        });
        this.script = new Text(parent, 2050);
        this.script.setLayoutData((Object)new GridData(500, 300));
        this.script.setFont(new Font((Device)this.script.getDisplay(), "Courier New", 12, 0));
        this.script.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ScriptingTab.this.storeScript();
            }
        });
        this.typeList = new List(parent, 2562);
        this.typeList.setItems(EVENT_TYPES);
        this.typeList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ScriptingTab.this.storeEventType();
            }
        });
        this.typeList.setLayoutData((Object)new GridData(-1, 100));
        Button set = new Button(parent, 8);
        set.setText("set");
        set.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ScriptingTab.this.createNew();
            }
        });
        this.fillStyleControls();
    }

    private void connectWidgets() {
        Widget[] widgets;
        Widget[] widgetArray = widgets = new Widget[]{this.text, this.button, this.label, this.canvas};
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            widget.setData("text", (Object)WidgetUtil.getId((Widget)this.text));
            widget.setData("label", (Object)WidgetUtil.getId((Widget)this.label));
            widget.setData("button", (Object)WidgetUtil.getId((Widget)this.button));
            widget.setData("canvs", (Object)WidgetUtil.getId((Widget)this.canvas));
            ++n2;
        }
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.text = new Text(parent, 2052);
        this.text.setText("Text");
        this.text.setLayoutData((Object)new GridData(150, 25));
        this.attachTextListener();
        this.button = new Button(parent, this.getStyle() | 8);
        this.button.setText("Button");
        this.button.setLayoutData((Object)new GridData(150, 25));
        this.attachButtonListener();
        this.label = new Label(parent, 2048);
        this.label.setLayoutData((Object)new GridData(150, 25));
        this.label.setText("Label");
        this.attachLabelListener();
        this.canvas = new Canvas(parent, 2048);
        this.canvas.setLayoutData((Object)new GridData(300, 300));
        this.attachCanvasListener();
        this.connectWidgets();
    }

    private void fillStyleControls() {
        switch (this.widgetCombo.getSelectionIndex()) {
            case 0: {
                this.script.setText(this.textScript);
                this.typeList.setSelection(this.textEventTypeIndex);
                break;
            }
            case 1: {
                this.script.setText(this.buttonScript);
                this.typeList.setSelection(this.buttonEventTypeIndex);
                break;
            }
            case 2: {
                this.script.setText(this.labelScript);
                this.typeList.setSelection(this.labelEventTypeIndex);
                break;
            }
            case 3: {
                this.script.setText(this.canvasScript);
                this.typeList.setSelection(this.canvasEventTypeIndex);
            }
        }
        this.typeList.showSelection();
    }

    private void storeEventType() {
        switch (this.widgetCombo.getSelectionIndex()) {
            case 0: {
                this.textEventTypeIndex = this.typeList.getSelectionIndices();
                break;
            }
            case 1: {
                this.buttonEventTypeIndex = this.typeList.getSelectionIndices();
                break;
            }
            case 2: {
                this.labelEventTypeIndex = this.typeList.getSelectionIndices();
                break;
            }
            case 3: {
                this.canvasEventTypeIndex = this.typeList.getSelectionIndices();
            }
        }
    }

    private void storeScript() {
        switch (this.widgetCombo.getSelectionIndex()) {
            case 0: {
                this.textScript = this.script.getText();
                break;
            }
            case 1: {
                this.buttonScript = this.script.getText();
                break;
            }
            case 2: {
                this.labelScript = this.script.getText();
                break;
            }
            case 3: {
                this.canvasScript = this.script.getText();
            }
        }
    }

    private void attachCanvasListener() {
        ClientListener listener = new ClientListener(this.canvasScript);
        int[] nArray = this.canvasEventTypeIndex;
        int n = this.canvasEventTypeIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int eventTypeIndex = nArray[n2];
            this.canvas.addListener(this.getEventType(eventTypeIndex), (Listener)listener);
            ++n2;
        }
    }

    private void attachLabelListener() {
        ClientListener listener = new ClientListener(this.labelScript);
        int[] nArray = this.labelEventTypeIndex;
        int n = this.labelEventTypeIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int eventTypeIndex = nArray[n2];
            this.label.addListener(this.getEventType(eventTypeIndex), (Listener)listener);
            ++n2;
        }
    }

    private void attachButtonListener() {
        ClientListener listener = new ClientListener(this.buttonScript);
        int[] nArray = this.buttonEventTypeIndex;
        int n = this.buttonEventTypeIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int eventTypeIndex = nArray[n2];
            this.button.addListener(this.getEventType(eventTypeIndex), (Listener)listener);
            ++n2;
        }
    }

    private void attachTextListener() {
        ClientListener listener = new ClientListener(this.textScript);
        int[] nArray = this.textEventTypeIndex;
        int n = this.textEventTypeIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int eventTypeIndex = nArray[n2];
            this.text.addListener(this.getEventType(eventTypeIndex), (Listener)listener);
            ++n2;
        }
    }

    private int getEventType(int typeIndex) {
        String typeString = EVENT_TYPES[typeIndex];
        try {
            Field field = SWT.class.getField(typeString);
            return field.getInt(null);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void initListener() {
        this.initTextListener();
        this.initButtonListener();
        this.initLabelListener();
        this.initCanvasListener();
    }

    private void initTextListener() {
        this.textScript = "var handleEvent = function( event ) {\n  event.doit = isNumber( event.character ) || event.text.length == 0;\n};\n\nvar isNumber = function( character ) {\n  var charCode = character.charCodeAt( 0 );\n  return charCode >=48 && charCode <= 57;\n};";
        this.textEventTypeIndex = new int[]{Arrays.asList(EVENT_TYPES).indexOf("Verify")};
    }

    private void initButtonListener() {
        this.buttonScript = "var handleEvent = function( event ) {\n  var widget = event.widget;\n  var label = rap.getObject( widget.getData( \"label\" ) );\n  label.setBackground( [ randomByte(), randomByte(), randomByte() ] );\n};\n\nvar randomByte = function() {\n  return Math.round( Math.random() * 255 );\n}\n";
        this.buttonEventTypeIndex = new int[]{Arrays.asList(EVENT_TYPES).indexOf("MouseDown")};
    }

    private void initCanvasListener() {
        this.canvasScript = "var points = [];\n\nvar handleEvent = function( event ) {\n  switch( event.type ) {\n    case SWT.MouseMove:\n      points.push( [ event.x, event.y ] );\n      event.widget.redraw();\n    break;\n    case SWT.Paint:\n      if( points.length > 1 ) {\n        event.gc.lineWidth = 4;\n        event.gc.beginPath();\n        event.gc.moveTo( points[ 0 ][ 0 ], points[ 0 ][ 1 ] );\n        for( var i = 1; i < points.length; i++ ) {\n          event.gc.lineTo( points[ i ][ 0 ] , points[ i ][ 1 ] );\n        }\n        event.gc.stroke();\n      }\n    break;\n  }\n};";
        this.canvasEventTypeIndex = new int[]{Arrays.asList(EVENT_TYPES).indexOf("Paint"), Arrays.asList(EVENT_TYPES).indexOf("MouseMove")};
    }

    private void initLabelListener() {
        this.labelScript = "function handleEvent( event ){\n  var color = event.type == SWT.MouseEnter ? [ 255, 0, 0 ] : null;\n  event.widget.setForeground( color );\n}\n";
        this.labelEventTypeIndex = new int[]{Arrays.asList(EVENT_TYPES).indexOf("MouseEnter"), Arrays.asList(EVENT_TYPES).indexOf("MouseExit")};
    }
}

