/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class VariantsTab
extends ExampleTab {
    private static final String BUTTON_IMAGE_PATH = "resources/button-image.gif";
    private static final String[] VARIANTS_SPECIAL = new String[]{"none", "special-red", "special-blue"};
    private Combo variantsCombo;
    private Button myButton;
    private Combo myCombo;
    private Label myLabel;
    private Link myLink;
    private Text myText;
    private List myList;
    private Tree myTree;

    public VariantsTab() {
        super("Variants");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("FLAT", 0x800000);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createFontChooser();
        String text = "Custom Variant:";
        this.variantsCombo = this.createVariantsCombo(text);
    }

    protected void createExampleControls(final Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(parent, 0);
        label.setText("Use custom theme to see the effect of widget variants.");
        int style = this.getStyle();
        this.myButton = new Button(parent, style | 8);
        this.myButton.setText("Push Button");
        this.myButton.setImage(Util.loadImage(this.myButton.getDisplay(), BUTTON_IMAGE_PATH));
        this.myButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getVariant());
        this.registerControl((Control)this.myButton);
        this.myCombo = new Combo(parent, style);
        this.myCombo.setItems(new String[]{"Item 1", "Item 2", "Item 3"});
        this.myCombo.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getVariant());
        this.registerControl((Control)this.myCombo);
        this.myLabel = new Label(parent, style);
        this.myLabel.setLayoutData((Object)new GridData(768));
        this.myLabel.setText("Customized Label");
        this.myLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getVariant());
        this.registerControl((Control)this.myLabel);
        this.myLink = new Link(parent, style);
        this.myLink.setLayoutData((Object)new GridData(768));
        this.myLink.setText("Customized <a>Link</a>");
        this.myLink.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getVariant());
        this.registerControl((Control)this.myLink);
        this.myText = new Text(parent, style);
        this.myText.setLayoutData((Object)new GridData(768));
        this.myText.setText("Customized Text");
        this.myText.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getVariant());
        this.registerControl((Control)this.myText);
        this.myList = new List(parent, style);
        this.myList.setLayoutData((Object)new GridData(768));
        this.myList.add("List Item 1");
        this.myList.add("List Item 2");
        this.myList.add("List Item 3");
        this.myList.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getVariant());
        this.registerControl((Control)this.myList);
        this.myTree = new Tree(parent, style);
        this.myTree.setLayoutData((Object)new GridData(768));
        int i = 0;
        while (i < 3) {
            TreeItem item = new TreeItem(this.myTree, 0);
            item.setText("Node_" + (i + 1));
            if (i < 1) {
                TreeItem subitem = new TreeItem(item, 0);
                subitem.setText("Subnode_" + (i + 1));
            }
            ++i;
        }
        this.myTree.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getVariant());
        this.registerControl((Control)this.myTree);
        Button myShellButton = new Button(parent, style | 8);
        myShellButton.setText("Open customized Shell");
        myShellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell myShell = new Shell(parent.getShell(), 65600);
                myShell.setText("My Shell");
                myShell.setSize(200, 150);
                myShell.setData("org.eclipse.rap.rwt.customVariant", (Object)VariantsTab.this.getVariant());
                myShell.open();
            }
        });
    }

    protected Combo createVariantsCombo(String text) {
        Composite group = new Composite(this.styleComp, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        new Label(group, 0).setText(text);
        Combo combo = new Combo(group, 8);
        combo.setItems(VARIANTS_SPECIAL);
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariantsTab.this.setCustomVariant(VariantsTab.this.getVariant());
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                VariantsTab.this.setCustomVariant(VariantsTab.this.getVariant());
            }
        });
        return combo;
    }

    private void setCustomVariant(String variant) {
        this.myButton.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        this.myCombo.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        this.myLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        this.myLink.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        this.myText.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        this.myList.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        this.myTree.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
    }

    private String getVariant() {
        int index;
        String selection = null;
        if (this.checkControl((Control)this.variantsCombo) && (index = this.variantsCombo.getSelectionIndex()) > 0) {
            selection = this.variantsCombo.getItem(index);
        }
        return selection;
    }
}

