/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.presentation;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.rap.demo.DemoActionBarAdvisor;
import org.eclipse.rap.demo.presentation.ActionBar;
import org.eclipse.rap.demo.presentation.ActionBarButton;
import org.eclipse.rap.demo.presentation.Images;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class DemoPresentationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final int BANNER_HEIGTH = 88;

    public DemoPresentationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new DemoActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(false);
        configurer.setTitle("Presentation Prototype");
        configurer.setShellStyle(0);
        Rectangle bounds = Display.getDefault().getBounds();
        configurer.setInitialSize(new Point(bounds.width, bounds.height));
    }

    public void postWindowOpen() {
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        Shell shell = window.getShell();
        shell.setMaximized(true);
    }

    public void createWindowContents(Shell shell) {
        shell.setBackground(shell.getDisplay().getSystemColor(1));
        shell.setLayout((Layout)new FormLayout());
        this.createBanner(shell);
        this.createPageComposite(shell);
    }

    private void createBanner(Shell shell) {
        Display display = shell.getDisplay();
        Composite banner = new Composite((Composite)shell, 0);
        banner.setBackgroundMode(1);
        banner.setData("org.eclipse.rap.rwt.customVariant", (Object)"banner");
        FormData fdBanner = new FormData();
        banner.setLayoutData((Object)fdBanner);
        fdBanner.top = new FormAttachment(0, 0);
        fdBanner.left = new FormAttachment(0, 50);
        fdBanner.height = 88;
        fdBanner.right = new FormAttachment(100, -50);
        banner.setLayout((Layout)new FormLayout());
        banner.setBackgroundImage(Images.IMG_BANNER_BG);
        Label label = new Label(banner, 0);
        label.setText("RAP Demo");
        label.setForeground(display.getSystemColor(1));
        label.setFont(new Font((Device)display, "Verdana", 38, 1));
        label.pack();
        FormData fdLabel = new FormData();
        label.setLayoutData((Object)fdLabel);
        fdLabel.top = new FormAttachment(0, 5);
        fdLabel.left = new FormAttachment(0, 10);
        Label roundedCornerLeft = new Label(banner, 0);
        roundedCornerLeft.setImage(Images.IMG_BANNER_ROUNDED_LEFT);
        roundedCornerLeft.pack();
        FormData fdRoundedCornerLeft = new FormData();
        roundedCornerLeft.setLayoutData((Object)fdRoundedCornerLeft);
        fdRoundedCornerLeft.top = new FormAttachment(100, -5);
        fdRoundedCornerLeft.left = new FormAttachment(0, 0);
        roundedCornerLeft.moveAbove((Control)banner);
        Label roundedCornerRight = new Label(banner, 0);
        roundedCornerRight.setImage(Images.IMG_BANNER_ROUNDED_RIGHT);
        roundedCornerRight.pack();
        FormData fdRoundedCornerRight = new FormData();
        roundedCornerRight.setLayoutData((Object)fdRoundedCornerRight);
        fdRoundedCornerRight.top = new FormAttachment(100, -5);
        fdRoundedCornerRight.left = new FormAttachment(100, -5);
        roundedCornerRight.moveAbove((Control)banner);
        this.createMenuBar(banner);
        this.createCoolBar(banner, (Control)label);
    }

    private void createCoolBar(Composite banner, Control leftControl) {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Composite coolBar = (Composite)configurer.createCoolBarControl(banner);
        coolBar.setBackgroundMode(2);
        FormData fdCoolBar = new FormData();
        coolBar.setLayoutData((Object)fdCoolBar);
        fdCoolBar.top = new FormAttachment(0, 8);
        fdCoolBar.left = new FormAttachment(leftControl, 35);
        fdCoolBar.bottom = new FormAttachment(0, 26);
    }

    private void createMenuBar(final Composite banner) {
        final Composite menuBar = new Composite(banner, 0);
        menuBar.setBackgroundMode(2);
        FormData fdMenuBar = new FormData();
        menuBar.setLayoutData((Object)fdMenuBar);
        fdMenuBar.top = new FormAttachment(100, -26);
        fdMenuBar.left = new FormAttachment(0, 10);
        fdMenuBar.bottom = new FormAttachment(100, -8);
        final ApplicationWindow window = (ApplicationWindow)this.getWindowConfigurer().getWindow();
        MenuManager menuBarManager = window.getMenuBarManager();
        IContributionItem[] menuBarItems = menuBarManager.getItems();
        ArrayList<1> actions = new ArrayList<1>();
        int i = 0;
        while (i < menuBarItems.length) {
            final MenuManager menuManager = (MenuManager)menuBarItems[i];
            actions.add(new Action(){

                public String getId() {
                    return menuManager.getId();
                }

                public String getText() {
                    return menuManager.getMenuText();
                }

                public void run() {
                    Shell shell = window.getShell();
                    final Color background = new Color((Device)shell.getDisplay(), 9, 34, 60);
                    final PopupDialog popupDialog = new PopupDialog(shell, 16400, false, false, false, false, null, null){

                        protected Control createDialogArea(Composite parent) {
                            Composite popup = new Composite(parent, 0);
                            popup.setBackgroundMode(2);
                            popup.setLayout((Layout)new FormLayout());
                            popup.setBackground(background);
                            Label roundedCornerLeft = new Label(popup, 0);
                            roundedCornerLeft.setImage(Images.IMG_BANNER_ROUNDED_LEFT);
                            roundedCornerLeft.pack();
                            FormData fdRoundedCornerLeft = new FormData();
                            roundedCornerLeft.setLayoutData((Object)fdRoundedCornerLeft);
                            fdRoundedCornerLeft.top = new FormAttachment(100, -5);
                            fdRoundedCornerLeft.left = new FormAttachment(0, 0);
                            Label roundedCornerRight = new Label(popup, 0);
                            roundedCornerRight.setImage(Images.IMG_BANNER_ROUNDED_RIGHT);
                            roundedCornerRight.pack();
                            FormData fdRoundedCornerRight = new FormData();
                            roundedCornerRight.setLayoutData((Object)fdRoundedCornerRight);
                            fdRoundedCornerRight.top = new FormAttachment(100, -5);
                            fdRoundedCornerRight.left = new FormAttachment(100, -5);
                            Composite content = new Composite(popup, 0);
                            FormData fdContent = new FormData();
                            content.setLayoutData((Object)fdContent);
                            fdContent.top = new FormAttachment(0, 5);
                            fdContent.left = new FormAttachment(0, 14);
                            content.setLayout((Layout)new FillLayout(512));
                            IContributionItem[] menuItems = menuManager.getItems();
                            int j = 0;
                            while (j < menuItems.length) {
                                IContributionItem contributionItem = menuItems[j];
                                if (contributionItem instanceof ActionContributionItem) {
                                    ActionContributionItem actionItem = (ActionContributionItem)contributionItem;
                                    Action action = (Action)actionItem.getAction();
                                    new ActionBarButton(action, content){

                                        public void run() {
                                            this.close();
                                            super.run();
                                        }
                                    };
                                }
                                ++j;
                            }
                            content.pack();
                            return popup;
                        }
                    };
                    final Composite popup = new Composite((Composite)shell, 0);
                    popup.setBackgroundMode(2);
                    popup.setLayout((Layout)new FormLayout());
                    Label roundedCornerLeft = new Label(popup, 0);
                    roundedCornerLeft.setImage(Images.IMG_BANNER_ROUNDED_LEFT);
                    roundedCornerLeft.pack();
                    FormData fdRoundedCornerLeft = new FormData();
                    roundedCornerLeft.setLayoutData((Object)fdRoundedCornerLeft);
                    fdRoundedCornerLeft.top = new FormAttachment(100, -5);
                    fdRoundedCornerLeft.left = new FormAttachment(0, 0);
                    roundedCornerLeft.moveAbove((Control)banner);
                    Label roundedCornerRight = new Label(popup, 0);
                    roundedCornerRight.setImage(Images.IMG_BANNER_ROUNDED_RIGHT);
                    roundedCornerRight.pack();
                    FormData fdRoundedCornerRight = new FormData();
                    roundedCornerRight.setLayoutData((Object)fdRoundedCornerRight);
                    fdRoundedCornerRight.top = new FormAttachment(100, -5);
                    fdRoundedCornerRight.left = new FormAttachment(100, -5);
                    roundedCornerRight.moveAbove((Control)banner);
                    final Composite content = new Composite(popup, 0);
                    FormData fdContent = new FormData();
                    content.setLayoutData((Object)fdContent);
                    fdContent.top = new FormAttachment(0, 5);
                    fdContent.left = new FormAttachment(0, 14);
                    content.setLayout((Layout)new FillLayout(512));
                    IContributionItem[] menuItems = menuManager.getItems();
                    int j = 0;
                    while (j < menuItems.length) {
                        IContributionItem contributionItem = menuItems[j];
                        if (contributionItem instanceof ActionContributionItem) {
                            ActionContributionItem actionItem = (ActionContributionItem)contributionItem;
                            Action action = (Action)actionItem.getAction();
                            new ActionBarButton(action, content);
                        }
                        ++j;
                    }
                    content.pack();
                    popup.setBackground(background);
                    Rectangle popUpBounds = this.calculatePopUpBounds(banner, menuBar, content);
                    popup.setBounds(popUpBounds);
                    shell.addControlListener((ControlListener)new ControlAdapter(){

                        public void controlResized(ControlEvent e) {
                            Rectangle popUpBounds = this.calculatePopUpBounds(banner, menuBar, content);
                            popup.setBounds(popUpBounds);
                        }
                    });
                    popup.moveAbove(null);
                    popupDialog.open();
                    Listener closeListener = new Listener(){

                        public void handleEvent(Event event) {
                            if (popupDialog.getShell() != null) {
                                popupDialog.getShell().removeListener(21, (Listener)this);
                                popupDialog.getShell().removeListener(27, (Listener)this);
                                popupDialog.getShell().removeListener(12, (Listener)this);
                                popupDialog.close();
                            }
                            if (!popup.isDisposed()) {
                                popup.dispose();
                            }
                        }
                    };
                    popupDialog.getShell().addListener(27, closeListener);
                    popupDialog.getShell().addListener(21, closeListener);
                    popupDialog.getShell().addListener(12, closeListener);
                    popupDialog.getShell().setAlpha(0);
                    popupDialog.getShell().setActive();
                    popupDialog.getShell().setBounds(popUpBounds);
                }

                private Rectangle calculatePopUpBounds(Composite banner2, Composite menuBar2, Composite content) {
                    Rectangle menuBarBounds = menuBar2.getBounds();
                    Rectangle bannerBounds = banner2.getBounds();
                    Display display = menuBar2.getDisplay();
                    Shell shell = menuBar2.getShell();
                    Point bannerPosition = display.map((Control)banner2.getParent(), (Control)shell, banner2.getLocation());
                    return new Rectangle(bannerPosition.x, bannerBounds.height - 5, menuBarBounds.width + 10, content.getSize().y + 10);
                }
            });
            ++i;
        }
        ActionBar.create(actions, menuBar);
    }

    private void createPageComposite(Shell shell) {
        final Color shellBackground = shell.getDisplay().getSystemColor(1);
        Composite content = new Composite((Composite)shell, 0);
        content.setBackground(shellBackground);
        FormData fdContent = new FormData();
        content.setLayoutData((Object)fdContent);
        fdContent.top = new FormAttachment(0, 92);
        fdContent.left = new FormAttachment(0, 43);
        fdContent.right = new FormAttachment(100, -43);
        fdContent.bottom = new FormAttachment(100, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 3;
        content.setLayout((Layout)fillLayout);
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        final Composite composite = (Composite)configurer.createPageComposite(content);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    children[i].setBackground(shellBackground);
                    ++i;
                }
            }
        });
    }
}

