/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseId;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.testfixture.TestServletContext;
import org.eclipse.rap.rwt.testfixture.TestSession;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestContext
implements TestRule {
    private ApplicationContextImpl applicationContext;
    private UISession uiSession;

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    TestContext.this.setup(description);
                    base.evaluate();
                }
                finally {
                    TestContext.this.tearDown();
                }
            }
        };
    }

    public UISession getUISession() {
        return this.uiSession;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private void setup(Description description) {
        ApplicationConfiguration config = TestContext.createApplicationConfiguration();
        this.applicationContext = TestContext.createApplicationContext(config);
        this.uiSession = new UISessionImpl(this.applicationContext, (HttpSession)new TestSession());
        ContextProvider.setContext((ServiceContext)TestContext.createServiceContext(this.applicationContext, this.uiSession));
        SingletonManager.install((UISession)this.uiSession);
        MeasurementUtil.installMeasurementOperator((UISession)this.uiSession);
        ThemeUtil.setCurrentThemeId((UISession)this.uiSession, (String)"org.eclipse.rap.rwt.theme.Default");
        ProtocolUtil.setClientMessage((ClientMessage)TestContext.createMessage());
        CurrentPhase.set((PhaseId)PhaseId.PROCESS_ACTION);
    }

    private void tearDown() {
        this.uiSession = null;
        this.applicationContext = null;
        ContextProvider.disposeContext();
    }

    private static ApplicationConfiguration createApplicationConfiguration() {
        ContextProvider.disposeContext();
        return new ApplicationConfiguration(){

            public void configure(Application application) {
            }
        };
    }

    private static ApplicationContextImpl createApplicationContext(ApplicationConfiguration config) {
        TestServletContext servletContext = new TestServletContext();
        ApplicationContextImpl appContext = new ApplicationContextImpl(config, (ServletContext)servletContext);
        appContext.activate();
        return appContext;
    }

    private static ServiceContext createServiceContext(ApplicationContextImpl applicationContext, UISession uiSession) {
        ServiceContext serviceContext = new ServiceContext(null, null, applicationContext);
        serviceContext.setServiceStore(new ServiceStore());
        serviceContext.setUISession(uiSession);
        return serviceContext;
    }

    private static ClientMessage createMessage() {
        JsonObject json = new JsonObject().add("head", (JsonValue)new JsonObject()).add("operations", (JsonValue)new JsonArray());
        return new ClientMessage(json);
    }
}

