/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.zip.CRC32;
import org.eclipse.rap.rwt.internal.theme.CssDimension;
import org.eclipse.rap.rwt.internal.theme.CssType;
import org.eclipse.swt.graphics.Rectangle;

public class CssBoxDimensions
implements CssType {
    public static final CssBoxDimensions ZERO = new CssBoxDimensions(0, 0, 0, 0);
    public final int top;
    public final int right;
    public final int bottom;
    public final int left;

    private CssBoxDimensions(int top, int right, int bottom, int left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public static CssBoxDimensions create(int top, int right, int bottom, int left) {
        if (top == 0 && right == 0 && bottom == 0 && left == 0) {
            return ZERO;
        }
        return new CssBoxDimensions(top, right, bottom, left);
    }

    public static CssBoxDimensions valueOf(String input) {
        int left;
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        String[] parts = input.split("\\s+");
        if (parts.length == 0 || parts.length > 4) {
            String msg = "Illegal number of arguments for box dimensions";
            throw new IllegalArgumentException(msg);
        }
        int bottom = left = CssBoxDimensions.parsePxValue(parts[0]);
        int right = left;
        int top = left;
        if (parts.length >= 2) {
            right = left = CssBoxDimensions.parsePxValue(parts[1]);
        }
        if (parts.length >= 3) {
            bottom = CssBoxDimensions.parsePxValue(parts[2]);
        }
        if (parts.length == 4) {
            left = CssBoxDimensions.parsePxValue(parts[3]);
        }
        return CssBoxDimensions.create(top, right, bottom, left);
    }

    public int getWidth() {
        return this.left + this.right;
    }

    public int getHeight() {
        return this.top + this.bottom;
    }

    public String toDefaultString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.valueOf(this.top) + "px");
        if (this.right != this.top || this.bottom != this.top || this.left != this.top) {
            buffer.append(" " + this.right + "px");
        }
        if (this.bottom != this.top || this.left != this.right) {
            buffer.append(" " + this.bottom + "px");
        }
        if (this.left != this.right) {
            buffer.append(" " + this.left + "px");
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssBoxDimensions) {
            CssBoxDimensions other = (CssBoxDimensions)object;
            return other.top == this.top && other.right == this.right && other.bottom == this.bottom && other.left == this.left;
        }
        return false;
    }

    public int hashCode() {
        CRC32 result = new CRC32();
        result.update(this.top);
        result.update(this.right);
        result.update(this.bottom);
        result.update(this.left);
        return (int)result.getValue();
    }

    public String toString() {
        return "CssBoxDimensions{ " + this.top + ", " + this.right + ", " + this.bottom + ", " + this.left + " }";
    }

    private static int parsePxValue(String part) {
        Integer result = CssDimension.parseLength(part);
        if (result == null) {
            throw new IllegalArgumentException("Illegal parameter: " + part);
        }
        return result;
    }

    public static Rectangle createRectangle(CssBoxDimensions boxdim) {
        return new Rectangle(boxdim.left, boxdim.top, boxdim.left + boxdim.right, boxdim.top + boxdim.bottom);
    }
}

