/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.CssDimension;
import org.eclipse.rap.rwt.internal.theme.CssType;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class CssFont
implements CssType {
    private static final Pattern FONT_DEF_PATTERN = Pattern.compile("(\".+?\"|'.+?'|\\S[^\\s,]+)(\\s*,)?");
    public final String[] family;
    public final int size;
    public final boolean bold;
    public final boolean italic;
    private String familyAsString;

    private CssFont(String[] family, int size, boolean bold, boolean italic) {
        this.family = family;
        this.size = size;
        this.bold = bold;
        this.italic = italic;
    }

    public static CssFont create(String[] families, int size, boolean bold, boolean italic) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative width: " + size);
        }
        return new CssFont(families, size, bold, italic);
    }

    public static CssFont valueOf(String input) {
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        if (input.trim().length() == 0) {
            throw new IllegalArgumentException("Empty font definition");
        }
        ArrayList<String> family = new ArrayList<String>();
        int size = 0;
        boolean bold = false;
        boolean italic = false;
        Matcher matcher = FONT_DEF_PATTERN.matcher(input);
        while (matcher.find()) {
            String part = matcher.group(1);
            char c = part.charAt(0);
            if (c == '\"' || c == '\'') {
                part = part.substring(1, part.length() - 1);
            }
            if ("bold".equalsIgnoreCase(part)) {
                bold = true;
                continue;
            }
            if ("italic".equalsIgnoreCase(part)) {
                italic = true;
                continue;
            }
            Integer parsedSize = CssDimension.parseLength(part);
            if (parsedSize != null) {
                size = parsedSize;
                continue;
            }
            family.add(part);
        }
        String[] familyArr = family.toArray(new String[family.size()]);
        return new CssFont(familyArr, size, bold, italic);
    }

    public String getFamilyAsString() {
        if (this.familyAsString == null) {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < this.family.length) {
                boolean hasSpace;
                if (i > 0) {
                    buffer.append(", ");
                }
                boolean bl = hasSpace = this.family[i].indexOf(32) != -1;
                if (hasSpace) {
                    buffer.append("\"");
                }
                buffer.append(this.family[i]);
                if (hasSpace) {
                    buffer.append("\"");
                }
                ++i;
            }
            this.familyAsString = buffer.toString();
        }
        return this.familyAsString;
    }

    public String toDefaultString() {
        StringBuilder result = new StringBuilder();
        if (this.bold) {
            result.append("bold ");
        }
        if (this.italic) {
            result.append("italic ");
        }
        result.append(this.size);
        result.append("px ");
        result.append(this.getFamilyAsString());
        return result.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssFont) {
            CssFont other = (CssFont)object;
            return Arrays.equals(other.family, this.family) && other.size == this.size && other.bold == this.bold && other.italic == this.italic;
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        int i = 0;
        while (i < this.family.length) {
            result += 37 * result + this.family[i].hashCode();
            ++i;
        }
        result += 37 * result + this.size;
        return result += this.italic ? 0 : 37 * (result += this.bold ? 0 : 37 * result + 41) + 43;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CssFont{ ");
        if (this.bold) {
            result.append("bold ");
        }
        if (this.italic) {
            result.append("italic ");
        }
        result.append(this.size);
        result.append("px ");
        result.append(this.getFamilyAsString());
        result.append(" }");
        return result.toString();
    }

    public static Font createFont(CssFont font) {
        String name = font.getFamilyAsString();
        int style = 0;
        if (font.bold) {
            style |= 1;
        }
        if (font.italic) {
            style |= 2;
        }
        FontData data = new FontData(name, font.size, style);
        return ContextProvider.getApplicationContext().getResourceFactory().getFont(data);
    }
}

