/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.theme.CssType;
import org.eclipse.rap.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rap.rwt.internal.theme.ThemePropertyAdapterRegistry;
import org.eclipse.rap.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rap.rwt.service.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThemeStoreWriter {
    private final IThemeCssElement[] allThemeableWidgetElements;
    private final Theme theme;
    private final ApplicationContext applicationContext;

    public ThemeStoreWriter(ApplicationContext applicationContext, Theme theme, IThemeCssElement[] elements) {
        this.applicationContext = applicationContext;
        this.theme = theme;
        this.allThemeableWidgetElements = elements;
    }

    public String createJson() {
        CssType[] allValues = this.theme.getValuesMap().getAllValues();
        Map valuesMap = this.createValuesMap(allValues);
        JsonObject json = new JsonObject();
        json.add("values", ThemeStoreWriter.createJsonFromValuesMap(valuesMap));
        json.add("theme", this.createThemeJson());
        return json.toString();
    }

    private JsonObject createThemeJson() {
        JsonObject result = new JsonObject();
        ThemeCssValuesMap valuesMap = this.theme.getValuesMap();
        int i = 0;
        while (i < this.allThemeableWidgetElements.length) {
            IThemeCssElement element = this.allThemeableWidgetElements[i];
            String elementName = element.getName();
            JsonObject elementObj = this.createThemeJsonForElement(valuesMap, element);
            result.add(elementName, elementObj);
            ++i;
        }
        return result;
    }

    private JsonObject createThemeJsonForElement(ThemeCssValuesMap valuesMap, IThemeCssElement element) {
        JsonObject result = new JsonObject();
        ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance(this.applicationContext);
        String[] stringArray = element.getProperties();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            JsonArray valuesArray = new JsonArray();
            String elementName = element.getName();
            ConditionalValue[] conditionalValueArray = valuesMap.getValues(elementName, propertyName);
            int n3 = conditionalValueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ConditionalValue conditionalValue = conditionalValueArray[n4];
                JsonArray array = new JsonArray();
                array.add(JsonUtil.createJsonArray(conditionalValue.constraints));
                CssType value = conditionalValue.value;
                ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(value.getClass());
                String cssKey = adapter.getKey(value);
                array.add(cssKey);
                valuesArray.add(array);
                ++n4;
            }
            result.add(propertyName, valuesArray);
            ++n2;
        }
        return result;
    }

    private Map createValuesMap(CssType[] values) {
        LinkedHashMap<String, JsonObject> result = new LinkedHashMap<String, JsonObject>();
        int i = 0;
        while (i < values.length) {
            this.appendValueToMap(values[i], result);
            ++i;
        }
        return result;
    }

    private void appendValueToMap(CssType propertyValue, Map<String, JsonObject> valuesMap) {
        String slot;
        ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance(this.applicationContext);
        ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(propertyValue.getClass());
        if (adapter != null && (slot = adapter.getSlot(propertyValue)) != null) {
            String key = adapter.getKey(propertyValue);
            JsonValue value = adapter.getValue(propertyValue);
            if (value != null) {
                JsonObject slotObject = ThemeStoreWriter.getSlot(valuesMap, slot);
                slotObject.add(key, value);
            }
        }
    }

    private static JsonValue createJsonFromValuesMap(Map valuesMap) {
        JsonObject result = new JsonObject();
        Set entrySet = valuesMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            JsonValue value = (JsonValue)entry.getValue();
            result.add(key, value);
        }
        return result;
    }

    private static JsonObject getSlot(Map<String, JsonObject> valuesMap, String name) {
        JsonObject result = valuesMap.get(name);
        if (result == null) {
            result = new JsonObject();
            valuesMap.put(name, result);
        }
        return result;
    }
}

