/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.CssType;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rap.rwt.internal.theme.ValueSelector;
import org.eclipse.rap.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rap.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rap.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.widgets.Widget;

public final class ThemeUtil {
    private static final String DEFAULT_THEME_CSS = "resource/theme/default.css";
    public static final String CURR_THEME_ATTR = "org.eclipse.rap.theme.current";

    public static String[] getAvailableThemeIds() {
        return ContextProvider.getApplicationContext().getThemeManager().getRegisteredThemeIds();
    }

    public static String getCurrentThemeId() {
        UISession uiSession = ContextProvider.getUISession();
        return (String)uiSession.getAttribute(CURR_THEME_ATTR);
    }

    public static void setCurrentThemeId(UISession uiSession, String themeId) {
        uiSession.setAttribute(CURR_THEME_ATTR, themeId);
    }

    public static Theme getCurrentTheme() {
        return ContextProvider.getApplicationContext().getThemeManager().getTheme(ThemeUtil.getCurrentThemeId());
    }

    private static Theme getFallbackTheme() {
        ThemeManager themeManager = ContextProvider.getApplicationContext().getThemeManager();
        return themeManager.getTheme("org.eclipse.rap.rwt.theme.Fallback");
    }

    static StyleSheet readDefaultThemeStyleSheet() {
        StyleSheet result;
        try {
            ResourceLoader resLoader = ThemeManager.STANDARD_RESOURCE_LOADER;
            result = CssFileReader.readStyleSheet(DEFAULT_THEME_CSS, resLoader);
        }
        catch (IOException ioe) {
            String msg = "Failed to load default theme: resource/theme/default.css";
            throw new ThemeManagerException(msg, ioe);
        }
        return result;
    }

    public static CssType getCssValue(String cssElement, String cssProperty, SimpleSelector selector) {
        return ThemeUtil.getCssValue(cssElement, cssProperty, selector, null);
    }

    public static CssType getCssValue(String cssElement, String cssProperty, ValueSelector selector, Widget widget) {
        Theme theme = ThemeUtil.getCurrentTheme();
        ThemeCssValuesMap valuesMap = theme.getValuesMap();
        ConditionalValue[] values = valuesMap.getValues(cssElement, cssProperty);
        CssType result = selector.select(values, widget);
        if (result == null) {
            theme = ThemeUtil.getFallbackTheme();
            valuesMap = theme.getValuesMap();
            values = valuesMap.getValues(cssElement, cssProperty);
            result = selector.select(values, widget);
        }
        return result;
    }

    private ThemeUtil() {
    }
}

