/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.shellkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.shellkit.ShellOperationHandler;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class ShellLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Shell";
    private static final String[] ALLOWED_STYLES = new String[]{"CLOSE", "MIN", "MAX", "NO_TRIM", "RESIZE", "TITLE", "ON_TOP", "TOOL", "SHEET", "APPLICATION_MODAL", "MODELESS", "PRIMARY_MODAL", "SYSTEM_MODAL", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_ALPHA = "alpha";
    static final String PROP_ACTIVE_CONTROL = "activeControl";
    static final String PROP_ACTIVE_SHELL = "activeShell";
    static final String PROP_MODE = "mode";
    static final String PROP_FULLSCREEN = "fullScreen";
    static final String PROP_MINIMUM_SIZE = "minimumSize";
    private static final String PROP_ACTIVATE_LISTENER = "Activate";
    private static final String PROP_CLOSE_LISTENER = "Close";
    private static final String PROP_RESIZE_LISTENER = "Resize";
    private static final String PROP_MOVE_LISTENER = "Move";
    private static final String PROP_DEFAULT_BUTTON = "defaultButton";

    public void preserveValues(Widget widget) {
        Shell shell = (Shell)widget;
        ControlLCAUtil.preserveValues(shell);
        WidgetLCAUtil.preserveCustomVariant(shell);
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_ACTIVE_CONTROL, ShellLCA.getActiveControl(shell));
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_ACTIVE_SHELL, shell.getDisplay().getActiveShell());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_TEXT, shell.getText());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_IMAGE, shell.getImage());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_ALPHA, new Integer(shell.getAlpha()));
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_MODE, ShellLCA.getMode(shell));
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_FULLSCREEN, (Object)shell.getFullScreen());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_MINIMUM_SIZE, shell.getMinimumSize());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_DEFAULT_BUTTON, shell.getDefaultButton());
    }

    public void readData(Widget widget) {
        ShellLCA.preserveMenuBounds((Shell)widget);
        super.readData(widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Shell shell = (Shell)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(shell, TYPE);
        remoteObject.setHandler(new ShellOperationHandler(shell));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(shell, ALLOWED_STYLES)));
        Composite parent = shell.getParent();
        if (parent instanceof Shell) {
            remoteObject.set("parentShell", WidgetUtil.getId(parent));
        }
        remoteObject.listen(PROP_MOVE_LISTENER, true);
        remoteObject.listen(PROP_RESIZE_LISTENER, true);
        remoteObject.listen(PROP_ACTIVATE_LISTENER, true);
        remoteObject.listen(PROP_CLOSE_LISTENER, true);
    }

    public void renderChanges(Widget widget) throws IOException {
        Shell shell = (Shell)widget;
        WidgetLCAUtil.renderCustomVariant(shell);
        ShellLCA.renderImage(shell);
        ShellLCA.renderText(shell);
        this.renderAlpha(shell);
        ShellLCA.renderActiveShell(shell);
        ShellLCA.renderMode(shell);
        ShellLCA.renderMinimumSize(shell);
        ShellLCA.renderDefaultButton(shell);
        ShellLCA.renderActiveControl(shell);
        ControlLCAUtil.renderChanges(shell);
    }

    public void renderDispose(Widget widget) throws IOException {
        RemoteObjectFactory.getRemoteObject(widget).destroy();
    }

    private static void renderText(Shell shell) {
        WidgetLCAUtil.renderProperty((Widget)shell, PROP_TEXT, shell.getText(), "");
    }

    private void renderAlpha(Shell shell) {
        WidgetLCAUtil.renderProperty((Widget)shell, PROP_ALPHA, shell.getAlpha(), 255);
    }

    private static void renderMinimumSize(Shell shell) {
        Point newValue = shell.getMinimumSize();
        if (WidgetLCAUtil.hasChanged(shell, PROP_MINIMUM_SIZE, newValue)) {
            RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(shell);
            remoteObject.set(PROP_MINIMUM_SIZE, new JsonArray().add(newValue.x).add(newValue.y));
        }
    }

    private static void renderDefaultButton(Shell shell) {
        Button defaultButton = shell.getDefaultButton();
        if (WidgetLCAUtil.hasChanged(shell, PROP_DEFAULT_BUTTON, defaultButton, null)) {
            String defaultButtonId = null;
            if (defaultButton != null) {
                defaultButtonId = WidgetUtil.getId(defaultButton);
            }
            RemoteObjectFactory.getRemoteObject(shell).set(PROP_DEFAULT_BUTTON, defaultButtonId);
        }
    }

    private static void renderActiveShell(Shell shell) {
        Shell activeShell = shell.getDisplay().getActiveShell();
        boolean hasChanged = WidgetLCAUtil.hasChanged(shell, PROP_ACTIVE_SHELL, activeShell, null);
        if (shell == activeShell && hasChanged) {
            RemoteObjectFactory.getRemoteObject(shell).set("active", true);
        }
    }

    private static void renderActiveControl(Shell shell) {
        Control activeControl = ShellLCA.getActiveControl(shell);
        if (WidgetLCAUtil.hasChanged(shell, PROP_ACTIVE_CONTROL, activeControl, null)) {
            String activeControlId = null;
            if (activeControl != null) {
                activeControlId = WidgetUtil.getId(activeControl);
            }
            RemoteObjectFactory.getRemoteObject(shell).set(PROP_ACTIVE_CONTROL, activeControlId);
        }
    }

    private static void renderImage(Shell shell) {
        if ((shell.getStyle() & 0x20) != 0) {
            Image[] defaultImages;
            Image image = shell.getImage();
            if (image == null && (defaultImages = shell.getImages()).length > 0) {
                image = defaultImages[0];
            }
            WidgetLCAUtil.renderProperty((Widget)shell, PROP_IMAGE, image, null);
        }
    }

    private static void renderMode(Shell shell) {
        WidgetLCAUtil.renderProperty((Widget)shell, PROP_MODE, ShellLCA.getMode(shell), null);
    }

    private static Control getActiveControl(Shell shell) {
        return shell.getAdapter(IShellAdapter.class).getActiveControl();
    }

    private static String getMode(Shell shell) {
        String result = null;
        if (shell.getMinimized()) {
            result = "minimized";
        } else if (shell.getFullScreen()) {
            result = "fullscreen";
        } else if (shell.getMaximized()) {
            result = "maximized";
        }
        return result;
    }

    private static void preserveMenuBounds(Shell shell) {
        Menu menuBar = shell.getMenuBar();
        if (menuBar != null) {
            IShellAdapter shellAdapter = shell.getAdapter(IShellAdapter.class);
            WidgetUtil.getAdapter(menuBar).preserve("bounds", shellAdapter.getMenuBounds());
        }
    }
}

