/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.progressbarkit.ProgressBarThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    private int minimum;
    private int selection;
    private int maximum = 100;
    private int state = 0;

    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    static int checkStyle(int style) {
        int currStyle = style | 0x80000;
        return ProgressBar.checkBits(currStyle, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Rectangle border = this.getBorder();
        int barWidth = this.getProgressBarWidth();
        int width = border.width;
        int height = border.height;
        if ((this.style & 0x100) != 0) {
            width += barWidth * 10;
            height += barWidth;
        } else {
            width += barWidth;
            height += barWidth * 10;
        }
        if (wHint != -1) {
            width = wHint + border.width;
        }
        if (hHint != -1) {
            height = hHint + border.height;
        }
        return new Point(width, height);
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value > this.getMinimum()) {
            this.maximum = value;
            if (this.selection > this.maximum) {
                this.selection = this.maximum;
            }
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value > 0 && value < this.getMaximum()) {
            this.minimum = value;
            if (this.minimum > this.selection) {
                this.selection = this.minimum;
            }
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.selection = value < this.minimum ? this.minimum : (value > this.maximum ? this.maximum : value);
    }

    public void setState(int state) {
        this.checkWidget();
        if (state == 0 || state == 4 || state == 1) {
            this.state = state;
        }
    }

    public int getState() {
        this.checkWidget();
        return this.state;
    }

    private int getProgressBarWidth() {
        IThemeAdapter themeAdapter = this.getAdapter(IThemeAdapter.class);
        return ((ProgressBarThemeAdapter)themeAdapter).getProgressBarWidth(this);
    }
}

