/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    private final Point PREFERRED_SIZE = new Point(170, 16);
    private int increment = 1;
    private int maximum = 100;
    private int minimum = 0;
    private int pageIncrement = 10;
    private int selection = 0;
    private int thumb = 10;

    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    static int checkStyle(int style) {
        return Slider.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        this.checkWidget();
        if ((this.style & 0x100) != 0) {
            width = this.PREFERRED_SIZE.x;
            height = this.PREFERRED_SIZE.y;
        } else {
            width = this.PREFERRED_SIZE.y;
            height = this.PREFERRED_SIZE.x;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle border = this.getBorder();
        return new Point(width += border.width, height += border.height);
    }

    void createWidget() {
        this.increment = 1;
        this.pageIncrement = 10;
        this.maximum = 100;
        this.thumb = 10;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value >= 1 && value <= this.maximum - this.minimum) {
            this.increment = value;
        }
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (this.minimum >= 0 && this.minimum < value) {
            this.maximum = value;
            if (this.selection > this.maximum - this.thumb) {
                this.selection = this.maximum - this.thumb;
            }
        }
        if (this.thumb >= this.maximum - this.minimum) {
            this.thumb = this.maximum - this.minimum;
            this.selection = this.minimum;
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value >= 0 && value < this.maximum) {
            this.minimum = value;
            if (this.selection < this.minimum) {
                this.selection = this.minimum;
            }
        }
        if (this.thumb >= this.maximum - this.minimum) {
            this.thumb = this.maximum - this.minimum;
            this.selection = this.minimum;
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value >= 1 && value <= this.maximum - this.minimum) {
            this.pageIncrement = value;
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.selection = value < this.minimum ? this.minimum : (value > this.maximum - this.thumb ? this.maximum - this.thumb : value);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value >= 1) {
            this.thumb = value;
        }
        if (value >= this.maximum - this.minimum) {
            this.thumb = this.maximum - this.minimum;
            this.selection = this.minimum;
        }
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (selection >= minimum && selection <= maximum) {
            this.selection = selection;
        }
        if (minimum >= 0 && minimum < maximum) {
            this.minimum = minimum;
            if (selection < minimum) {
                this.selection = minimum;
            }
        }
        if (minimum >= 0 && minimum < maximum) {
            this.maximum = maximum;
            if (selection > maximum - thumb) {
                this.selection = maximum - thumb;
            }
        }
        if (thumb >= 1) {
            this.thumb = thumb;
        }
        if (increment >= 1 && increment <= maximum - minimum) {
            this.increment = increment;
        }
        if (pageIncrement >= 1 && pageIncrement <= maximum - minimum) {
            this.pageIncrement = pageIncrement;
        }
        if (thumb >= maximum - minimum) {
            this.thumb = maximum - minimum;
            this.selection = minimum;
        }
    }

    boolean isTabGroup() {
        return true;
    }
}

