/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.context.ContextPathCustomizer;
import org.eclipse.equinox.http.servlet.internal.HttpServiceObjectRegistration;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.context.HttpContextHelperFactory;
import org.eclipse.equinox.http.servlet.internal.context.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.error.NullContextNamesException;
import org.eclipse.equinox.http.servlet.internal.error.NullServletContextHelperException;
import org.eclipse.equinox.http.servlet.internal.error.PatternInUseException;
import org.eclipse.equinox.http.servlet.internal.error.RegisteredFilterException;
import org.eclipse.equinox.http.servlet.internal.error.ServletAlreadyRegisteredException;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestBuilder;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletResponseWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.eclipse.equinox.http.servlet.internal.servlet.ResponseStateHandler;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HttpServiceRuntimeImpl
implements HttpServiceRuntime,
ServiceTrackerCustomizer<ServletContextHelper, AtomicReference<ContextController>> {
    private Map<String, Object> attributes;
    private final String targetFilter;
    private final ServiceRegistration<ServletContextHelper> defaultContextReg;
    private ServletContext parentServletContext;
    private BundleContext trackingContext;
    private BundleContext consumingContext;
    private final Filter servletServiceFilter;
    private final Filter resourceServiceFilter;
    private final Filter filterServiceFilter;
    private final Filter listenerServiceFilter;
    private Map<HttpContext, HttpContextHelperFactory> httpContextHelperFactories = Collections.synchronizedMap(new HashMap());
    private Map<Object, HttpServiceObjectRegistration> legacyMappings = Collections.synchronizedMap(new HashMap());
    private Map<Bundle, Set<HttpServiceObjectRegistration>> bundleRegistrations = new HashMap<Bundle, Set<HttpServiceObjectRegistration>>();
    private ConcurrentMap<String, Set<ContextController>> contextPathMap = new ConcurrentHashMap<String, Set<ContextController>>();
    private ConcurrentMap<ContextController, ServiceReference<ServletContextHelper>> controllerMap = new ConcurrentHashMap<ContextController, ServiceReference<ServletContextHelper>>();
    private AtomicLong legacyServiceIdGenerator = new AtomicLong(0L);
    private Set<Object> registeredObjects = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> registeredContextNames = new ConcurrentSkipListSet<String>();
    private ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker;
    private ServiceTracker<ContextPathCustomizer, ContextPathCustomizer> contextPathAdaptorTracker;
    private ContextPathCustomizerHolder contextPathCustomizerHolder;

    public HttpServiceRuntimeImpl(BundleContext trackingContext, BundleContext consumingContext, ServletContext parentServletContext, Map<String, Object> attributes) {
        this.trackingContext = trackingContext;
        this.consumingContext = consumingContext;
        this.servletServiceFilter = HttpServiceRuntimeImpl.createServletFilter(consumingContext);
        this.resourceServiceFilter = HttpServiceRuntimeImpl.createResourceFilter(consumingContext);
        this.filterServiceFilter = HttpServiceRuntimeImpl.createFilterFilter(consumingContext);
        this.listenerServiceFilter = HttpServiceRuntimeImpl.createListenerFilter(consumingContext);
        this.parentServletContext = parentServletContext;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.targetFilter = "(equinox.http.id=" + attributes.get("equinox.http.id") + ")";
        this.contextServiceTracker = new ServiceTracker(trackingContext, ServletContextHelper.class, (ServiceTrackerCustomizer)this);
        this.contextPathCustomizerHolder = new ContextPathCustomizerHolder(consumingContext, this.contextServiceTracker);
        this.contextPathAdaptorTracker = new ServiceTracker(consumingContext, ContextPathCustomizer.class, (ServiceTrackerCustomizer)this.contextPathCustomizerHolder);
        this.contextPathAdaptorTracker.open();
        this.contextServiceTracker.open();
        Hashtable<String, Object> defaultContextProps = new Hashtable<String, Object>();
        defaultContextProps.put("osgi.http.whiteboard.context.name", "default");
        defaultContextProps.put("service.ranking", Integer.MIN_VALUE);
        defaultContextProps.put("osgi.http.whiteboard.context.path", "/");
        defaultContextProps.put("osgi.http.whiteboard.target", this.targetFilter);
        this.defaultContextReg = consumingContext.registerService(ServletContextHelper.class, (ServiceFactory)new DefaultServletContextHelperFactory(), defaultContextProps);
    }

    public synchronized AtomicReference<ContextController> addingService(ServiceReference<ServletContextHelper> serviceReference) {
        AtomicReference<ContextController> result = new AtomicReference<ContextController>();
        if (!this.matches(serviceReference)) {
            return result;
        }
        String contextName = (String)serviceReference.getProperty("osgi.http.whiteboard.context.name");
        if (contextName == null) {
            this.parentServletContext.log("This context's property osgi.http.whiteboard.context.name is null. Ignoring!");
            return result;
        }
        if (this.registeredContextNames.contains(contextName)) {
            this.parentServletContext.log("ContextName " + contextName + " is already in use. Ignoring!");
            return result;
        }
        String contextPath = (String)serviceReference.getProperty("osgi.http.whiteboard.context.path");
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = "";
        }
        contextPath = this.adaptContextPath(contextPath, serviceReference);
        long serviceId = (Long)serviceReference.getProperty("service.id");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] stringArray = serviceReference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            properties.put(key, serviceReference.getProperty(key));
            ++n2;
        }
        properties.putAll(this.attributes);
        result.set(this.addServletContextHelper(serviceReference, contextName, contextPath, serviceId, properties));
        return result;
    }

    private String adaptContextPath(String contextPath, ServiceReference<ServletContextHelper> helper) {
        String contextPrefix;
        ContextPathCustomizer pathAdaptor = this.contextPathCustomizerHolder.getHighestRanked();
        if (pathAdaptor != null && (contextPrefix = pathAdaptor.getContextPathPrefix(helper)) != null && !contextPrefix.isEmpty() && !contextPrefix.equals("/")) {
            if (!contextPrefix.startsWith("/")) {
                contextPrefix = "/" + contextPrefix;
            }
            return String.valueOf(contextPrefix) + contextPath;
        }
        return contextPath;
    }

    public String getDefaultContextSelectFilter(ServiceReference<?> httpWhiteBoardService) {
        ContextPathCustomizer pathAdaptor = this.contextPathCustomizerHolder.getHighestRanked();
        if (pathAdaptor != null) {
            return pathAdaptor.getDefaultContextSelectFilter(httpWhiteBoardService);
        }
        return null;
    }

    public ContextController addServletContextHelper(ServiceReference<ServletContextHelper> servletContextHelperRef, String contextName, String contextPath, long serviceId, Map<String, Object> properties) {
        ContextController contextController;
        if (servletContextHelperRef == null) {
            throw new NullServletContextHelperException();
        }
        if (contextName == null) {
            throw new NullContextNamesException();
        }
        if (contextPath == null) {
            contextPath = "";
        }
        if ((contextController = this.createContextController(servletContextHelperRef, contextName, contextPath, serviceId, properties)) != null) {
            this.registeredContextNames.add(contextName);
        }
        this.controllerMap.putIfAbsent(contextController, servletContextHelperRef);
        return contextController;
    }

    public RequestInfoDTO calculateRequestInfoDTO(String path) {
        RequestInfoDTO requestInfoDTO = new RequestInfoDTO();
        requestInfoDTO.path = path;
        try {
            this.doDispatch(null, null, path, requestInfoDTO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return requestInfoDTO;
    }

    public void destroy() {
        this.defaultContextReg.unregister();
        this.contextServiceTracker.close();
        this.contextPathAdaptorTracker.close();
        this.controllerMap.clear();
        this.contextPathMap.clear();
        this.registeredObjects.clear();
        this.attributes = null;
        this.trackingContext = null;
        this.consumingContext = null;
        this.contextPathMap = null;
        this.legacyServiceIdGenerator = null;
        this.parentServletContext = null;
        this.registeredObjects = null;
        this.contextServiceTracker = null;
        this.contextPathCustomizerHolder = null;
    }

    public boolean doDispatch(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        return this.doDispatch(request, response, path, null);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getAttributesAsInitParams() {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.getAttributes().entrySet()) {
            initParameters.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return initParameters;
    }

    public Set<Object> getRegisteredObjects() {
        return this.registeredObjects;
    }

    public List<String> getHttpServiceEndpoints() {
        return StringPlus.from(this.attributes.get("osgi.http.endpoint"));
    }

    public RuntimeDTO getRuntimeDTO() {
        RuntimeDTO runtimeDTO = new RuntimeDTO();
        runtimeDTO.attributes = this.serializeAttributes();
        runtimeDTO.failedErrorPageDTOs = null;
        runtimeDTO.failedFilterDTOs = null;
        runtimeDTO.failedListenerDTOs = null;
        runtimeDTO.failedResourceDTOs = null;
        runtimeDTO.failedServletContextDTOs = null;
        runtimeDTO.failedServletDTOs = null;
        runtimeDTO.servletContextDTOs = this.getServletContextDTOs();
        return runtimeDTO;
    }

    public void log(String message, Throwable t) {
        this.parentServletContext.log(message, t);
    }

    public boolean matches(ServiceReference<?> serviceReference) {
        Filter targetFilter;
        String target = (String)serviceReference.getProperty("osgi.http.whiteboard.target");
        if (target == null) {
            return true;
        }
        try {
            targetFilter = FrameworkUtil.createFilter((String)target);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
        return targetFilter.matches(this.attributes);
    }

    public synchronized void modifiedService(ServiceReference<ServletContextHelper> serviceReference, AtomicReference<ContextController> contextController) {
        this.removedService(serviceReference, contextController);
        Object added = this.addingService((ServiceReference)serviceReference);
        contextController.set((ContextController)((AtomicReference)added).get());
    }

    public synchronized void removedService(ServiceReference<ServletContextHelper> serviceReference, AtomicReference<ContextController> contextControllerRef) {
        ContextController contextController = contextControllerRef.get();
        if (contextController != null) {
            this.removeContextController(contextController);
        }
        this.trackingContext.ungetService(serviceReference);
    }

    public void removeContextController(ContextController contextController) {
        Set<ContextController> contextControllers = this.getContextControllerPathSet(contextController.getContextPath(), false);
        if (contextControllers != null) {
            contextControllers.remove(contextController);
        }
        this.registeredContextNames.remove(contextController.getContextName());
        this.controllerMap.remove(contextController);
        contextController.destroy();
    }

    Set<ContextController> getContextControllerPathSet(String contextPath, boolean add) {
        Set existingSet;
        Set set;
        if (contextPath == null) {
            contextPath = "";
        }
        if ((set = (HashSet)this.contextPathMap.get(contextPath)) == null && add && (existingSet = (Set)this.contextPathMap.putIfAbsent(contextPath, set = new HashSet())) != null) {
            set = existingSet;
        }
        return set;
    }

    Set<ContextController> getContextControllers(String requestURI) {
        int pos = requestURI.lastIndexOf(47);
        while (true) {
            Set contextControllers;
            if ((contextControllers = (Set)this.contextPathMap.get(requestURI)) != null) {
                return contextControllers;
            }
            if (pos <= -1) break;
            requestURI = requestURI.substring(0, pos);
            pos = requestURI.lastIndexOf(47);
        }
        return null;
    }

    AtomicLong getLegacyServiceIdGenerator() {
        return this.legacyServiceIdGenerator;
    }

    private ContextController createContextController(ServiceReference<ServletContextHelper> servletContextHelperRef, String contextName, String contextPath, long serviceId, Map<String, Object> initParams) {
        ContextController contextController = new ContextController(this.trackingContext, this.consumingContext, servletContextHelperRef, new ProxyContext(this.parentServletContext), this, contextName, contextPath, serviceId, initParams);
        Set<ContextController> contextControllers = this.getContextControllerPathSet(contextPath, true);
        contextControllers.add(contextController);
        this.contextPathMap.put(contextPath, contextControllers);
        return contextController;
    }

    private boolean doDispatch(HttpServletRequest request, HttpServletResponse response, String path, RequestInfoDTO requestInfoDTO) throws ServletException, IOException {
        if (this.doDispatch(request, response, path, null, Match.EXACT, requestInfoDTO)) {
            return true;
        }
        String extensionAlias = this.findExtensionAlias(path);
        if (this.doDispatch(request, response, path, extensionAlias, Match.EXTENSION, requestInfoDTO)) {
            return true;
        }
        if (this.doDispatch(request, response, path, null, Match.REGEX, requestInfoDTO)) {
            return true;
        }
        return this.doDispatch(request, response, path, null, Match.DEFAULT_SERVLET, requestInfoDTO);
    }

    private boolean doDispatch(HttpServletRequest request, HttpServletResponse response, String requestURI, String extension, Match match, RequestInfoDTO requestInfoDTO) throws ServletException, IOException {
        DispatchTargets dispatchTargets = this.getDispatchTargets(request, requestURI, extension, match, requestInfoDTO);
        if (dispatchTargets == null || requestInfoDTO != null) {
            return false;
        }
        ContextController contextController = dispatchTargets.getContextController();
        DispatcherType dispatcherType = DispatcherType.REQUEST;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            request.setAttribute("javax.servlet.include.context_path", (Object)contextController.getContextPath());
            request.setAttribute("javax.servlet.include.path_info", (Object)dispatchTargets.getPathInfo());
            request.setAttribute("javax.servlet.include.query_string", (Object)request.getQueryString());
            request.setAttribute("javax.servlet.include.request_uri", (Object)requestURI);
            request.setAttribute("javax.servlet.include.servlet_path", (Object)dispatchTargets.getServletPath());
            dispatcherType = DispatcherType.INCLUDE;
        }
        HttpServletRequest wrappedRequest = new HttpServletRequestBuilder(request, dispatchTargets).build();
        HttpServletResponseWrapperImpl wrapperResponse = new HttpServletResponseWrapperImpl(response);
        ResponseStateHandler responseStateHandler = new ResponseStateHandler(wrappedRequest, (HttpServletResponse)wrapperResponse, dispatchTargets, dispatcherType);
        responseStateHandler.processRequest();
        return true;
    }

    private String findExtensionAlias(String alias) {
        String lastSegment = alias.substring(alias.lastIndexOf(47) + 1);
        int dot = lastSegment.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return lastSegment.substring(dot + 1);
    }

    private DispatchTargets getDispatchTargets(HttpServletRequest request, String requestURI, String extension, Match match, RequestInfoDTO requestInfoDTO) {
        Set<ContextController> contextControllers = this.getContextControllers(requestURI);
        if (contextControllers == null || contextControllers.isEmpty()) {
            return null;
        }
        String contextPath = contextControllers.iterator().next().getContextPath();
        requestURI = requestURI.substring(contextPath.length());
        int pos = requestURI.lastIndexOf(47);
        String servletPath = requestURI;
        String pathInfo = null;
        if (match == Match.DEFAULT_SERVLET) {
            pathInfo = servletPath;
            servletPath = "/";
        }
        while (true) {
            for (ContextController contextController : contextControllers) {
                DispatchTargets dispatchTargets = contextController.getDispatchTargets(request, null, requestURI, servletPath, pathInfo, extension, match, requestInfoDTO);
                if (dispatchTargets == null) continue;
                return dispatchTargets;
            }
            if (match == Match.EXACT || extension != null || pos <= -1) break;
            String newServletPath = requestURI.substring(0, pos);
            pathInfo = requestURI.substring(pos);
            servletPath = newServletPath;
            pos = servletPath.lastIndexOf(47);
        }
        return null;
    }

    private ServletContextDTO[] getServletContextDTOs() {
        ArrayList<ServletContextDTO> servletContextDTOs = new ArrayList<ServletContextDTO>();
        for (ContextController contextController : this.controllerMap.keySet()) {
            servletContextDTOs.add(contextController.getServletContextDTO());
        }
        return servletContextDTOs.toArray(new ServletContextDTO[servletContextDTOs.size()]);
    }

    private Map<String, String> serializeAttributes() {
        HashMap<String, String> temp = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            temp.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceFilter(Bundle bundle, String alias, javax.servlet.Filter filter, Dictionary<String, String> initparams, HttpContext httpContext) throws ServletException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        ContextController.checkPattern(alias);
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            if (this.getRegisteredObjects().contains(filter)) {
                throw new RegisteredFilterException(filter);
            }
            HttpServiceObjectRegistration existing = this.legacyMappings.get(filter);
            if (existing != null) {
                throw new RegisteredFilterException(filter);
            }
            String filterName = filter.getClass().getName();
            if (initparams != null && initparams.get("filter-name") != null) {
                filterName = initparams.get("filter-name");
            }
            HttpContextHelperFactory factory = this.getOrRegisterHttpContextHelperFactory(httpContext);
            HttpServiceObjectRegistration objectRegistration = null;
            try {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", alias);
                ((Dictionary)props).put("osgi.http.whiteboard.filter.name", filterName);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(equinox.legacy.context.helper=true)");
                ((Dictionary)props).put("equinox.context.select", factory.getFilter());
                ((Dictionary)props).put("equinox.legacy.matching", Boolean.TRUE);
                ((Dictionary)props).put("service.ranking", HttpServiceRuntimeImpl.findFilterPriority(initparams));
                this.fillInitParams(props, initparams, "filter.init.");
                ServiceRegistration registration = bundle.getBundleContext().registerService(javax.servlet.Filter.class, (ServiceFactory)new LegacyFilterFactory(filter), props);
                objectRegistration = new HttpServiceObjectRegistration(filter, registration, factory, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(factory);
                }
            }
        }
    }

    private void fillInitParams(Dictionary<String, Object> props, Dictionary<String, String> initparams, String prefix) {
        if (initparams != null) {
            Enumeration<String> eKeys = initparams.keys();
            while (eKeys.hasMoreElements()) {
                String key = eKeys.nextElement();
                String value = initparams.get(key);
                if (value == null) continue;
                props.put(String.valueOf(prefix) + key, value);
            }
        }
    }

    private static int findFilterPriority(Dictionary<String, String> initparams) {
        if (initparams == null) {
            return 0;
        }
        String filterPriority = initparams.get("filter-priority");
        if (filterPriority == null) {
            return 0;
        }
        try {
            int result = Integer.parseInt(filterPriority);
            if (result >= -1000 && result <= 1000) {
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException("filter-priority must be an integer between -1000 and 1000 but was: " + filterPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceResources(Bundle bundle, String alias, String name, HttpContext httpContext) throws NamespaceException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String pattern = alias;
        if (pattern.startsWith("/*.")) {
            pattern = pattern.substring(1);
        } else if (!(pattern.contains("*.") || pattern.endsWith("/*") || pattern.endsWith("/"))) {
            pattern = String.valueOf(pattern) + "/*";
        }
        ContextController.checkPattern(alias);
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            HttpServiceObjectRegistration existing = this.legacyMappings.get(alias);
            if (existing != null) {
                throw new PatternInUseException(alias);
            }
            HttpServiceObjectRegistration objectRegistration = null;
            HttpContextHelperFactory factory = this.getOrRegisterHttpContextHelperFactory(httpContext);
            try {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.resource.pattern", pattern);
                ((Dictionary)props).put("osgi.http.whiteboard.resource.prefix", name);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", factory.getFilter());
                ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
                ((Dictionary)props).put("equinox.legacy.matching", Boolean.TRUE);
                ServiceRegistration registration = bundle.getBundleContext().registerService(String.class, (Object)"resource", props);
                objectRegistration = new HttpServiceObjectRegistration(alias, registration, factory, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(factory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceServlet(Bundle bundle, String alias, Servlet servlet, Dictionary<String, String> initparams, HttpContext httpContext) throws NamespaceException, ServletException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        ContextController.checkPattern(alias);
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            if (this.getRegisteredObjects().contains(servlet)) {
                throw new ServletAlreadyRegisteredException(servlet);
            }
            HttpServiceObjectRegistration existing = this.legacyMappings.get(alias);
            if (existing != null) {
                throw new PatternInUseException(alias);
            }
            String servletName = servlet.getClass().getName();
            if (initparams != null && initparams.get("servlet-name") != null) {
                servletName = initparams.get("servlet-name");
            }
            HttpServiceObjectRegistration objectRegistration = null;
            HttpContextHelperFactory factory = this.getOrRegisterHttpContextHelperFactory(httpContext);
            try {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", alias);
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", servletName);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", factory.getFilter());
                ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
                ((Dictionary)props).put("equinox.legacy.matching", Boolean.TRUE);
                this.fillInitParams(props, initparams, "servlet.init.");
                ServiceRegistration registration = bundle.getBundleContext().registerService(Servlet.class, (Object)servlet, props);
                objectRegistration = new HttpServiceObjectRegistration(alias, registration, factory, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(factory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceAlias(Bundle bundle, String alias) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            HttpServiceObjectRegistration objectRegistration = this.legacyMappings.get(alias);
            if (objectRegistration == null) {
                throw new IllegalArgumentException("No registration found for alias: " + alias);
            }
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
            if (objectRegistrations == null || !objectRegistrations.remove(objectRegistration)) {
                throw new IllegalArgumentException("The bundle did not register the alias: " + alias);
            }
            try {
                objectRegistration.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
            this.decrementFactoryUseCount(objectRegistration.factory);
            this.legacyMappings.remove(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceFilter(Bundle bundle, javax.servlet.Filter filter) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            HttpServiceObjectRegistration objectRegistration = this.legacyMappings.get(filter);
            if (objectRegistration == null) {
                throw new IllegalArgumentException("No registration found for filter: " + filter);
            }
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
            if (objectRegistrations == null || !objectRegistrations.remove(objectRegistration)) {
                throw new IllegalArgumentException("The bundle did not register the filter: " + filter);
            }
            try {
                objectRegistration.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
            this.decrementFactoryUseCount(objectRegistration.factory);
            this.legacyMappings.remove(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceObjects(Bundle bundle) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.remove(bundle);
            if (objectRegistrations != null) {
                for (HttpServiceObjectRegistration objectRegistration : objectRegistrations) {
                    try {
                        objectRegistration.registration.unregister();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    this.decrementFactoryUseCount(objectRegistration.factory);
                    this.legacyMappings.remove(objectRegistration.serviceKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpContextHelperFactory getOrRegisterHttpContextHelperFactory(HttpContext httpContext) {
        if (httpContext == null) {
            throw new NullPointerException("A null HttpContext is not allowed.");
        }
        Map<HttpContext, HttpContextHelperFactory> map = this.httpContextHelperFactories;
        synchronized (map) {
            HttpContextHelperFactory factory = this.httpContextHelperFactories.get(httpContext);
            if (factory == null) {
                factory = new HttpContextHelperFactory(httpContext);
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.context.name", httpContext.toString());
                ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/");
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("equinox.legacy.context.helper", Boolean.TRUE);
                factory.setRegistration((ServiceRegistration<ServletContextHelper>)this.consumingContext.registerService(ServletContextHelper.class, (ServiceFactory)factory, props));
                this.httpContextHelperFactories.put(httpContext, factory);
            }
            factory.incrementUseCount();
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementFactoryUseCount(HttpContextHelperFactory factory) {
        Map<HttpContext, HttpContextHelperFactory> map = this.httpContextHelperFactories;
        synchronized (map) {
            if (factory.decrementUseCount() == 0L) {
                this.httpContextHelperFactories.remove(factory.getHttpContext());
            }
        }
    }

    private static Filter createResourceFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(");
        sb.append("osgi.http.whiteboard.resource.prefix");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.resource.pattern");
        sb.append("=*))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static Filter createServletFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Servlet.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.servlet.errorPage");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.servlet.pattern");
        sb.append("=*))(!(");
        sb.append("osgi.http.whiteboard.resource.prefix");
        sb.append("=*)))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static Filter createFilterFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(javax.servlet.Filter.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.filter.pattern");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.regex");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.servlet");
        sb.append("=*)))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static Filter createListenerFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(|");
        sb.append("(objectClass=").append(ServletContextListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletContextAttributeListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletRequestListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletRequestAttributeListener.class.getName()).append(")");
        sb.append("(objectClass=").append(HttpSessionListener.class.getName()).append(")");
        sb.append("(objectClass=").append(HttpSessionAttributeListener.class.getName()).append(")");
        sb.append(")");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public Filter getListenerFilter() {
        return this.listenerServiceFilter;
    }

    public Filter getFilterFilter() {
        return this.filterServiceFilter;
    }

    public Filter getServletFilter() {
        return this.servletServiceFilter;
    }

    public Filter getResourceFilter() {
        return this.resourceServiceFilter;
    }

    static class ContextPathCustomizerHolder
    implements ServiceTrackerCustomizer<ContextPathCustomizer, ContextPathCustomizer> {
        private final BundleContext context;
        private final ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker;
        private final NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> pathCustomizers = new TreeMap(Collections.reverseOrder());

        public ContextPathCustomizerHolder(BundleContext context, ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker) {
            this.context = context;
            this.contextServiceTracker = contextServiceTracker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ContextPathCustomizer addingService(ServiceReference<ContextPathCustomizer> reference) {
            ContextPathCustomizer service = (ContextPathCustomizer)this.context.getService(reference);
            boolean reset = false;
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                this.pathCustomizers.put(reference, service);
                reset = ((ServiceReference)this.pathCustomizers.firstKey()).equals(reference);
            }
            if (reset) {
                this.contextServiceTracker.close();
                this.contextServiceTracker.open();
            }
            return service;
        }

        public void modifiedService(ServiceReference<ContextPathCustomizer> reference, ContextPathCustomizer service) {
            this.removedService(reference, service);
            this.addingService((ServiceReference)reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ContextPathCustomizer> reference, ContextPathCustomizer service) {
            boolean reset = false;
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                ServiceReference currentFirst = (ServiceReference)this.pathCustomizers.firstKey();
                this.pathCustomizers.remove(reference);
                reset = currentFirst.equals(reference);
            }
            if (reset) {
                this.contextServiceTracker.close();
                this.contextServiceTracker.open();
            }
            this.context.ungetService(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ContextPathCustomizer getHighestRanked() {
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                Map.Entry<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> firstEntry = this.pathCustomizers.firstEntry();
                return firstEntry == null ? null : firstEntry.getValue();
            }
        }
    }

    static class DefaultServletContextHelper
    extends ServletContextHelper {
        public DefaultServletContextHelper(Bundle b) {
            super(b);
        }
    }

    static class DefaultServletContextHelperFactory
    implements ServiceFactory<ServletContextHelper> {
        DefaultServletContextHelperFactory() {
        }

        public ServletContextHelper getService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration) {
            return new DefaultServletContextHelper(bundle);
        }

        public void ungetService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration, ServletContextHelper service) {
        }
    }

    static class LegacyFilterFactory
    implements PrototypeServiceFactory<javax.servlet.Filter> {
        final javax.servlet.Filter filter;

        public LegacyFilterFactory(javax.servlet.Filter filter) {
            this.filter = filter;
        }

        public javax.servlet.Filter getService(Bundle bundle, ServiceRegistration<javax.servlet.Filter> registration) {
            return new javax.servlet.Filter(){

                public void init(FilterConfig filterConfig) throws ServletException {
                    LegacyFilterFactory.this.filter.init(filterConfig);
                }

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                    LegacyFilterFactory.this.filter.doFilter(request, response, chain);
                }

                public void destroy() {
                    LegacyFilterFactory.this.filter.destroy();
                }
            };
        }

        public void ungetService(Bundle bundle, ServiceRegistration<javax.servlet.Filter> registration, javax.servlet.Filter service) {
        }
    }
}

