/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.context.ServletContextHelper;

public class HttpContextHelperFactory
implements ServiceFactory<ServletContextHelper> {
    final HttpContext httpContext;
    final AtomicReference<ServiceRegistration<ServletContextHelper>> registrationRef = new AtomicReference();
    final AtomicReference<String> filterRef = new AtomicReference();
    final AtomicLong useCount = new AtomicLong(0L);

    public HttpContextHelperFactory(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public ServletContextHelper getService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration) {
        this.setRegistration(registration);
        return new HttpContextHelper(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration, ServletContextHelper service) {
    }

    public void setRegistration(ServiceRegistration<ServletContextHelper> registration) {
        if (this.registrationRef.compareAndSet(null, registration)) {
            StringBuilder filterBuilder = new StringBuilder();
            filterBuilder.append('(');
            filterBuilder.append("service.id");
            filterBuilder.append('=');
            filterBuilder.append(registration.getReference().getProperty("service.id"));
            filterBuilder.append(')');
            this.filterRef.compareAndSet(null, filterBuilder.toString());
        }
    }

    public String getFilter() {
        return this.filterRef.get();
    }

    public long incrementUseCount() {
        return this.useCount.incrementAndGet();
    }

    public long decrementUseCount() {
        ServiceRegistration<ServletContextHelper> registration;
        long result = this.useCount.decrementAndGet();
        if (result == 0L && (registration = this.registrationRef.get()) != null) {
            try {
                registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return result;
    }

    public Object getHttpContext() {
        return this.httpContext;
    }

    public class HttpContextHelper
    extends ServletContextHelper {
        private final Bundle bundle;

        public HttpContextHelper(Bundle bundle) {
            this.bundle = bundle;
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return HttpContextHelperFactory.this.httpContext.handleSecurity(request, response);
        }

        public URL getResource(String name) {
            return HttpContextHelperFactory.this.httpContext.getResource(name);
        }

        public String getMimeType(String name) {
            return HttpContextHelperFactory.this.httpContext.getMimeType(name);
        }

        public Set<String> getResourcePaths(String path) {
            if (path == null || this.bundle == null) {
                return null;
            }
            Enumeration enumeration = this.bundle.findEntries(path, null, false);
            if (enumeration == null) {
                return null;
            }
            HashSet<String> result = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                result.add(((URL)enumeration.nextElement()).getPath());
            }
            return result;
        }
    }
}

