/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextFilterTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Filter, AtomicReference<FilterRegistration>> {
    private ContextController contextController;

    public ContextFilterTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public AtomicReference<FilterRegistration> addingService(ServiceReference<Filter> serviceReference) {
        AtomicReference<FilterRegistration> result = new AtomicReference<FilterRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        if (!this.contextController.matches(serviceReference)) {
            return result;
        }
        try {
            result.set(this.contextController.addFilterRegistration(serviceReference));
        }
        catch (ServletException se) {
            this.httpServiceRuntime.log(se.getMessage(), se);
        }
        return result;
    }

    public void modifiedService(ServiceReference<Filter> serviceReference, AtomicReference<FilterRegistration> filterReference) {
        this.removedService(serviceReference, filterReference);
        Object added = this.addingService((ServiceReference)serviceReference);
        filterReference.set((FilterRegistration)((AtomicReference)added).get());
    }

    public void removedService(ServiceReference<Filter> serviceReference, AtomicReference<FilterRegistration> filterReference) {
        FilterRegistration registration = filterReference.get();
        if (registration != null) {
            registration.destroy();
        }
    }
}

