/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.registration.ListenerRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextListenerTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<EventListener, AtomicReference<ListenerRegistration>> {
    private ContextController contextController;

    public ContextListenerTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public AtomicReference<ListenerRegistration> addingService(ServiceReference<EventListener> serviceReference) {
        AtomicReference<ListenerRegistration> result = new AtomicReference<ListenerRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        if (!this.contextController.matches(serviceReference)) {
            return result;
        }
        try {
            result.set(this.contextController.addListenerRegistration(serviceReference));
        }
        catch (ServletException se) {
            this.httpServiceRuntime.log(se.getMessage(), se);
        }
        return result;
    }

    public void modifiedService(ServiceReference<EventListener> serviceReference, AtomicReference<ListenerRegistration> listenerRegistration) {
        this.removedService(serviceReference, listenerRegistration);
        this.addingService((ServiceReference)serviceReference);
    }

    public void removedService(ServiceReference<EventListener> serviceReference, AtomicReference<ListenerRegistration> listenerReference) {
        ListenerRegistration listenerRegistration = listenerReference.get();
        if (listenerRegistration != null) {
            listenerRegistration.destroy();
        }
    }
}

