/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.registration.ResourceRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextResourceTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Servlet, AtomicReference<ResourceRegistration>> {
    private ContextController contextController;

    public ContextResourceTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public AtomicReference<ResourceRegistration> addingService(ServiceReference<Servlet> serviceReference) {
        AtomicReference<ResourceRegistration> result = new AtomicReference<ResourceRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        if (!this.contextController.matches(serviceReference)) {
            return result;
        }
        result.set(this.contextController.addResourceRegistration(serviceReference));
        return result;
    }

    public void modifiedService(ServiceReference<Servlet> serviceReference, AtomicReference<ResourceRegistration> resourceReference) {
        this.removedService(serviceReference, resourceReference);
        Object added = this.addingService((ServiceReference)serviceReference);
        resourceReference.set((ResourceRegistration)((AtomicReference)added).get());
    }

    public void removedService(ServiceReference<Servlet> serviceReference, AtomicReference<ResourceRegistration> resourceReference) {
        ResourceRegistration registration = resourceReference.get();
        if (registration != null) {
            registration.destroy();
        }
    }
}

