/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.registration.ServletRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextServletTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Servlet, AtomicReference<ServletRegistration>> {
    private ContextController contextController;

    public ContextServletTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public AtomicReference<ServletRegistration> addingService(ServiceReference<Servlet> serviceReference) {
        AtomicReference<ServletRegistration> result = new AtomicReference<ServletRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        if (!this.contextController.matches(serviceReference)) {
            return result;
        }
        try {
            result.set(this.contextController.addServletRegistration(serviceReference));
        }
        catch (ServletException se) {
            this.httpServiceRuntime.log(se.getMessage(), se);
        }
        return result;
    }

    public void modifiedService(ServiceReference<Servlet> serviceReference, AtomicReference<ServletRegistration> servletReference) {
        this.removedService(serviceReference, servletReference);
        Object added = this.addingService((ServiceReference)serviceReference);
        servletReference.set((ServletRegistration)((AtomicReference)added).get());
    }

    public void removedService(ServiceReference<Servlet> serviceReference, AtomicReference<ServletRegistration> servletReference) {
        ServletRegistration registration = servletReference.get();
        if (registration != null) {
            registration.destroy();
        }
    }
}

