/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.registration;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.registration.MatchableRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.dto.FilterDTO;

public class FilterRegistration
extends MatchableRegistration<javax.servlet.Filter, FilterDTO>
implements Comparable<FilterRegistration> {
    private final ContextController.ServiceHolder<javax.servlet.Filter> filterHolder;
    private final ServletContextHelper servletContextHelper;
    private final ClassLoader classLoader;
    private final int priority;
    private final ContextController contextController;
    private final boolean initDestoyWithContextController;

    public FilterRegistration(ContextController.ServiceHolder<javax.servlet.Filter> filterHolder, FilterDTO filterDTO, int priority, ServletContextHelper servletContextHelper, ContextController contextController) {
        super(filterHolder.get(), filterDTO);
        this.filterHolder = filterHolder;
        this.priority = priority;
        this.servletContextHelper = servletContextHelper;
        this.contextController = contextController;
        this.classLoader = ((BundleWiring)filterHolder.getBundle().adapt(BundleWiring.class)).getClassLoader();
        String legacyContextFilter = (String)filterHolder.getServiceReference().getProperty("equinox.context.select");
        if (legacyContextFilter != null) {
            Filter f = null;
            try {
                f = FrameworkUtil.createFilter((String)legacyContextFilter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.initDestoyWithContextController = f == null || contextController.matches(f);
        } else {
            this.initDestoyWithContextController = true;
        }
    }

    @Override
    public int compareTo(FilterRegistration otherFilterRegistration) {
        int priorityDifference = this.priority - otherFilterRegistration.priority;
        if (priorityDifference != 0) {
            return -priorityDifference;
        }
        return Math.abs(((FilterDTO)this.getD()).serviceId) > Math.abs(((FilterDTO)otherFilterRegistration.getD()).serviceId) ? 1 : -1;
    }

    @Override
    public void destroy() {
        if (!this.initDestoyWithContextController) {
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.contextController.getHttpServiceRuntime().getRegisteredObjects().remove(this.getT());
            this.contextController.getFilterRegistrations().remove(this);
            this.contextController.ungetServletContextHelper(this.filterHolder.getBundle());
            super.destroy();
            ((javax.servlet.Filter)this.getT()).destroy();
        }
        finally {
            this.destroyContextAttributes();
            Thread.currentThread().setContextClassLoader(original);
            this.filterHolder.release();
        }
    }

    public boolean appliesTo(FilterChainImpl filterChainImpl) {
        return Arrays.binarySearch(((FilterDTO)this.getD()).dispatcher, filterChainImpl.getDispatcherType().name()) >= 0;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (this.servletContextHelper.handleSecurity(request, response)) {
                ((javax.servlet.Filter)this.getT()).doFilter((ServletRequest)request, (ServletResponse)response, chain);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FilterRegistration)) {
            return false;
        }
        FilterRegistration filterRegistration = (FilterRegistration)obj;
        return ((javax.servlet.Filter)this.getT()).equals(filterRegistration.getT());
    }

    public int hashCode() {
        return Long.valueOf(((FilterDTO)this.getD()).serviceId).hashCode();
    }

    public ServletContextHelper getServletContextHelper() {
        return this.servletContextHelper;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (!this.initDestoyWithContextController) {
            return;
        }
        boolean initialized = false;
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.createContextAttributes();
            ((javax.servlet.Filter)this.getT()).init(filterConfig);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.destroyContextAttributes();
            }
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    @Override
    public String match(String name, String servletPath, String pathInfo, String extension, Match match) {
        if (name != null) {
            if (((FilterDTO)this.getD()).servletNames == null) {
                return null;
            }
            String[] stringArray = ((FilterDTO)this.getD()).servletNames;
            int n = ((FilterDTO)this.getD()).servletNames.length;
            int n2 = 0;
            while (n2 < n) {
                String servletName = stringArray[n2];
                if (servletName.equals(name)) {
                    return name;
                }
                ++n2;
            }
            return null;
        }
        String[] stringArray = ((FilterDTO)this.getD()).patterns;
        int n = ((FilterDTO)this.getD()).patterns.length;
        int n3 = 0;
        while (n3 < n) {
            String pattern = stringArray[n3];
            if (this.doMatch(pattern, servletPath, pathInfo, extension, match)) {
                return pattern;
            }
            ++n3;
        }
        return null;
    }

    private void createContextAttributes() {
        this.contextController.getProxyContext().createContextAttributes(this.servletContextHelper);
    }

    private void destroyContextAttributes() {
        this.contextController.getProxyContext().destroyContextAttributes(this.servletContextHelper);
    }
}

