/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.ArrayList;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Names;
import org.eclipse.rap.rwt.widgets.DropDown;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class DropDownTab
extends ExampleTab {
    private String[] currentTexts = Names.VALUES;
    private String userText = "";
    private Text text;
    private DropDown dropdown;

    public DropDownTab() {
        super("DropDown");
    }

    protected void createStyleControls(Composite parent) {
        this.createSetVisibleItemCountSpinner(parent);
        this.createShowDropDownButton(parent);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.text = new Text(parent, 2048);
        this.text.setLayoutData((Object)new GridData(300, -1));
        this.text.setMessage("Names");
        this.dropdown = new DropDown((Control)this.text);
        this.dropdown.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        this.dropdown.setItems(DropDownTab.format(this.currentTexts, ""));
        this.addModifyListener();
        this.addSelectionListener();
        this.addDefaultSelectionListener();
    }

    private void createSetVisibleItemCountSpinner(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Visible Item Count");
        final Spinner spinner = new Spinner(composite, 2048);
        spinner.setSelection(this.dropdown.getVisibleItemCount());
        spinner.setLayoutData((Object)new GridData(40, -1));
        spinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DropDownTab.this.dropdown.setVisibleItemCount(spinner.getSelection());
            }
        });
    }

    private void createShowDropDownButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Show DropDown");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DropDownTab.this.dropdown.setVisible(true);
            }
        });
    }

    private void addModifyListener() {
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!Boolean.TRUE.equals(DropDownTab.this.text.getData("selecting"))) {
                    DropDownTab.this.userText = DropDownTab.this.text.getText();
                    if (DropDownTab.this.userText.length() == 0) {
                        DropDownTab.this.currentTexts = Names.VALUES;
                        DropDownTab.this.dropdown.setItems(DropDownTab.format(DropDownTab.this.currentTexts, ""));
                    } else {
                        String searchStr = DropDownTab.this.userText.toLowerCase();
                        DropDownTab.this.currentTexts = DropDownTab.filter(Names.VALUES, searchStr, 10);
                        DropDownTab.this.dropdown.setItems(DropDownTab.format(DropDownTab.this.currentTexts, searchStr));
                        if (DropDownTab.this.currentTexts.length > 10) {
                            DropDownTab.this.dropdown.setSelectionIndex(-1);
                        } else if (DropDownTab.this.currentTexts.length == 1) {
                            DropDownTab.this.dropdown.setSelectionIndex(0);
                        }
                    }
                    DropDownTab.this.dropdown.setVisible(true);
                }
            }
        });
    }

    private void addSelectionListener() {
        this.dropdown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.index != -1) {
                    DropDownTab.this.text.setData("selecting", (Object)Boolean.TRUE);
                    DropDownTab.this.text.setText(DropDownTab.this.currentTexts[event.index]);
                    DropDownTab.this.text.setData("selecting", (Object)Boolean.FALSE);
                    DropDownTab.this.text.selectAll();
                } else {
                    DropDownTab.this.text.setText(DropDownTab.this.userText);
                    DropDownTab.this.text.setSelection(DropDownTab.this.userText.length(), DropDownTab.this.userText.length());
                    DropDownTab.this.text.setFocus();
                }
            }
        });
    }

    private void addDefaultSelectionListener() {
        this.dropdown.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                if (event.index != -1) {
                    DropDownTab.this.text.setText(DropDownTab.this.currentTexts[event.index]);
                    DropDownTab.this.text.setSelection(event.text.length());
                    DropDownTab.this.dropdown.setVisible(false);
                }
            }
        });
    }

    private static String[] filter(String[] values, String text, int limit) {
        ArrayList<String> result = new ArrayList<String>(limit);
        int i = 0;
        while (result.size() < limit && i < values.length) {
            String item = values[i];
            if (item.toLowerCase().startsWith(text)) {
                result.add(item);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static String[] format(String[] values, String text) {
        String[] result = new String[values.length];
        int i = 0;
        while (i < values.length) {
            String item = values[i];
            int length = text.length();
            result[i] = "<b>" + item.substring(0, length) + "</b>" + item.substring(length);
            ++i;
        }
        return result;
    }
}

