/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.theme.CssType;

public class CssBoolean
implements CssType {
    public static final CssBoolean TRUE = new CssBoolean(true);
    public static final CssBoolean FALSE = new CssBoolean(false);
    private static final String[] VALID_TRUE_STRINGS = new String[]{"true", "yes", "on"};
    private static final String[] VALID_FALSE_STRINGS = new String[]{"false", "no", "off"};
    public final boolean value;

    private CssBoolean(boolean value) {
        this.value = value;
    }

    public static CssBoolean valueOf(String input) {
        return CssBoolean.evalInput(input) ? TRUE : FALSE;
    }

    public String toDefaultString() {
        return this.value ? VALID_TRUE_STRINGS[0] : VALID_FALSE_STRINGS[0];
    }

    public String toString() {
        return "CssBoolean{ " + String.valueOf(this.value) + " }";
    }

    private static boolean evalInput(String input) {
        boolean result = false;
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        boolean found = false;
        int i = 0;
        while (i < VALID_TRUE_STRINGS.length && !found) {
            if (VALID_TRUE_STRINGS[i].equals(input)) {
                result = true;
                found = true;
            }
            ++i;
        }
        i = 0;
        while (i < VALID_FALSE_STRINGS.length && !found) {
            if (VALID_FALSE_STRINGS[i].equals(input)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            String message = "Illegal boolean value: " + input;
            throw new IllegalArgumentException(message);
        }
        return result;
    }
}

