/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tabfolderkit;

import java.util.ArrayList;
import org.eclipse.rap.rwt.internal.theme.CssBorder;
import org.eclipse.rap.rwt.internal.theme.CssBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.CssType;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.controlkit.ControlThemeAdapterImpl;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class TabFolderThemeAdapter
extends ControlThemeAdapterImpl {
    public Rectangle getContentContainerBorder(TabFolder folder) {
        return this.getCssBorder("TabFolder-ContentContainer", folder);
    }

    public Rectangle getItemBorder(TabItem item) {
        SimpleSelector selector = TabFolderThemeAdapter.createSelector(item);
        int top = TabFolderThemeAdapter.getBorderEdgeWidth("border-top", selector, item);
        int right = TabFolderThemeAdapter.getBorderEdgeWidth("border-right", selector, item);
        int bottom = TabFolderThemeAdapter.getBorderEdgeWidth("border-bottom", selector, item);
        int left = TabFolderThemeAdapter.getBorderEdgeWidth("border-left", selector, item);
        return new Rectangle(left, top, left + right, top + bottom);
    }

    public Rectangle getItemPadding(TabItem item) {
        CssType cssValue = ThemeUtil.getCssValue("TabItem", "padding", TabFolderThemeAdapter.createSelector(item));
        return CssBoxDimensions.createRectangle((CssBoxDimensions)cssValue);
    }

    public Rectangle getItemMargin(TabItem item) {
        CssType cssValue = ThemeUtil.getCssValue("TabItem", "margin", TabFolderThemeAdapter.createSelector(item));
        return CssBoxDimensions.createRectangle((CssBoxDimensions)cssValue);
    }

    private static int getBorderEdgeWidth(String edge, SimpleSelector selector, TabItem item) {
        CssBorder borderEdge = (CssBorder)ThemeUtil.getCssValue("TabItem", edge, selector, item);
        return borderEdge.width;
    }

    private static SimpleSelector createSelector(TabItem item) {
        ArrayList<String> constraints = new ArrayList<String>();
        if (TabFolderThemeAdapter.isItemOnBottom(item)) {
            constraints.add(":bottom");
        }
        if (TabFolderThemeAdapter.isItemSelected(item)) {
            constraints.add(":selected");
        }
        return new SimpleSelector(constraints.toArray(new String[0]));
    }

    private static boolean isItemOnBottom(TabItem item) {
        return (item.getParent().getStyle() & 0x400) != 0;
    }

    private static boolean isItemSelected(TabItem item) {
        TabFolder folder = item.getParent();
        return folder.indexOf(item) == folder.getSelectionIndex();
    }
}

