/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.textkit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ITextAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextOperationHandler
extends ControlOperationHandler<Text> {
    private static final String PROP_TEXT = "text";
    private static final String PROP_SELECTION = "selection";

    public TextOperationHandler(Text text) {
        super(text);
    }

    @Override
    public void handleSet(Text text, JsonObject properties) {
        super.handleSet(text, properties);
        this.handleSetText(text, properties);
        this.handleSetSelection(text, properties);
    }

    @Override
    public void handleNotify(Text text, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(text, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(text, properties);
        } else if ("Modify".equals(eventName)) {
            this.handleNotifyModify(text, properties);
        } else {
            super.handleNotify(text, eventName, properties);
        }
    }

    public void handleSetText(final Text text, JsonObject properties) {
        JsonValue value = properties.get(PROP_TEXT);
        if (value != null) {
            final String stringValue = value.asString();
            if (EventLCAUtil.isListening(text, 25)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        if (!text.isDisposed()) {
                            TextOperationHandler.setText(text, stringValue);
                            WidgetUtil.getAdapter(text).preserve(TextOperationHandler.PROP_TEXT, stringValue);
                        }
                    }
                });
            } else {
                TextOperationHandler.setText(text, stringValue);
            }
        }
    }

    public void handleSetSelection(final Text text, JsonObject properties) {
        JsonValue value = properties.get(PROP_SELECTION);
        if (value != null) {
            final Point selection = JsonMapping.readPoint(value);
            if (EventLCAUtil.isListening(text, 25)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        if (!text.isDisposed()) {
                            text.setSelection(selection);
                            WidgetUtil.getAdapter(text).preserve(TextOperationHandler.PROP_SELECTION, text.getSelection());
                        }
                    }
                });
            } else {
                text.setSelection(selection);
            }
        }
    }

    public void handleNotifySelection(Text text, JsonObject properties) {
        if ((text.getStyle() & 2) == 0) {
            Event event = TextOperationHandler.createSelectionEvent(13, properties);
            text.notifyListeners(13, event);
        }
    }

    public void handleNotifyDefaultSelection(Text text, JsonObject properties) {
        if ((text.getStyle() & 2) == 0) {
            Event event = TextOperationHandler.createSelectionEvent(14, properties);
            text.notifyListeners(14, event);
        }
    }

    public void handleNotifyModify(Text text, JsonObject properties) {
    }

    private static void setText(Text text, String value) {
        text.getAdapter(ITextAdapter.class).setText(value);
    }
}

