/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    private final Point PREFERRED_SIZE = new Point(160, 41);
    private int increment = 1;
    private int maximum = 100;
    private int minimum;
    private int pageIncrement = 10;
    private int selection;

    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Rectangle border = this.getBorder();
        int width = border.width;
        int height = border.height;
        if ((this.style & 0x100) != 0) {
            width += this.PREFERRED_SIZE.x;
            height += this.PREFERRED_SIZE.y;
        } else {
            width += this.PREFERRED_SIZE.y;
            height += this.PREFERRED_SIZE.x;
        }
        if (wHint != -1) {
            width = wHint + border.width;
        }
        if (hHint != -1) {
            height = hHint + border.height;
        }
        return new Point(width, height);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        if (increment >= 1 && increment <= this.maximum - this.minimum) {
            this.increment = increment;
        }
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        if (this.minimum >= 0 && this.minimum < maximum) {
            this.maximum = maximum;
            if (this.selection > this.maximum) {
                this.selection = this.maximum;
            }
        }
    }

    public void setMinimum(int minimum) {
        this.checkWidget();
        if (minimum >= 0 && minimum < this.maximum) {
            this.minimum = minimum;
            if (this.selection < this.minimum) {
                this.selection = this.minimum;
            }
        }
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        if (pageIncrement >= 1 && pageIncrement <= this.maximum - this.minimum) {
            this.pageIncrement = pageIncrement;
        }
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (selection >= this.minimum && selection <= this.maximum) {
            this.selection = selection;
        }
    }

    private static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    boolean isTabGroup() {
        return true;
    }
}

