/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.toolbarkit.ToolBarThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBar
extends Composite {
    private static final int DEFAULT_TOOLBAR_WIDTH = 24;
    private static final int DEFAULT_TOOLBAR_HEIGHT = 22;
    private final ItemHolder<ToolItem> itemHolder;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        this.itemHolder = new ItemHolder<ToolItem>(ToolItem.class);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        ItemHolder<ToolItem> result = adapter == IItemHolderAdapter.class ? this.itemHolder : super.getAdapter(adapter);
        return (T)result;
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        return this.itemHolder.getItem(index);
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem result = null;
        ToolItem[] items = this.getItems();
        int i = 0;
        while (result == null && i < items.length) {
            Rectangle rect = items[i].getBounds();
            if (rect.contains(point)) {
                result = items[i];
            }
            ++i;
        }
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return (ToolItem[])this.itemHolder.getItems();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return this.itemHolder.indexOf(item);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        Rectangle itemBounds;
        ToolItem item;
        int i;
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x200) != 0) {
            i = 0;
            while (i < this.itemHolder.size()) {
                item = this.itemHolder.getItem(i);
                itemBounds = item.getBounds();
                width = Math.max(width, itemBounds.width);
                if (i == this.itemHolder.size() - 1) {
                    height += itemBounds.height + itemBounds.y;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.itemHolder.size()) {
                item = this.itemHolder.getItem(i);
                itemBounds = item.getBounds();
                height = Math.max(height, itemBounds.height);
                if (i == this.itemHolder.size() - 1) {
                    width += itemBounds.width + itemBounds.x;
                }
                ++i;
            }
        }
        height += this.getToolBarPadding().height;
        if ((width += this.getToolBarPadding().width) == 0) {
            width = 24;
        }
        if (height == 0) {
            height = 22;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        i = 0;
        while (i < this.itemHolder.size()) {
            item = this.itemHolder.getItem(i);
            item.resizeControl();
            ++i;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    Rectangle getToolBarPadding() {
        ToolBarThemeAdapter themeAdapter = (ToolBarThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getToolBarPadding(this);
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        Point oldSize = this.getSize();
        super.setBounds(bounds);
        if (!oldSize.equals(this.getSize())) {
            this.layoutItems();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.layoutItems();
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] items = (ToolItem[])this.itemHolder.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && item.getControl() == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    @Override
    final void releaseChildren() {
        ToolItem[] toolItems = (ToolItem[])this.itemHolder.getItems();
        int i = 0;
        while (i < toolItems.length) {
            toolItems[i].dispose();
            ++i;
        }
    }

    private static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    void createItem(ToolItem item, int index) {
        ItemHolder.getItemHolder(this).insert(item, index);
        this.layoutItems();
    }

    void destroyItem(ToolItem item) {
        ItemHolder.getItemHolder(this).remove(item);
        this.layoutItems();
    }

    void layoutItems() {
        int i = 0;
        while (i < this.itemHolder.size()) {
            ToolItem item = this.itemHolder.getItem(i);
            Rectangle ibounds = item.getBounds();
            boolean hasEnoughWidth = ibounds.x + ibounds.width <= this.bounds.width;
            boolean hasEnoughHeight = ibounds.y + ibounds.height <= this.bounds.height;
            item.setVisible(hasEnoughWidth && hasEnoughHeight);
            item.resizeControl();
            ++i;
        }
    }

    @Override
    void reskinChildren(int flags) {
        ToolItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                ToolItem item = items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }
}

