/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.GCAdapter;
import org.eclipse.swt.internal.graphics.IGCAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Canvas
extends Composite {
    private transient GCAdapter gcAdapter;

    Canvas(Composite parent) {
        super(parent);
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IGCAdapter.class) {
            if (this.gcAdapter == null) {
                this.gcAdapter = new GCAdapter();
            }
            result = this.gcAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(9, listener);
    }

    @Override
    void notifyResize(Point oldSize) {
        super.notifyResize(oldSize);
        if (!oldSize.equals(this.getSize())) {
            this.repaint();
        }
    }

    @Override
    void internalSetRedraw(boolean redraw) {
        super.internalSetRedraw(redraw);
        if (redraw) {
            this.repaint();
        }
    }

    private void repaint() {
        if (this.gcAdapter != null) {
            this.gcAdapter.clearGCOperations();
            this.gcAdapter.setForceRedraw(true);
        }
        GC gc = new GC(this);
        Event paintEvent = new Event();
        paintEvent.gc = gc;
        paintEvent.setBounds(this.getClientArea());
        this.notifyListeners(9, paintEvent);
        gc.dispose();
    }
}

