/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import java.util.ArrayList;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.core.databinding";
    private static volatile ServiceTracker<FrameworkLog, FrameworkLog> _frameworkLogTracker;

    public void start(BundleContext context) throws Exception {
        _frameworkLogTracker = new ServiceTracker(context, FrameworkLog.class, null);
        _frameworkLogTracker.open();
        Policy.setLog(new ILogger(){

            @Override
            public void log(IStatus status) {
                FrameworkLog log;
                ServiceTracker frameworkLogTracker = _frameworkLogTracker;
                FrameworkLog frameworkLog = log = frameworkLogTracker == null ? null : (FrameworkLog)frameworkLogTracker.getService();
                if (log != null) {
                    log.log(Activator.this.createLogEntry(status));
                } else {
                    System.err.println(String.valueOf(status.getPlugin()) + " - " + status.getCode() + " - " + status.getMessage());
                    if (status.getException() != null) {
                        status.getException().printStackTrace(System.err);
                    }
                }
            }
        });
    }

    FrameworkLogEntry createLogEntry(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(this.createLogEntry(coreStatus));
        }
        if (status.isMultiStatus()) {
            children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                childlist.add(this.createLogEntry(children[i]));
                ++i;
            }
        }
        children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry(status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), stackCode, t, (FrameworkLogEntry[])children);
    }

    public void stop(BundleContext context) throws Exception {
        if (_frameworkLogTracker != null) {
            _frameworkLogTracker.close();
            _frameworkLogTracker = null;
        }
    }
}

