/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.servlet.RequestDispatcherAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;
import org.eclipse.equinox.http.servlet.internal.util.Params;

public class HttpServletRequestWrapperImpl
extends HttpServletRequestWrapper {
    private static final String[] dispatcherAttributes = new String[]{"javax.servlet.forward.context_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string", "javax.servlet.forward.request_uri", "javax.servlet.forward.servlet_path", "javax.servlet.include.context_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.include.request_uri", "javax.servlet.include.servlet_path"};
    private final ThreadLocal<Deque<State>> state = new ThreadLocal<Deque<State>>(){

        @Override
        protected Deque<State> initialValue() {
            return new ArrayDeque<State>();
        }
    };
    private final HttpServletRequest request;

    public static HttpServletRequestWrapperImpl findHttpRuntimeRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            if (request instanceof HttpServletRequestWrapperImpl) {
                return (HttpServletRequestWrapperImpl)request;
            }
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public HttpServletRequestWrapperImpl(HttpServletRequest request, DispatchTargets dispatchTargets, DispatcherType dispatcherType) {
        super(request);
        this.request = request;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            attributes.put(name, request.getAttribute(name));
        }
        this.getState().push(new State(dispatchTargets, dispatcherType, attributes, request.getParameterMap(), request.getQueryString()));
    }

    public void destroy() {
        this.state.remove();
    }

    public String getAuthType() {
        String authType = (String)this.request.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.request.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return this.request.getRemoteUser();
    }

    public String getPathInfo() {
        State current = this.currentState();
        State original = this.originalState();
        if (current.getDispatchTargets().getServletName() != null) {
            return original.getDispatchTargets().getRequestURI();
        }
        if (current.getDispatcherType() == DispatcherType.INCLUDE) {
            return original.getDispatchTargets().getPathInfo();
        }
        return current.getDispatchTargets().getPathInfo();
    }

    public DispatcherType getDispatcherType() {
        return this.currentState().getDispatcherType();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.currentState().getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getQueryString() {
        return this.currentState().getQueryString();
    }

    public ServletContext getServletContext() {
        return this.currentState().getDispatchTargets().getServletRegistration().getServletContext();
    }

    public String getServletPath() {
        if (this.currentState().getDispatchTargets().getServletName() != null) {
            return "";
        }
        if (this.currentState().getDispatcherType() == DispatcherType.INCLUDE) {
            return this.originalState().getDispatchTargets().getServletPath();
        }
        return this.currentState().getDispatchTargets().getServletPath();
    }

    public String getContextPath() {
        if (this.currentState().getDispatcherType() == DispatcherType.INCLUDE) {
            return this.originalState().getDispatchTargets().getContextController().getFullContextPath();
        }
        return this.currentState().getDispatchTargets().getContextController().getFullContextPath();
    }

    public String getRequestURI() {
        State current = this.currentState();
        DispatchTargets currentDispatchTargets = current.getDispatchTargets();
        if (currentDispatchTargets.getServletName() != null || current.getDispatcherType() == DispatcherType.INCLUDE) {
            return this.originalState().getDispatchTargets().getRequestURI();
        }
        return currentDispatchTargets.getRequestURI();
    }

    public Object getAttribute(String attributeName) {
        Map<String, Object> attributes;
        State current = this.currentState();
        DispatchTargets currentDispatchTargets = current.getDispatchTargets();
        if (Arrays.binarySearch(dispatcherAttributes, attributeName) > -1) {
            if (currentDispatchTargets.getServletName() != null) {
                return null;
            }
            if (current.getOverloadedAttributes().containsKey(attributeName)) {
                return current.getOverloadedAttributes().get(attributeName);
            }
        }
        if (current.getDispatcherType() == DispatcherType.INCLUDE) {
            if (attributeName.equals("javax.servlet.include.context_path")) {
                return currentDispatchTargets.getContextController().getFullContextPath();
            }
            if (attributeName.equals("javax.servlet.include.path_info")) {
                return currentDispatchTargets.getPathInfo();
            }
            if (attributeName.equals("javax.servlet.include.query_string")) {
                return currentDispatchTargets.getQueryString();
            }
            if (attributeName.equals("javax.servlet.include.request_uri")) {
                return currentDispatchTargets.getRequestURI();
            }
            if (attributeName.equals("javax.servlet.include.servlet_path")) {
                return currentDispatchTargets.getServletPath();
            }
        }
        if (current.getDispatcherType() == DispatcherType.FORWARD) {
            State original = this.originalState();
            DispatchTargets originalDispatchTargets = original.getDispatchTargets();
            if (attributeName.equals("javax.servlet.forward.context_path")) {
                return originalDispatchTargets.getContextController().getFullContextPath();
            }
            if (attributeName.equals("javax.servlet.forward.path_info")) {
                return originalDispatchTargets.getPathInfo();
            }
            if (attributeName.equals("javax.servlet.forward.query_string")) {
                return original.getQueryString();
            }
            if (attributeName.equals("javax.servlet.forward.request_uri")) {
                return originalDispatchTargets.getRequestURI();
            }
            if (attributeName.equals("javax.servlet.forward.servlet_path")) {
                return originalDispatchTargets.getServletPath();
            }
        }
        if ((attributes = current.getAttributes()).containsKey(attributeName)) {
            return attributes.get(attributeName);
        }
        return this.request.getAttribute(attributeName);
    }

    public Enumeration<String> getAttributeNames() {
        State current = this.currentState();
        HashSet<String> names = new HashSet<String>();
        names.addAll(current.getAttributes().keySet());
        names.addAll(current.getOverloadedAttributes().keySet());
        return Collections.enumeration(names);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        State current = this.currentState();
        ContextController contextController = current.getDispatchTargets().getContextController();
        if (!path.startsWith("/")) {
            path = String.valueOf(current.getDispatchTargets().getServletPath()) + "/" + path;
        } else if (path.startsWith(contextController.getFullContextPath())) {
            path = path.substring(contextController.getFullContextPath().length());
        }
        DispatchTargets requestedDispatchTargets = contextController.getDispatchTargets(path, null);
        if (requestedDispatchTargets == null) {
            return null;
        }
        return new RequestDispatcherAdaptor(requestedDispatchTargets, path);
    }

    public static String getDispatchPathInfo(HttpServletRequest req) {
        if (req.getDispatcherType() == DispatcherType.INCLUDE) {
            return (String)req.getAttribute("javax.servlet.include.path_info");
        }
        return req.getPathInfo();
    }

    public HttpSession getSession() {
        HttpSession session = this.request.getSession();
        if (session != null) {
            DispatchTargets dispatchTargets = this.currentState().getDispatchTargets();
            return dispatchTargets.getContextController().getSessionAdaptor(session, ((Servlet)dispatchTargets.getServletRegistration().getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.request.getSession(create);
        if (session != null) {
            DispatchTargets dispatchTargets = this.currentState().getDispatchTargets();
            return dispatchTargets.getContextController().getSessionAdaptor(session, ((Servlet)dispatchTargets.getServletRegistration().getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public synchronized void pop() {
        this.getState().pop();
    }

    public synchronized void push(DispatchTargets dispatchTargets, DispatcherType dispatcherType) {
        State previous = this.getState().peek();
        this.getState().push(new State(dispatchTargets, dispatcherType, previous.getAttributes(), previous.getParameterMap(), previous.getQueryString()));
    }

    public void removeAttribute(String name) {
        State current = this.getState().peek();
        if (Arrays.binarySearch(dispatcherAttributes, name) > -1 && current.getOverloadedAttributes().containsKey(name)) {
            current.getOverloadedAttributes().remove(name);
        } else {
            current.getAttributes().remove(name);
        }
        EventListeners eventListeners = current.getDispatchTargets().getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(current.getDispatchTargets().getServletRegistration().getServletContext(), (ServletRequest)this, name, null);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void setAttribute(String name, Object value) {
        boolean added;
        State current = this.getState().peek();
        boolean bl = added = !current.getAttributes().containsKey(name);
        if (Arrays.binarySearch(dispatcherAttributes, name) > -1) {
            added = !current.getOverloadedAttributes().containsKey(name);
            current.getOverloadedAttributes().put(name, value);
        } else {
            current.getAttributes().put(name, value);
        }
        EventListeners eventListeners = current.getDispatchTargets().getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(current.getDispatchTargets().getServletRegistration().getServletContext(), (ServletRequest)this, name, value);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            if (added) {
                servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
                continue;
            }
            servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }

    private State currentState() {
        return this.getState().peek();
    }

    private State originalState() {
        return this.getState().peekLast();
    }

    private Deque<State> getState() {
        return this.state.get();
    }

    public class State {
        private final Map<String, Object> attributes;
        private final DispatchTargets dispatchTargets;
        private final DispatcherType dispatcherType;
        private final Map<String, Object> overloadedAttributes = new HashMap<String, Object>();
        private final Map<String, String[]> parameterMap;
        private final String previousQueryString;
        private final String queryString;
        private final String string;

        public State(DispatchTargets dispatchTargets, DispatcherType dispatcherType, Map<String, Object> previousAttributes, Map<String, String[]> previousParams, String previousQueryString) {
            String[] values;
            this.dispatchTargets = dispatchTargets;
            this.dispatcherType = dispatcherType;
            HashMap<String, Object> attributesCopy = new HashMap<String, Object>();
            attributesCopy.putAll(previousAttributes);
            this.attributes = attributesCopy;
            HashMap<String, String[]> parameterMapCopy = new HashMap<String, String[]>();
            for (Map.Entry<String, String[]> entry : dispatchTargets.getParameterMap().entrySet()) {
                values = (String[])parameterMapCopy.get(entry.getKey());
                values = Params.append(values, entry.getValue());
                parameterMapCopy.put(entry.getKey(), values);
            }
            if (previousParams != null) {
                for (Map.Entry<String, String[]> entry : previousParams.entrySet()) {
                    values = (String[])parameterMapCopy.get(entry.getKey());
                    values = Params.append(values, entry.getValue());
                    parameterMapCopy.put(entry.getKey(), values);
                }
            }
            this.parameterMap = parameterMapCopy;
            String queryStringCopy = previousQueryString;
            if (dispatchTargets.getQueryString() != null && dispatchTargets.getQueryString().length() > 0 && queryStringCopy != null && queryStringCopy.length() > 0) {
                queryStringCopy = String.valueOf(dispatchTargets.getQueryString()) + "&" + queryStringCopy;
            }
            this.queryString = queryStringCopy;
            this.previousQueryString = previousQueryString;
            this.string = String.valueOf(this.getClass().getSimpleName()) + '[' + dispatcherType + ", " + dispatchTargets + ", " + this.queryString + ']';
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public DispatcherType getDispatcherType() {
            return this.dispatcherType;
        }

        public DispatchTargets getDispatchTargets() {
            return this.dispatchTargets;
        }

        public Map<String, Object> getOverloadedAttributes() {
            return this.overloadedAttributes;
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameterMap;
        }

        public String getPreviousQueryString() {
            return this.previousQueryString;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String toString() {
            return this.string;
        }
    }
}

