/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.client;

import java.util.Locale;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.RWTMessages;
import org.eclipse.rap.rwt.internal.client.ClientMessages;
import org.eclipse.rap.rwt.internal.remote.ConnectionImpl;
import org.eclipse.rap.rwt.remote.RemoteObject;

public class WebClientMessages
implements ClientMessages {
    private static final String REMOTE_ID = "rwt.client.ClientMessages";
    private static final String PROP_MESSAGES = "messages";
    private static final String[] MESSAGE_IDS = new String[]{"ServerError", "ServerErrorDescription", "ConnectionError", "ConnectionErrorDescription", "SessionTimeout", "SessionTimeoutDescription", "ClientError", "Retry", "Restart", "Details"};
    private RemoteObject remoteObject;
    private String[] messages;

    public WebClientMessages() {
        ConnectionImpl connection = (ConnectionImpl)RWT.getUISession().getConnection();
        this.remoteObject = connection.createServiceObject(REMOTE_ID);
        this.messages = new String[MESSAGE_IDS.length];
    }

    @Override
    public void update(Locale locale) {
        JsonObject messagesObject = new JsonObject();
        int i = 0;
        while (i < MESSAGE_IDS.length) {
            String newMessage = this.getMessage(MESSAGE_IDS[i], locale);
            if (!newMessage.equals(this.messages[i])) {
                this.messages[i] = newMessage;
                messagesObject.add(MESSAGE_IDS[i], newMessage);
            }
            ++i;
        }
        if (!messagesObject.isEmpty()) {
            this.remoteObject.set(PROP_MESSAGES, messagesObject);
        }
    }

    String getMessage(String messageId, Locale locale) {
        return RWTMessages.getMessage(messageId, locale);
    }
}

