/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.util.ActiveKeysUtil;
import org.eclipse.swt.internal.widgets.ControlRemoteAdapter;
import org.eclipse.swt.internal.widgets.ControlUtil;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class ControlLCAUtil {
    private static final String PROP_ACTIVATE_LISTENER = "Activate";
    private static final String PROP_DEACTIVATE_LISTENER = "Deactivate";
    private static final String PROP_FOCUS_IN_LISTENER = "FocusIn";
    private static final String PROP_FOCUS_OUT_LISTENER = "FocusOut";
    private static final String PROP_MOUSE_DOWN_LISTENER = "MouseDown";
    private static final String PROP_MOUSE_DOUBLE_CLICK_LISTENER = "MouseDoubleClick";
    private static final String PROP_MOUSE_UP_LISTENER = "MouseUp";
    private static final String PROP_TRAVERSE_LISTENER = "Traverse";
    private static final String PROP_MENU_DETECT_LISTENER = "MenuDetect";
    private static final String PROP_HELP_LISTENER = "Help";

    private ControlLCAUtil() {
    }

    public static void renderChanges(Control control) {
        ControlRemoteAdapter remoteAdapter = ControlLCAUtil.getRemoteAdapter(control);
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        if (control instanceof Shell) {
            ControlLCAUtil.recalculateTabIndex((Shell)control);
        }
        remoteAdapter.renderParent(control);
        if (control instanceof Composite) {
            remoteAdapter.renderChildren((Composite)control);
        }
        remoteAdapter.renderBounds(controlAdapter);
        remoteAdapter.renderTabIndex(control);
        WidgetLCAUtil.renderToolTipMarkupEnabled(control);
        remoteAdapter.renderToolTipText(control);
        remoteAdapter.renderMenu(control);
        remoteAdapter.renderVisible(control);
        remoteAdapter.renderEnabled(control);
        remoteAdapter.renderOrientation(control);
        remoteAdapter.renderForeground(controlAdapter);
        remoteAdapter.renderBackground(controlAdapter);
        remoteAdapter.renderBackgroundImage(controlAdapter);
        remoteAdapter.renderFont(controlAdapter);
        remoteAdapter.renderCursor(control);
        WidgetLCAUtil.renderData(control);
        ActiveKeysUtil.renderActiveKeys(control);
        ActiveKeysUtil.renderCancelKeys(control);
        ControlLCAUtil.renderListenActivate(control);
        ControlLCAUtil.renderListenMouse(control);
        ControlLCAUtil.renderListenFocus(control);
        WidgetLCAUtil.renderListenKey(control);
        ControlLCAUtil.renderListenTraverse(control);
        ControlLCAUtil.renderListenMenuDetect(control);
        ControlLCAUtil.renderListenHelp(control);
    }

    private static void recalculateTabIndex(Shell shell) {
        ControlLCAUtil.resetTabIndices(shell);
        ControlLCAUtil.computeTabIndices(shell, 1);
    }

    private static void resetTabIndices(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            ControlUtil.getControlAdapter(control).setTabIndex(-1);
            if (control instanceof Composite) {
                ControlLCAUtil.resetTabIndices((Composite)control);
            }
            ++n2;
        }
    }

    private static int computeTabIndices(Composite composite, int startIndex) {
        int result = startIndex;
        Control[] controlArray = composite.getTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            ControlUtil.getControlAdapter(control).setTabIndex(result);
            result += control instanceof Link ? 300 : 1;
            if (control instanceof Composite) {
                result = ControlLCAUtil.computeTabIndices((Composite)control, result);
            }
            ++n2;
        }
        return result;
    }

    private static void renderListenActivate(Control control) {
        if (!(control instanceof Shell)) {
            WidgetLCAUtil.renderListener(control, 26, PROP_ACTIVATE_LISTENER);
            WidgetLCAUtil.renderListener(control, 27, PROP_DEACTIVATE_LISTENER);
        }
    }

    private static void renderListenMouse(Control control) {
        WidgetLCAUtil.renderListener(control, 3, PROP_MOUSE_DOWN_LISTENER);
        WidgetLCAUtil.renderListener(control, 4, PROP_MOUSE_UP_LISTENER);
        WidgetLCAUtil.renderListener(control, 8, PROP_MOUSE_DOUBLE_CLICK_LISTENER);
    }

    private static void renderListenFocus(Control control) {
        if ((control.getStyle() & 0x80000) == 0) {
            WidgetLCAUtil.renderListener(control, 15, PROP_FOCUS_IN_LISTENER);
            WidgetLCAUtil.renderListener(control, 16, PROP_FOCUS_OUT_LISTENER);
        }
    }

    private static void renderListenTraverse(Control control) {
        WidgetLCAUtil.renderListener(control, 31, PROP_TRAVERSE_LISTENER);
    }

    private static void renderListenMenuDetect(Control control) {
        WidgetLCAUtil.renderListener(control, 35, PROP_MENU_DETECT_LISTENER);
    }

    private static void renderListenHelp(Control control) {
        WidgetLCAUtil.renderListener(control, 28, PROP_HELP_LISTENER);
    }

    private static ControlRemoteAdapter getRemoteAdapter(Control control) {
        return (ControlRemoteAdapter)control.getAdapter(RemoteAdapter.class);
    }
}

