/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public abstract class ControlOperationHandler<T extends Control>
extends WidgetOperationHandler<T> {
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_VISIBILITY = "visibility";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_TOOL_TIP = "toolTip";
    private static final String PROP_CURSOR = "cursor";

    public ControlOperationHandler(T control) {
        super(control);
    }

    @Override
    public void handleSet(T control, JsonObject properties) {
        this.handleSetForeground(control, properties);
        this.handleSetBackground(control, properties);
        this.handleSetVisibility(control, properties);
        this.handleSetEnabled(control, properties);
        this.handleSetToolTip(control, properties);
        this.handleSetCursor(control, properties);
    }

    @Override
    public void handleNotify(T control, String eventName, JsonObject properties) {
        if ("FocusIn".equals(eventName)) {
            this.handleNotifyFocusIn(control, properties);
        } else if ("FocusOut".equals(eventName)) {
            this.handleNotifyFocusOut(control, properties);
        } else if ("MouseDown".equals(eventName)) {
            this.handleNotifyMouseDown(control, properties);
        } else if ("MouseDoubleClick".equals(eventName)) {
            this.handleNotifyMouseDoubleClick(control, properties);
        } else if ("MouseUp".equals(eventName)) {
            this.handleNotifyMouseUp(control, properties);
        } else if ("Traverse".equals(eventName)) {
            this.handleNotifyTraverse(control, properties);
        } else if ("KeyDown".equals(eventName)) {
            this.handleNotifyKeyDown(control, properties);
        } else if ("MenuDetect".equals(eventName)) {
            this.handleNotifyMenuDetect(control, properties);
        } else if ("Help".equals(eventName)) {
            this.handleNotifyHelp(control, properties);
        } else if ("Activate".equals(eventName)) {
            this.handleNotifyActivate(control, properties);
        } else if ("Deactivate".equals(eventName)) {
            this.handleNotifyDeactivate(control, properties);
        } else {
            super.handleNotify(control, eventName, properties);
        }
    }

    public void handleSetForeground(T control, JsonObject properties) {
        JsonValue value = properties.get(PROP_FOREGROUND);
        if (value != null) {
            Color foreground = null;
            if (!value.isNull()) {
                JsonArray arrayValue = value.asArray();
                foreground = new Color(((Widget)control).getDisplay(), arrayValue.get(0).asInt(), arrayValue.get(1).asInt(), arrayValue.get(2).asInt());
            }
            ((Control)control).setForeground(foreground);
        }
    }

    public void handleSetBackground(T control, JsonObject properties) {
        JsonValue value = properties.get(PROP_BACKGROUND);
        if (value != null) {
            Color background = null;
            if (!value.isNull()) {
                JsonArray arrayValue = value.asArray();
                background = new Color(((Widget)control).getDisplay(), arrayValue.get(0).asInt(), arrayValue.get(1).asInt(), arrayValue.get(2).asInt());
            }
            ((Control)control).setBackground(background);
        }
    }

    public void handleSetVisibility(T control, JsonObject properties) {
        JsonValue value = properties.get(PROP_VISIBILITY);
        if (value != null) {
            ((Control)control).setVisible(value.asBoolean());
        }
    }

    public void handleSetEnabled(T control, JsonObject properties) {
        JsonValue value = properties.get(PROP_ENABLED);
        if (value != null) {
            ((Control)control).setEnabled(value.asBoolean());
        }
    }

    public void handleSetToolTip(T control, JsonObject properties) {
        JsonValue value = properties.get(PROP_TOOL_TIP);
        if (value != null) {
            String toolTipText = value.isNull() ? null : value.asString();
            ((Control)control).setToolTipText(toolTipText);
        }
    }

    public void handleSetCursor(T control, JsonObject properties) {
        JsonValue value = properties.get(PROP_CURSOR);
        if (value != null) {
            Cursor cursor = null;
            if (!value.isNull()) {
                cursor = new Cursor(((Widget)control).getDisplay(), ControlOperationHandler.translateCursor(value.asString()));
            }
            ((Control)control).setCursor(cursor);
        }
    }

    public void handleNotifyFocusIn(T control, JsonObject properties) {
        ((Widget)control).notifyListeners(15, new Event());
    }

    public void handleNotifyFocusOut(T control, JsonObject properties) {
        ((Widget)control).notifyListeners(16, new Event());
    }

    public void handleNotifyMouseDown(T control, JsonObject properties) {
        Event event = ControlOperationHandler.createMouseEvent(3, control, properties);
        if (this.allowMouseEvent(control, event.x, event.y)) {
            ((Widget)control).notifyListeners(event.type, event);
        }
    }

    public void handleNotifyMouseDoubleClick(T control, JsonObject properties) {
        Event event = ControlOperationHandler.createMouseEvent(8, control, properties);
        if (this.allowMouseEvent(control, event.x, event.y)) {
            ((Widget)control).notifyListeners(event.type, event);
        }
    }

    public void handleNotifyMouseUp(T control, JsonObject properties) {
        Event event = ControlOperationHandler.createMouseEvent(4, control, properties);
        if (this.allowMouseEvent(control, event.x, event.y)) {
            ((Widget)control).notifyListeners(event.type, event);
        }
    }

    public void handleNotifyTraverse(T control, JsonObject properties) {
        ControlOperationHandler.processTraverseEvent(control, properties);
    }

    public void handleNotifyKeyDown(T control, JsonObject properties) {
        ((Widget)control).notifyListeners(1, ControlOperationHandler.createKeyEvent(properties));
        ((Widget)control).notifyListeners(2, ControlOperationHandler.createKeyEvent(properties));
    }

    public void handleNotifyMenuDetect(T control, JsonObject properties) {
        ((Widget)control).notifyListeners(35, ControlOperationHandler.createMenuDetectEvent(properties));
    }

    public void handleNotifyHelp(T control, JsonObject properties) {
        ((Widget)control).notifyListeners(28, new Event());
    }

    public void handleNotifyActivate(T control, JsonObject properties) {
    }

    public void handleNotifyDeactivate(T control, JsonObject properties) {
    }

    static Event createMouseEvent(int eventType, Control control, JsonObject properties) {
        Event event = new Event();
        event.type = eventType;
        event.widget = control;
        event.button = properties.get("button").asInt();
        int x = properties.get("x").asInt();
        int y = properties.get("y").asInt();
        Point point = control.getDisplay().map(null, control, x, y);
        event.x = point.x;
        event.y = point.y;
        event.time = properties.get("time").asInt();
        event.stateMask = ControlOperationHandler.readStateMask(properties) | EventLCAUtil.translateButton(event.button);
        event.count = ControlOperationHandler.determineCount(eventType, control);
        return event;
    }

    protected boolean allowMouseEvent(T control, int x, int y) {
        return x >= 0 && y >= 0;
    }

    private static int determineCount(int eventType, Control control) {
        if (eventType == 8 || ProtocolUtil.wasEventSent(WidgetUtil.getId(control), "MouseDoubleClick")) {
            return 2;
        }
        return 1;
    }

    private static void processTraverseEvent(Control control, JsonObject properties) {
        int keyCode = properties.get("keyCode").asInt();
        int charCode = properties.get("charCode").asInt();
        int stateMask = ControlOperationHandler.readStateMask(properties);
        int traverseKey = ControlOperationHandler.getTraverseKey(keyCode, stateMask);
        if (traverseKey != 0) {
            Event event = ControlOperationHandler.createKeyEvent(keyCode, charCode, stateMask);
            event.detail = traverseKey;
            control.notifyListeners(31, event);
        }
    }

    static Event createKeyEvent(JsonObject properties) {
        int keyCode = properties.get("keyCode").asInt();
        int charCode = properties.get("charCode").asInt();
        int stateMask = ControlOperationHandler.readStateMask(properties);
        return ControlOperationHandler.createKeyEvent(keyCode, charCode, stateMask);
    }

    static Event createMenuDetectEvent(JsonObject properties) {
        Event event = new Event();
        event.x = properties.get("x").asInt();
        event.y = properties.get("y").asInt();
        return event;
    }

    static Event createKeyEvent(int keyCode, int charCode, int stateMask) {
        Event event = new Event();
        event.keyCode = ControlOperationHandler.translateKeyCode(keyCode);
        if (charCode == 0) {
            if ((event.keyCode & 0x1000000) == 0) {
                event.character = ControlOperationHandler.translateCharacter(event.keyCode);
            }
        } else {
            event.character = ControlOperationHandler.translateCharacter(charCode);
            if (Character.isLetter(charCode)) {
                event.keyCode = Character.toLowerCase(charCode);
            }
        }
        event.stateMask = stateMask;
        return event;
    }

    static int getTraverseKey(int keyCode, int stateMask) {
        switch (keyCode) {
            case 27: {
                return 2;
            }
            case 13: {
                return 4;
            }
            case 9: {
                if ((stateMask & SWT.MODIFIER_MASK) == 0) {
                    return 16;
                }
                if (stateMask == 131072) {
                    return 8;
                }
                return 0;
            }
        }
        return 0;
    }

    static int translateKeyCode(int keyCode) {
        switch (keyCode) {
            case 16: {
                return 131072;
            }
            case 17: {
                return 262144;
            }
            case 18: {
                return 65536;
            }
            case 20: {
                return 16777298;
            }
            case 38: {
                return 0x1000001;
            }
            case 37: {
                return 0x1000003;
            }
            case 39: {
                return 0x1000004;
            }
            case 40: {
                return 0x1000002;
            }
            case 33: {
                return 0x1000005;
            }
            case 34: {
                return 0x1000006;
            }
            case 35: {
                return 0x1000008;
            }
            case 36: {
                return 0x1000007;
            }
            case 45: {
                return 0x1000009;
            }
            case 46: {
                return 127;
            }
            case 112: {
                return 0x100000A;
            }
            case 113: {
                return 0x100000B;
            }
            case 114: {
                return 0x100000C;
            }
            case 115: {
                return 0x100000D;
            }
            case 116: {
                return 0x100000E;
            }
            case 117: {
                return 0x100000F;
            }
            case 118: {
                return 0x1000010;
            }
            case 119: {
                return 0x1000011;
            }
            case 120: {
                return 0x1000012;
            }
            case 121: {
                return 0x1000013;
            }
            case 122: {
                return 0x1000014;
            }
            case 123: {
                return 0x1000015;
            }
            case 144: {
                return 16777299;
            }
            case 44: {
                return 16777303;
            }
            case 145: {
                return 16777300;
            }
            case 19: {
                return 0x1000055;
            }
        }
        return keyCode;
    }

    private static char translateCharacter(int keyCode) {
        char result = '\u0000';
        if (Character.isDefined((char)keyCode)) {
            result = (char)keyCode;
        }
        return result;
    }

    private static int translateCursor(String cursor) {
        int result;
        if ("default".equals(cursor)) {
            result = 0;
        } else if ("wait".equals(cursor)) {
            result = 1;
        } else if ("progress".equals(cursor)) {
            result = 3;
        } else if ("crosshair".equals(cursor)) {
            result = 2;
        } else if ("help".equals(cursor)) {
            result = 4;
        } else if ("move".equals(cursor)) {
            result = 5;
        } else if ("row-resize".equals(cursor)) {
            result = 7;
        } else if ("col-resize".equals(cursor)) {
            result = 9;
        } else if ("n-resize".equals(cursor)) {
            result = 10;
        } else if ("s-resize".equals(cursor)) {
            result = 11;
        } else if ("e-resize".equals(cursor)) {
            result = 12;
        } else if ("w-resize".equals(cursor)) {
            result = 13;
        } else if ("ne-resize".equals(cursor)) {
            result = 14;
        } else if ("se-resize".equals(cursor)) {
            result = 15;
        } else if ("sw-resize".equals(cursor)) {
            result = 16;
        } else if ("nw-resize".equals(cursor)) {
            result = 17;
        } else if ("text".equals(cursor)) {
            result = 19;
        } else if ("pointer".equals(cursor)) {
            result = 21;
        } else if ("not-allowed".equals(cursor)) {
            result = 20;
        } else {
            throw new IllegalArgumentException("Unsupported cursor: " + cursor);
        }
        return result;
    }
}

