/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.SimpleLifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.widgets.BrowserCallback;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.browser.browserkit.BrowserLCA;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Browser
extends Composite {
    private static final String FUNCTIONS_TO_CREATE = String.valueOf(Browser.class.getName()) + "#functionsToCreate.";
    private static final String FUNCTIONS_TO_DESTROY = String.valueOf(Browser.class.getName()) + "#functionsToDestroy.";
    static final String ABOUT_BLANK = "about:blank";
    private String url;
    private String html;
    private boolean urlChanged;
    private String executeScript;
    private Boolean executeResult;
    private boolean executePending;
    private Object evaluateResult;
    private BrowserCallback browserCallback;
    private transient IBrowserAdapter browserAdapter;
    private final List<BrowserFunction> functions;

    public Browser(Composite parent, int style) {
        super(parent, style);
        if ((style & 0x18000) != 0) {
            throw new SWTError(2, "Unsupported Browser type");
        }
        this.html = "";
        this.url = "";
        this.functions = new ArrayList<BrowserFunction>();
        this.addDisposeListener(new BrowserDisposeListener());
    }

    public boolean setUrl(String url) {
        boolean result;
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        if (result = this.sendLocationChangingEvent(url)) {
            this.url = url;
            this.urlChanged = true;
            this.html = "";
            this.sendLocationChangedEvent(url);
            this.sendProgressChangedEvent();
        }
        return result;
    }

    public String getUrl() {
        this.checkWidget();
        return this.url;
    }

    public boolean setText(String html) {
        boolean result;
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        if (result = this.sendLocationChangingEvent(ABOUT_BLANK)) {
            this.html = html;
            this.url = "";
            this.urlChanged = true;
            this.sendLocationChangedEvent(ABOUT_BLANK);
            this.sendProgressChangedEvent();
        }
        return result;
    }

    public boolean execute(String script) {
        Browser.checkOperationMode();
        this.checkWidget();
        if (script == null) {
            SWT.error(4);
        }
        if (this.executeScript != null) {
            throw new IllegalStateException("Another script is already pending");
        }
        this.executeScript = script;
        this.executeResult = null;
        while (this.executeResult == null) {
            Display display = this.getDisplay();
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.executeScript = null;
        this.executePending = false;
        return this.executeResult;
    }

    public Object evaluate(String script) throws SWTException {
        boolean success;
        Browser.checkOperationMode();
        if (script == null) {
            SWT.error(4);
        }
        if (!(success = this.execute(Browser.prepareScript(script)))) {
            throw Browser.createException();
        }
        return this.evaluateResult;
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedBrowserListener browserListener = new TypedBrowserListener(listener);
        this.addListener(5012, browserListener);
        this.addListener(5011, browserListener);
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        this.removeListener(5012, listener);
        this.removeListener(5011, listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedBrowserListener browserListener = new TypedBrowserListener(listener);
        this.addListener(5021, browserListener);
        this.addListener(5022, browserListener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        this.removeListener(5021, listener);
        this.removeListener(5022, listener);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IBrowserAdapter.class) {
            if (this.browserAdapter == null) {
                this.browserAdapter = new BrowserAdapter();
            }
            return (T)this.browserAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)BrowserLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    public Object getWebBrowser() {
        this.checkWidget();
        return null;
    }

    private BrowserFunction[] getBrowserFunctions() {
        return this.functions.toArray(new BrowserFunction[this.functions.size()]);
    }

    void createFunction(BrowserFunction function) {
        boolean removed = false;
        int i = 0;
        while (!removed && i < this.functions.size()) {
            BrowserFunction current = this.functions.get(i);
            if (current.name.equals(function.name)) {
                this.functions.remove(current);
                removed = true;
            }
            ++i;
        }
        this.functions.add(function);
        if (!removed) {
            this.updateBrowserFunctions(function.getName(), true);
        }
    }

    void destroyFunction(BrowserFunction function) {
        this.functions.remove(function);
        this.updateBrowserFunctions(function.getName(), false);
    }

    private void updateBrowserFunctions(String function, boolean create) {
        String[] newList;
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        String id = WidgetUtil.getId(this);
        String key = create ? String.valueOf(FUNCTIONS_TO_CREATE) + id : String.valueOf(FUNCTIONS_TO_DESTROY) + id;
        String[] funcList = (String[])serviceStore.getAttribute(key);
        if (funcList == null) {
            newList = new String[]{function};
        } else {
            newList = new String[funcList.length + 1];
            System.arraycopy(funcList, 0, newList, 0, funcList.length);
            newList[funcList.length] = function;
        }
        serviceStore.setAttribute(key, newList);
    }

    @Override
    protected void checkWidget() {
        super.checkWidget();
    }

    private static void checkOperationMode() {
        if (ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle() instanceof SimpleLifeCycle) {
            throw new UnsupportedOperationException("Method not supported in JEE_COMPATIBILITY mode.");
        }
    }

    private void onDispose() {
        this.executeResult = Boolean.FALSE;
        this.evaluateResult = null;
        this.executeScript = null;
        this.executePending = false;
    }

    private boolean sendLocationChangingEvent(String location) {
        Event event = new Event();
        event.text = location;
        this.notifyListeners(5011, event);
        return event.doit;
    }

    private void sendLocationChangedEvent(String location) {
        Event event = new Event();
        event.text = location;
        event.detail = 128;
        this.notifyListeners(5012, event);
    }

    private void sendProgressChangedEvent() {
        this.notifyListeners(5021, new Event());
    }

    private static String prepareScript(String script) {
        StringBuilder buffer = new StringBuilder("(function(){");
        buffer.append(script);
        buffer.append("})();");
        return buffer.toString();
    }

    private void setExecuteResult(final boolean success, final Object result) {
        ProcessActionRunner.add(new Runnable(){

            @Override
            public void run() {
                Browser.this.executeResult = success;
                Browser.this.evaluateResult = result;
                if (Browser.this.browserCallback != null) {
                    if (success) {
                        Browser.this.browserCallback.evaluationSucceeded(result);
                    } else {
                        Browser.this.browserCallback.evaluationFailed(Browser.createException());
                    }
                    Browser.this.browserCallback = null;
                    Browser.this.executeScript = null;
                    Browser.this.executePending = false;
                }
            }
        });
    }

    private void evaluateNonBlocking(String script, BrowserCallback browserCallback) {
        this.checkWidget();
        if (this.executeScript != null) {
            throw new IllegalStateException("Another script is already pending");
        }
        this.browserCallback = browserCallback;
        this.executeScript = Browser.prepareScript(script);
    }

    private static SWTException createException() {
        String errorString = "Failed to evaluate Javascript expression";
        return new SWTException(50, errorString);
    }

    private final class BrowserAdapter
    implements IBrowserAdapter {
        private BrowserAdapter() {
        }

        @Override
        public String getText() {
            return Browser.this.html;
        }

        @Override
        public String getExecuteScript() {
            return Browser.this.executeScript;
        }

        @Override
        public void setExecuteResult(boolean success, Object result) {
            Browser.this.setExecuteResult(success, result);
        }

        @Override
        public void setExecutePending(boolean executePending) {
            Browser.this.executePending = executePending;
        }

        @Override
        public boolean getExecutePending() {
            return Browser.this.executePending;
        }

        @Override
        public BrowserFunction[] getBrowserFunctions() {
            return Browser.this.getBrowserFunctions();
        }

        @Override
        public boolean hasUrlChanged() {
            return Browser.this.urlChanged;
        }

        @Override
        public void resetUrlChanged() {
            Browser.this.urlChanged = false;
        }

        @Override
        public void evaluateNonBlocking(String script, BrowserCallback browserCallback) {
            Browser.this.evaluateNonBlocking(script, browserCallback);
        }
    }

    private class BrowserDisposeListener
    implements DisposeListener {
        private BrowserDisposeListener() {
        }

        @Override
        public void widgetDisposed(DisposeEvent event) {
            Browser.this.onDispose();
        }
    }

    static class TypedBrowserListener
    extends TypedListener {
        TypedBrowserListener(SWTEventListener listener) {
            super(listener);
        }

        @Override
        public void handleEvent(Event event) {
            switch (event.type) {
                case 5011: {
                    LocationListener locationListener = (LocationListener)this.getEventListener();
                    LocationEvent locationEvent = new LocationEvent(event);
                    locationListener.changing(locationEvent);
                    event.doit = locationEvent.doit;
                    break;
                }
                case 5012: {
                    LocationListener locationListener = (LocationListener)this.getEventListener();
                    LocationEvent locationEvent = new LocationEvent(event);
                    locationListener.changed(locationEvent);
                    break;
                }
                case 5021: {
                    ProgressListener progressListener = (ProgressListener)this.getEventListener();
                    ProgressEvent progressEvent = new ProgressEvent(event);
                    progressListener.changed(progressEvent);
                    break;
                }
                case 5022: {
                    ProgressListener progressListener = (ProgressListener)this.getEventListener();
                    ProgressEvent progressEvent = new ProgressEvent(event);
                    progressListener.completed(progressEvent);
                }
            }
        }
    }
}

