/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ctabitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Widget;

public final class CTabItemLCA
extends WidgetLCA<CTabItem> {
    public static final CTabItemLCA INSTANCE = new CTabItemLCA();
    private static final String TYPE = "rwt.widgets.CTabItem";
    private static final String[] ALLOWED_STYLES = new String[]{"CLOSE"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_SHOWING = "showing";
    private static final String PROP_SHOW_CLOSE = "showClose";

    @Override
    public void preserveValues(CTabItem item) {
        WidgetLCAUtil.preserveToolTipText(item, item.getToolTipText());
        WidgetLCAUtil.preserveBounds(item, item.getBounds());
        WidgetLCAUtil.preserveFont(item, CTabItemLCA.getFont(item));
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXT, CTabItemLCA.getText(item));
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGE, CTabItemLCA.getImage(item));
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_SHOWING, item.isShowing());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_SHOW_CLOSE, item.getShowClose());
    }

    @Override
    public void readData(CTabItem item) {
    }

    @Override
    public void renderInitialization(CTabItem item) throws IOException {
        CTabFolder parent = item.getParent();
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(item, TYPE);
        remoteObject.set("parent", WidgetUtil.getId(parent));
        remoteObject.set("index", parent.indexOf(item));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(item, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(CTabItem item) throws IOException {
        WidgetLCAUtil.renderCustomVariant(item);
        WidgetLCAUtil.renderData(item);
        WidgetLCAUtil.renderToolTip(item, item.getToolTipText());
        WidgetLCAUtil.renderBounds(item, item.getBounds());
        WidgetLCAUtil.renderFont(item, CTabItemLCA.getFont(item));
        CTabItemLCA.renderText(item);
        CTabItemLCA.renderMnemonicIndex(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGE, CTabItemLCA.getImage(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_SHOWING, item.isShowing(), true);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_SHOW_CLOSE, item.getShowClose(), false);
    }

    private static void renderText(CTabItem item) {
        String newValue = CTabItemLCA.getText(item);
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            RemoteObjectFactory.getRemoteObject(item).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(CTabItem item) {
        int mnemonicIndex;
        String text = CTabItemLCA.getText(item);
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, text, "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            RemoteObjectFactory.getRemoteObject(item).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }

    private static String getText(CTabItem item) {
        return CTabItemLCA.getCTabFolderAdapter(item).getShortenedItemText(item);
    }

    private static Image getImage(CTabItem item) {
        return CTabItemLCA.getCTabFolderAdapter(item).showItemImage(item) ? item.getImage() : null;
    }

    private static Font getFont(CTabItem item) {
        return item.getAdapter(IWidgetFontAdapter.class).getUserFont();
    }

    private static ICTabFolderAdapter getCTabFolderAdapter(CTabItem item) {
        return item.getParent().getAdapter(ICTabFolderAdapter.class);
    }

    private CTabItemLCA() {
    }
}

