/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.swt.widgets.Display;

public class JeeProgressRunner {
    private Display display;
    private ServerPushSession serverPushSession;

    public JeeProgressRunner(Display display) {
        this.display = display;
        this.serverPushSession = new ServerPushSession();
    }

    public void run(IRunnableWithProgress operation, IProgressMonitor monitor, Runnable callback) {
        if (monitor != null) {
            monitor.setCanceled(false);
        }
        this.serverPushSession.start();
        new ProgressRunnerThread(operation, monitor, callback).start();
    }

    private static class AccumulatingProgressMonitor
    extends ProgressMonitorWrapper {
        private Display display;
        private Collector collector;
        private String currentTask = "";

        public AccumulatingProgressMonitor(IProgressMonitor monitor, Display display) {
            super(monitor);
            Assert.isNotNull((Object)display);
            this.display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginTask(final String name, final int totalWork) {
            AccumulatingProgressMonitor accumulatingProgressMonitor = this;
            synchronized (accumulatingProgressMonitor) {
                this.collector = null;
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AccumulatingProgressMonitor.this.currentTask = name;
                    AccumulatingProgressMonitor.this.getWrappedProgressMonitor().beginTask(name, totalWork);
                }
            });
        }

        private synchronized void clearCollector(Collector collectorToClear) {
            if (this.collector == collectorToClear) {
                this.collector = null;
            }
        }

        private void createCollector(String subTask, double work) {
            this.collector = new Collector(subTask, work, this.getWrappedProgressMonitor());
            this.display.asyncExec((Runnable)this.collector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            AccumulatingProgressMonitor accumulatingProgressMonitor = this;
            synchronized (accumulatingProgressMonitor) {
                this.collector = null;
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AccumulatingProgressMonitor.this.getWrappedProgressMonitor().done();
                }
            });
        }

        public synchronized void internalWorked(double work) {
            if (this.collector == null) {
                this.createCollector(null, work);
            } else {
                this.collector.worked(work);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTaskName(final String name) {
            AccumulatingProgressMonitor accumulatingProgressMonitor = this;
            synchronized (accumulatingProgressMonitor) {
                this.collector = null;
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AccumulatingProgressMonitor.this.currentTask = name;
                    AccumulatingProgressMonitor.this.getWrappedProgressMonitor().setTaskName(name);
                }
            });
        }

        public synchronized void subTask(String name) {
            if (this.collector == null) {
                this.createCollector(name, 0.0);
            } else {
                this.collector.subTask(name);
            }
        }

        public synchronized void worked(int work) {
            this.internalWorked(work);
        }

        public void clearBlocked() {
            final IProgressMonitor pm = this.getWrappedProgressMonitor();
            if (!(pm instanceof IProgressMonitorWithBlocking)) {
                return;
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((IProgressMonitorWithBlocking)pm).clearBlocked();
                    Dialog.getBlockedHandler().clearBlocked();
                }
            });
        }

        public void setBlocked(final IStatus reason) {
            final IProgressMonitor pm = this.getWrappedProgressMonitor();
            if (!(pm instanceof IProgressMonitorWithBlocking)) {
                return;
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((IProgressMonitorWithBlocking)pm).setBlocked(reason);
                    Dialog.getBlockedHandler().showBlocked(pm, reason, AccumulatingProgressMonitor.this.currentTask);
                }
            });
        }

        private class Collector
        implements Runnable {
            private String subTask;
            private double worked;
            private IProgressMonitor monitor;

            public Collector(String subTask, double work, IProgressMonitor monitor) {
                this.subTask = subTask;
                this.worked = work;
                this.monitor = monitor;
            }

            public void worked(double workedIncrement) {
                this.worked += workedIncrement;
            }

            public void subTask(String subTaskName) {
                this.subTask = subTaskName;
            }

            @Override
            public void run() {
                AccumulatingProgressMonitor.this.clearCollector(this);
                if (this.subTask != null) {
                    this.monitor.subTask(this.subTask);
                }
                if (this.worked > 0.0) {
                    this.monitor.internalWorked(this.worked);
                }
            }
        }
    }

    private class ProgressRunnerThread
    extends Thread {
        private IRunnableWithProgress runnable;
        private IProgressMonitor progressMonitor;
        private Thread callingThread;
        private Runnable callback;

        private ProgressRunnerThread(IRunnableWithProgress operation, IProgressMonitor monitor, Runnable callback) {
            super("ProgressRunner");
            Assert.isTrue((monitor != null && JeeProgressRunner.this.display != null ? 1 : 0) != 0);
            this.runnable = operation;
            this.progressMonitor = new AccumulatingProgressMonitor(monitor, JeeProgressRunner.this.display);
            this.callback = callback;
            this.callingThread = Thread.currentThread();
        }

        @Override
        public void run() {
            RWT.getUISession((Display)JeeProgressRunner.this.display).exec(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            if (ProgressRunnerThread.this.runnable != null) {
                                ProgressRunnerThread.this.runnable.run(ProgressRunnerThread.this.progressMonitor);
                            }
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        if (ProgressRunnerThread.this.runnable instanceof IThreadListener) {
                            ((IThreadListener)((Object)ProgressRunnerThread.this.runnable)).threadChange(ProgressRunnerThread.this.callingThread);
                        }
                        JeeProgressRunner.this.display.asyncExec(ProgressRunnerThread.this.callback);
                        JeeProgressRunner.this.serverPushSession.stop();
                    }
                }
            });
        }
    }
}

