/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.nebula.widget.grid.demo.examples;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NebulaGridExamplePage
implements IExamplePage {
    private static final int NO_DATA = Integer.MIN_VALUE;
    private static final String EURO = "\u20ac ";
    private static final String[] YEARS = new String[]{"2005", "2006", "2007", "2008", "2009"};
    private List<CompanyData> data;

    public void createControl(Composite parent) {
        this.initData();
        parent.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)true, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)parent, (String)"Profit and Loss Balance Sheet", (int)1);
        parent.setLayoutData((Object)ExampleUtil.createFillData());
        Grid grid = this.createGrid(parent);
        GridColumn category = NebulaGridExamplePage.createColumn(grid, null, "", 235, 0x1000000);
        category.setFooterText("Net income");
        GridColumnGroup group = this.createGridColumnGroup(grid, "Period ( Year Ended December 31 )", 0x1000000);
        int i = 0;
        while (i < YEARS.length) {
            this.createYearColumn(grid, group, YEARS[i]);
            ++i;
        }
        this.createTotalColumn(grid, group);
        this.createItems(grid);
        this.calcNetIncome(grid);
    }

    private void initData() {
        this.data = new ArrayList<CompanyData>();
        this.data.add(new CompanyData("Consolidated Statements of<br/>Incoming Data:", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE));
        this.data.add(new CompanyData("Revenues", 6138560, 10604917, 16593986, 21795550, 23650563));
        this.data.add(new CompanyData("Costs and expenses:", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE));
        this.data.add(new CompanyData("Costs of ravenues", 2577088, 4225027, 6649085, 8621506, 8844115));
        this.data.add(new CompanyData("Research and development", 599510, 1228589, 2119985, 2793192, 2843027));
        this.data.add(new CompanyData("Sales and marketing", 468152, 849518, 1461266, 1946244, 1983941));
        this.data.add(new CompanyData("General and administrative", 386532, 751787, 1279250, 1802639, 1667294));
        this.data.add(new CompanyData("Contribution to Google<br/>Foundation", 90000, 0, 0, 0, 0));
        this.data.add(new CompanyData("Total costs and expenses", 4121282, 7054921, 11509586, 15163581, 15338377));
        this.data.add(new CompanyData("Income from operations", 2017287, 3549996, 5084400, 6631969, 8312186));
        this.data.add(new CompanyData("Impairment of equity<br/>investments", 0, 0, 0, 1094757, 0));
        this.data.add(new CompanyData("Interest income and other, net", 124399, 461044, 589580, 316384, 69003));
        this.data.add(new CompanyData("Income before income taxes", 2141677, 4011040, 5673980, 5853596, 8381189));
        this.data.add(new CompanyData("Provision for income taxes", 676280, 933594, 1470260, 1626738, 1860741));
    }

    private Grid createGrid(Composite parent) {
        Grid grid = new Grid(parent, 2560);
        grid.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        GridData tableLayoutData = ExampleUtil.createFillData();
        tableLayoutData.verticalIndent = 10;
        grid.setLayoutData((Object)tableLayoutData);
        grid.setHeaderVisible(true);
        grid.setFooterVisible(true);
        grid.setLinesVisible(true);
        return grid;
    }

    private GridColumnGroup createGridColumnGroup(Grid grid, String name, int style) {
        GridColumnGroup group = new GridColumnGroup(grid, style);
        group.setHeaderFont(new Font((Device)group.getDisplay(), "Verdana", 14, 1));
        group.setText(name);
        return group;
    }

    private void createYearColumn(Grid grid, GridColumnGroup group, String text) {
        GridColumn column = NebulaGridExamplePage.createColumn(grid, group, text, 148, 131072);
        column.setSummary(false);
    }

    private void createTotalColumn(Grid grid, GridColumnGroup columnGroup) {
        GridColumn totalColumn = NebulaGridExamplePage.createColumn(grid, columnGroup, "Total (2005 - 2009)", 740, 131072);
        totalColumn.setDetail(false);
    }

    private static GridColumn createColumn(Grid grid, GridColumnGroup group, String name, int width, int style) {
        GridColumn column = group == null ? new GridColumn(grid, style) : new GridColumn(group, style);
        Font font = new Font((Device)column.getDisplay(), "Verdana", 12, 1);
        column.setHeaderFont(font);
        column.setFooterFont(font);
        column.setText(name);
        column.setWidth(width);
        return column;
    }

    private void createItems(Grid grid) {
        int i = 0;
        while (i < this.data.size()) {
            CompanyData current = this.data.get(i);
            GridItem item = i > 2 && i < 8 ? new GridItem(grid.getItem(2), 0) : new GridItem(grid, 0);
            if (current.name.indexOf("<br/>") != -1) {
                item.setHeight(44);
            }
            item.setText(current.name);
            int j = 0;
            while (j < current.amount.length) {
                String text = "";
                if (current.amount[j] != Integer.MIN_VALUE) {
                    text = this.format(current.amount[j]);
                }
                item.setText(j + 1, text);
                ++j;
            }
            item.setExpanded(true);
            ++i;
        }
    }

    private void calcNetIncome(Grid grid) {
        int i = 0;
        while (i < YEARS.length + 1) {
            CompanyData income = this.data.get(this.data.size() - 2);
            CompanyData taxes = this.data.get(this.data.size() - 1);
            int netIncome = income.amount[i] - taxes.amount[i];
            grid.getColumn(i + 1).setFooterText(this.format(netIncome));
            ++i;
        }
    }

    private String format(int amount) {
        NumberFormat formatter = NumberFormat.getInstance(RWT.getLocale());
        return amount == 0 ? "-" : EURO + formatter.format(amount);
    }

    static /* synthetic */ String[] access$0() {
        return YEARS;
    }

    private class CompanyData {
        public final String name;
        public final int[] amount = new int[NebulaGridExamplePage.access$0().length + 1];

        public CompanyData(String name, int ... amount) {
            this.name = name;
            int sum = 0;
            int i = 0;
            while (i < this.amount.length - 1) {
                this.amount[i] = amount[i];
                sum += amount[i];
                ++i;
            }
            this.amount[this.amount.length - 1] = sum;
        }
    }
}

