/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ClientFileLoader;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class RichTextEditor
extends Composite {
    private static final String RESOURCES_PATH = "resources/";
    private static final String REGISTER_PATH = "ckeditor/";
    private static final String[] RESOURCE_FILES = new String[]{"ckeditor.js", "config.js", "styles.js", "contents.css", "lang/id.js", "lang/en.js", "skins/moono/editor.css", "skins/moono/editor_ie.css", "skins/moono/editor_gecko.css", "skins/moono/dialog.css", "skins/moono/dialog_ie.css", "skins/moono/icons.png", "skins/moono/icons_hidpi.png", "skins/moono/images/arrow.png", "skins/moono/images/close.png", "skins/moono/images/lock-open.png", "skins/moono/images/lock.png", "skins/moono/images/refresh.png", "skins/moono/images/hidpi/close.png", "skins/moono/images/hidpi/lock-open.png", "skins/moono/images/hidpi/lock.png", "skins/moono/images/hidpi/refresh.png", "RichTextEditor.js", "RichTextEditorHandler.js"};
    private static final String REMOTE_TYPE = "rwt.widgets.RichTextEditor";
    private String text = "";
    private boolean editable = true;
    private final RemoteObject remoteObject;
    private final OperationHandler operationHandler = new AbstractOperationHandler(){

        public void handleSet(JsonObject properties) {
            JsonValue textValue = properties.get("text");
            if (textValue != null) {
                RichTextEditor.this.text = textValue.asString();
            }
        }
    };

    public RichTextEditor(Composite parent) {
        this(parent, null, 0);
    }

    public RichTextEditor(Composite parent, ToolbarConfiguration config) {
        this(parent, config, 0);
    }

    public RichTextEditor(Composite parent, int style) {
        this(parent, null, style);
    }

    public RichTextEditor(Composite parent, ToolbarConfiguration config, int style) {
        super(parent, style);
        RichTextEditor.registerResources();
        RichTextEditor.loadJavaScript();
        Connection connection = RWT.getUISession().getConnection();
        this.remoteObject = connection.createRemoteObject(REMOTE_TYPE);
        this.remoteObject.setHandler(this.operationHandler);
        this.remoteObject.set("parent", WidgetUtil.getId((Widget)this));
        this.remoteObject.set("config", RichTextEditor.getConfiguration(config));
    }

    private static void registerResources() {
        ResourceManager resourceManager = RWT.getResourceManager();
        boolean isRegistered = resourceManager.isRegistered(REGISTER_PATH + RESOURCE_FILES[0]);
        if (!isRegistered) {
            try {
                String[] stringArray = RESOURCE_FILES;
                int n = RESOURCE_FILES.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    RichTextEditor.register(resourceManager, fileName);
                    ++n2;
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to load resources", ioe);
            }
        }
    }

    private static void loadJavaScript() {
        ClientFileLoader loader = (ClientFileLoader)RWT.getClient().getService(ClientFileLoader.class);
        ResourceManager resourceManager = RWT.getResourceManager();
        loader.requireJs(resourceManager.getLocation("ckeditor/ckeditor.js"));
        loader.requireJs(resourceManager.getLocation("ckeditor/config.js"));
        loader.requireJs(resourceManager.getLocation("ckeditor/RichTextEditor.js"));
        loader.requireJs(resourceManager.getLocation("ckeditor/RichTextEditorHandler.js"));
    }

    private static void register(ResourceManager resourceManager, String fileName) throws IOException {
        ClassLoader classLoader = RichTextEditor.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(RESOURCES_PATH + fileName);){
            resourceManager.register(REGISTER_PATH + fileName, inputStream);
        }
    }

    private static JsonValue getConfiguration(ToolbarConfiguration config) {
        ToolbarConfiguration toolbarConfig = config == null ? new ToolbarConfiguration() : config;
        try {
            return JsonValue.readFrom((String)toolbarConfig.toString());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid toolbar configuration", ex);
        }
    }

    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Cannot change internal layout of RichTextEditor");
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.remoteObject.set("font", this.getCssFont());
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.remoteObject.destroy();
        }
        super.dispose();
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        this.text = text;
        this.remoteObject.set("text", text);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean isEditable() {
        this.checkWidget();
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        if (this.editable != editable) {
            this.editable = editable;
            this.remoteObject.set("editable", editable);
        }
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    private String getCssFont() {
        StringBuilder result = new StringBuilder();
        if (this.getFont() != null) {
            FontData data = this.getFont().getFontData()[0];
            result.append(data.getHeight());
            result.append("px ");
            result.append(data.getName());
        }
        return result.toString();
    }
}

