/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.gridkit;

import java.io.IOException;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.nebula.widgets.grid.internal.gridkit.GridOperationHandler;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.template.TemplateLCAUtil;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public class GridLCA
extends WidgetLCA<Grid> {
    public static final GridLCA INSTANCE = new GridLCA();
    private static final String TYPE = "rwt.widgets.Grid";
    private static final String[] ALLOWED_STYLES = new String[]{"SINGLE", "MULTI", "FULL_SELECTION", "VIRTUAL", "NO_FOCUS", "BORDER"};
    private static final String PROP_ITEM_COUNT = "itemCount";
    private static final String PROP_ITEM_HEIGHT = "itemHeight";
    private static final String PROP_ITEM_METRICS = "itemMetrics";
    private static final String PROP_COLUMN_COUNT = "columnCount";
    private static final String PROP_COLUMN_ORDER = "columnOrder";
    private static final String PROP_FIXED_COLUMNS = "fixedColumns";
    private static final String PROP_TREE_COLUMN = "treeColumn";
    private static final String PROP_HEADER_HEIGHT = "headerHeight";
    private static final String PROP_HEADER_VISIBLE = "headerVisible";
    private static final String PROP_FOOTER_HEIGHT = "footerHeight";
    private static final String PROP_FOOTER_VISIBLE = "footerVisible";
    private static final String PROP_LINES_VISIBLE = "linesVisible";
    private static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    private static final String PROP_FOCUS_ITEM = "focusItem";
    private static final String PROP_FOCUS_CELL = "focusCell";
    private static final String PROP_SCROLL_LEFT = "scrollLeft";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_CELL_SELECTION = "cellSelection";
    private static final String PROP_CELL_SELECTION_ENABLED = "cellSelectionEnabled";
    private static final String PROP_SELECTION_TYPE = "selectionType";
    private static final String PROP_AUTO_HEIGHT = "autoHeight";
    private static final String PROP_INDENTION_WIDTH = "indentionWidth";
    private static final String PROP_SORT_DIRECTION = "sortDirection";
    private static final String PROP_SORT_COLUMN = "sortColumn";
    private static final String PROP_SETDATA_LISTENER = "SetData";
    private static final String PROP_EXPAND_LISTENER = "Expand";
    private static final String PROP_COLLAPSE_LISTENER = "Collapse";
    private static final String PROP_ENABLE_CELL_TOOLTIP = "enableCellToolTip";
    private static final String PROP_CELL_TOOLTIP_TEXT = "cellToolTipText";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final int ZERO = 0;
    private static final String[] DEFAULT_SELECTION = new String[0];
    private static final String[] DEFAULT_COLUMN_ORDER = new String[0];
    private static final String DEFAULT_SORT_DIRECTION = "none";

    public void renderInitialization(Grid grid) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject((Widget)grid, (String)TYPE);
        remoteObject.setHandler((OperationHandler)new GridOperationHandler(grid));
        remoteObject.set("parent", WidgetUtil.getId((Widget)grid.getParent()));
        remoteObject.set("style", (JsonValue)JsonUtil.createJsonArray((String[])WidgetLCAUtil.getStyles((Widget)grid, (String[])ALLOWED_STYLES)));
        remoteObject.set("appearance", "grid");
        if (GridLCA.getFixedColumns(grid) >= 0) {
            remoteObject.set("splitContainer", true);
        }
        remoteObject.set(PROP_MARKUP_ENABLED, MarkupUtil.isMarkupEnabledFor((Widget)grid));
        TemplateLCAUtil.renderRowTemplate((Widget)grid);
        remoteObject.listen(PROP_SETDATA_LISTENER, GridLCA.isVirtual(grid));
        remoteObject.listen(PROP_EXPAND_LISTENER, true);
        remoteObject.listen(PROP_COLLAPSE_LISTENER, true);
    }

    public void preserveValues(Grid grid) {
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_ITEM_COUNT, (int)grid.getRootItemCount());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_ITEM_HEIGHT, (int)grid.getItemHeight());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_ITEM_METRICS, (Object)GridLCA.getItemMetrics(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_COLUMN_COUNT, (int)grid.getColumnCount());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_COLUMN_ORDER, (Object)GridLCA.getColumnOrder(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_FIXED_COLUMNS, (int)GridLCA.getFixedColumns(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_TREE_COLUMN, (int)GridLCA.getTreeColumn(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_HEADER_HEIGHT, (int)grid.getHeaderHeight());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_HEADER_VISIBLE, (boolean)grid.getHeaderVisible());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_FOOTER_HEIGHT, (int)grid.getFooterHeight());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_FOOTER_VISIBLE, (boolean)grid.getFooterVisible());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_LINES_VISIBLE, (boolean)grid.getLinesVisible());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_TOP_ITEM_INDEX, (int)GridLCA.getTopItemIndex(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_FOCUS_ITEM, (Object)((Object)grid.getFocusItem()));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_FOCUS_CELL, (int)GridLCA.getFocusCell(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_SCROLL_LEFT, (int)GridLCA.getScrollLeft(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_SELECTION_TYPE, (Object)GridLCA.getSelectionType(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_SELECTION, (Object)GridLCA.getSelection(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_AUTO_HEIGHT, (boolean)grid.isAutoHeight());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_INDENTION_WIDTH, (int)GridLCA.getIndentationWidth(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_SORT_DIRECTION, (Object)GridLCA.getSortDirection(grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_SORT_COLUMN, (Object)((Object)GridLCA.getSortColumn(grid)));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_ENABLE_CELL_TOOLTIP, (boolean)CellToolTipUtil.isEnabledFor((Widget)grid));
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_CELL_TOOLTIP_TEXT, null);
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_CELL_SELECTION_ENABLED, (boolean)grid.isCellSelectionEnabled());
        WidgetLCAUtil.preserveProperty((Widget)grid, (String)PROP_CELL_SELECTION, (Object)GridLCA.getCellSelection(grid));
    }

    public void renderChanges(Grid grid) throws IOException {
        ControlLCAUtil.renderChanges((Control)grid);
        WidgetLCAUtil.renderCustomVariant((Widget)grid);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_ITEM_COUNT, (int)grid.getRootItemCount(), (int)0);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_ITEM_HEIGHT, (int)grid.getItemHeight(), (int)0);
        GridLCA.renderItemMetrics(grid);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_COLUMN_COUNT, (int)grid.getColumnCount(), (int)0);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_COLUMN_ORDER, (String[])GridLCA.getColumnOrder(grid), (String[])DEFAULT_COLUMN_ORDER);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_FIXED_COLUMNS, (int)GridLCA.getFixedColumns(grid), (int)-1);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_TREE_COLUMN, (int)GridLCA.getTreeColumn(grid), (int)0);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_HEADER_HEIGHT, (int)grid.getHeaderHeight(), (int)0);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_HEADER_VISIBLE, (boolean)grid.getHeaderVisible(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_FOOTER_HEIGHT, (int)grid.getFooterHeight(), (int)0);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_FOOTER_VISIBLE, (boolean)grid.getFooterVisible(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_LINES_VISIBLE, (boolean)grid.getLinesVisible(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_TOP_ITEM_INDEX, (int)GridLCA.getTopItemIndex(grid), (int)0);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_FOCUS_ITEM, (Widget)grid.getFocusItem(), null);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_FOCUS_CELL, (int)GridLCA.getFocusCell(grid), (int)-1);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_SCROLL_LEFT, (int)GridLCA.getScrollLeft(grid), (int)0);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_SELECTION_TYPE, (String)GridLCA.getSelectionType(grid), (String)"SINGLE");
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_SELECTION, (String[])GridLCA.getSelection(grid), (String[])DEFAULT_SELECTION);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_AUTO_HEIGHT, (boolean)grid.isAutoHeight(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_INDENTION_WIDTH, (int)GridLCA.getIndentationWidth(grid), (int)0);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_SORT_DIRECTION, (String)GridLCA.getSortDirection(grid), (String)DEFAULT_SORT_DIRECTION);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_SORT_COLUMN, (Widget)GridLCA.getSortColumn(grid), null);
        WidgetLCAUtil.renderListenSelection((Widget)grid);
        WidgetLCAUtil.renderListenDefaultSelection((Widget)grid);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_ENABLE_CELL_TOOLTIP, (boolean)CellToolTipUtil.isEnabledFor((Widget)grid), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_CELL_TOOLTIP_TEXT, (String)GridLCA.getAndResetCellToolTipText(grid), null);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_CELL_SELECTION_ENABLED, (boolean)grid.isCellSelectionEnabled(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)grid, (String)PROP_CELL_SELECTION, (String[])GridLCA.getCellSelection(grid), (String[])DEFAULT_SELECTION);
    }

    public void doRedrawFake(Control control) {
        GridLCA.getGridAdapter((Grid)control).doRedraw();
    }

    private static String getAndResetCellToolTipText(Grid grid) {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter((Widget)grid);
        String toolTipText = adapter.getCellToolTipText();
        adapter.setCellToolTipText(null);
        return toolTipText;
    }

    private static boolean isVirtual(Grid grid) {
        return (grid.getStyle() & 0x10000000) != 0;
    }

    private static int getTreeColumn(Grid grid) {
        return GridLCA.getGridAdapter(grid).getTreeColumn();
    }

    private static int getTopItemIndex(Grid grid) {
        int result = 0;
        ScrollBar verticalBar = grid.getVerticalBar();
        if (verticalBar != null) {
            result = verticalBar.getSelection();
        }
        return result;
    }

    private static int getScrollLeft(Grid grid) {
        int result = 0;
        ScrollBar horizontalBar = grid.getHorizontalBar();
        if (horizontalBar != null) {
            result = horizontalBar.getSelection();
        }
        return result;
    }

    private static String getSelectionType(Grid grid) {
        return GridLCA.getGridAdapter(grid).getSelectionType() == 2 ? "MULTI" : "SINGLE";
    }

    private static String[] getSelection(Grid grid) {
        GridItem[] selection = grid.getSelection();
        String[] result = new String[selection.length];
        int i = 0;
        while (i < result.length) {
            result[i] = WidgetUtil.getId((Widget)selection[i]);
            ++i;
        }
        return result;
    }

    private static String[] getCellSelection(Grid grid) {
        Point[] selection = grid.getCellSelection();
        String[] result = new String[selection.length];
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(WidgetUtil.getId((Widget)grid.getItem(selection[i].y))) + "#" + selection[i].x;
            ++i;
        }
        return result;
    }

    private static int getIndentationWidth(Grid grid) {
        return GridLCA.getGridAdapter(grid).getIndentationWidth();
    }

    private static String getSortDirection(Grid grid) {
        String result = DEFAULT_SORT_DIRECTION;
        int i = 0;
        while (i < grid.getColumnCount() && result.equals(DEFAULT_SORT_DIRECTION)) {
            int sort = grid.getColumn(i).getSort();
            if (sort == 128) {
                result = "up";
            } else if (sort == 1024) {
                result = "down";
            }
            ++i;
        }
        return result;
    }

    private static GridColumn getSortColumn(Grid grid) {
        GridColumn result = null;
        int i = 0;
        while (i < grid.getColumnCount() && result == null) {
            GridColumn column = grid.getColumn(i);
            if (column.getSort() != 0) {
                result = column;
            }
            ++i;
        }
        return result;
    }

    private static String[] getColumnOrder(Grid grid) {
        int[] order = grid.getColumnOrder();
        String[] result = new String[order.length];
        int i = 0;
        while (i < result.length) {
            result[i] = WidgetUtil.getId((Widget)grid.getColumn(order[i]));
            ++i;
        }
        return result;
    }

    private static int getFixedColumns(Grid grid) {
        return GridLCA.getGridAdapter(grid).getFixedColumns();
    }

    private static int getFocusCell(Grid grid) {
        GridColumn focusColumn = grid.getFocusColumn();
        return focusColumn == null ? -1 : grid.indexOf(focusColumn);
    }

    private static void renderItemMetrics(Grid grid) {
        ItemMetrics[] itemMetrics = GridLCA.getItemMetrics(grid);
        if (WidgetLCAUtil.hasChanged((Widget)grid, (String)PROP_ITEM_METRICS, (Object)itemMetrics)) {
            JsonArray metrics = new JsonArray();
            int i = 0;
            while (i < itemMetrics.length) {
                metrics.add((JsonValue)new JsonArray().add(i).add(itemMetrics[i].left).add(itemMetrics[i].width).add(itemMetrics[i].imageLeft).add(itemMetrics[i].imageWidth).add(itemMetrics[i].textLeft).add(itemMetrics[i].textWidth).add(itemMetrics[i].checkLeft).add(itemMetrics[i].checkWidth));
                ++i;
            }
            RemoteObjectFactory.getRemoteObject((Widget)grid).set(PROP_ITEM_METRICS, (JsonValue)metrics);
        }
    }

    static ItemMetrics[] getItemMetrics(Grid grid) {
        int columnCount = grid.getColumnCount();
        ItemMetrics[] result = new ItemMetrics[columnCount];
        IGridAdapter adapter = GridLCA.getGridAdapter(grid);
        int i = 0;
        while (i < columnCount) {
            result[i] = new ItemMetrics();
            result[i].left = adapter.getCellLeft(i);
            result[i].width = adapter.getCellWidth(i);
            result[i].checkLeft = result[i].left + adapter.getCheckBoxOffset(i);
            result[i].checkWidth = adapter.getCheckBoxWidth(i);
            result[i].imageLeft = result[i].left + adapter.getImageOffset(i);
            result[i].imageWidth = adapter.getImageWidth(i);
            result[i].textLeft = result[i].left + adapter.getTextOffset(i);
            result[i].textWidth = adapter.getTextWidth(i);
            ++i;
        }
        return result;
    }

    private static IGridAdapter getGridAdapter(Grid grid) {
        return grid.getAdapter(IGridAdapter.class);
    }

    static final class ItemMetrics {
        int left;
        int width;
        int checkLeft;
        int checkWidth;
        int imageLeft;
        int imageWidth;
        int textLeft;
        int textWidth;

        ItemMetrics() {
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof ItemMetrics) {
                ItemMetrics other = (ItemMetrics)obj;
                result = other.left == this.left && other.width == this.width && other.checkLeft == this.checkLeft && other.checkWidth == this.checkWidth && other.imageLeft == this.imageLeft && other.imageWidth == this.imageWidth && other.textLeft == this.textLeft && other.textWidth == this.textWidth;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "ItemMetrics#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

