/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewMenu
extends ContributionItem {
    public static final String SHOW_VIEW_ID = "org.eclipse.ui.views.showView";
    public static final String VIEW_ID_PARM = "org.eclipse.ui.views.showView.viewId";
    private IWorkbenchWindow window;
    private final String NO_TARGETS_MSG;
    private Comparator actionComparator;
    private Action showDlgAction;
    private Map actions;
    private Map openedViews;
    protected boolean dirty;
    private IMenuListener menuListener;
    private boolean makeFast;
    private static Collator collator;

    public ShowViewMenu(IWorkbenchWindow window, String id) {
        this(window, id, false);
    }

    public ShowViewMenu(IWorkbenchWindow window, String id, boolean makeFast) {
        super(id);
        this.NO_TARGETS_MSG = WorkbenchMessages.get().Workbench_showInNoTargets;
        this.actionComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (collator == null) {
                    ShowViewMenu.collator = Collator.getInstance();
                }
                CommandContributionItemParameter a1 = (CommandContributionItemParameter)o1;
                CommandContributionItemParameter a2 = (CommandContributionItemParameter)o2;
                return collator.compare(a1.label, a2.label);
            }
        };
        this.actions = new HashMap(21);
        this.openedViews = new HashMap();
        this.dirty = true;
        this.menuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.markDirty();
                ShowViewMenu.this.dirty = true;
            }
        };
        this.window = window;
        this.makeFast = makeFast;
        final IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
        final ParameterizedCommand cmd = this.getCommand(commandService, makeFast);
        this.showDlgAction = new Action(WorkbenchMessages.get().ShowView_title){

            public void run() {
                try {
                    handlerService.executeCommand(cmd, null);
                }
                catch (ExecutionException executionException) {
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {}
            }
        };
        window.getWorkbench().getHelpSystem().setHelp((IAction)this.showDlgAction, "org.eclipse.rap.ui.show_view_other_action_context");
        if (window instanceof WorkbenchWindow) {
            ((WorkbenchWindow)window).addSubmenu(1);
        }
        this.showDlgAction.setActionDefinitionId(SHOW_VIEW_ID);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    private void fillMenu(IMenuManager innerMgr) {
        Object item;
        innerMgr.removeAll();
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            return;
        }
        List viewIds = Arrays.asList(page.getShowViewShortcuts());
        viewIds = this.addOpenedViews(page, viewIds);
        ArrayList<CommandContributionItemParameter> actions = new ArrayList<CommandContributionItemParameter>(viewIds.size());
        for (String id : viewIds) {
            if (id.equals("org.eclipse.ui.internal.introview") || (item = this.getItem(id)) == null) continue;
            actions.add((CommandContributionItemParameter)item);
        }
        Collections.sort(actions, this.actionComparator);
        for (CommandContributionItemParameter ccip : actions) {
            if (WorkbenchActivityHelper.filterItem(ccip)) continue;
            item = new CommandContributionItem(ccip);
            innerMgr.add((IContributionItem)item);
        }
        if (!innerMgr.isEmpty()) {
            innerMgr.add((IContributionItem)new Separator());
        }
        innerMgr.add((IAction)this.showDlgAction);
    }

    private CommandContributionItemParameter getItem(String viewId) {
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewDescriptor desc = reg.find(viewId);
        if (desc == null) {
            return null;
        }
        String label = desc.getLabel();
        PluginCCIP parms = new PluginCCIP(desc, this.window, viewId, SHOW_VIEW_ID, 8);
        parms.label = label;
        parms.icon = desc.getImageDescriptor();
        parms.parameters = new HashMap();
        parms.parameters.put(VIEW_ID_PARM, viewId);
        if (this.makeFast) {
            parms.parameters.put("org.eclipse.ui.views.showView.makeFast", "true");
        }
        return parms;
    }

    private List addOpenedViews(IWorkbenchPage page, List actions) {
        Object element;
        ArrayList views = this.getParts(page);
        ArrayList result = new ArrayList(views.size() + actions.size());
        int i = 0;
        while (i < actions.size()) {
            element = actions.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        i = 0;
        while (i < views.size()) {
            element = views.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private ArrayList getParts(IWorkbenchPage page) {
        ArrayList parts = (ArrayList)this.openedViews.get(page);
        if (parts == null) {
            parts = new ArrayList();
            this.openedViews.put(page, parts);
        }
        return parts;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        if (items.length == 0) {
            MenuItem item = new MenuItem(menu, 0, index++);
            item.setText(this.NO_TARGETS_MSG);
            item.setEnabled(false);
        } else {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
        this.dirty = false;
    }

    protected void removeAction(String viewId) {
        this.actions.remove(viewId);
    }

    private ParameterizedCommand getCommand(ICommandService commandService, boolean makeFast) {
        Command c = commandService.getCommand(SHOW_VIEW_ID);
        Parameterization[] parms = null;
        if (makeFast) {
            try {
                IParameter parmDef = c.getParameter("org.eclipse.ui.views.showView.makeFast");
                parms = new Parameterization[]{new Parameterization(parmDef, "true")};
            }
            catch (NotDefinedException notDefinedException) {}
        }
        return new ParameterizedCommand(c, parms);
    }

    static class PluginCCIP
    extends CommandContributionItemParameter
    implements IPluginContribution {
        private String localId;
        private String pluginId;

        public PluginCCIP(IViewDescriptor v, IServiceLocator serviceLocator, String id, String commandId, int style) {
            super(serviceLocator, id, commandId, style);
            this.localId = ((ViewDescriptor)v).getLocalId();
            this.pluginId = ((ViewDescriptor)v).getPluginId();
        }

        @Override
        public String getLocalId() {
            return this.localId;
        }

        @Override
        public String getPluginId() {
            return this.pluginId;
        }
    }
}

