/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.localization.LocaleProvider;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.internal.RWTProperties;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.ui.internal.SessionLocaleProvider;
import org.eclipse.rap.ui.internal.progress.JobManagerAdapter;
import org.eclipse.rap.ui.internal.servlet.HttpServiceTracker;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.JFaceUtil;
import org.eclipse.ui.internal.ProductInfo;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroRegistry;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.WorkbenchOperationSupport;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.wizards.ExportWizardRegistry;
import org.eclipse.ui.internal.wizards.ImportWizardRegistry;
import org.eclipse.ui.internal.wizards.NewWizardRegistry;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    private static final String PERSP_REGISTRY_INITIALIZED = PerspectiveRegistry.class + "#initialized";
    private static final String PROP_WORKBENCH_AUTOSTART = "org.eclipse.rap.workbenchAutostart";
    private static WorkbenchPlugin inst;
    private DecoratorManager decoratorManager;
    private BundleContext bundleContext;
    private Collection startingBundles = new HashSet();
    private ServiceRegistration localeProviderService;
    public static boolean DEBUG;
    public static String PI_WORKBENCH;
    public static char PREFERENCE_PAGE_CATEGORY_SEPARATOR;
    private SharedImages sharedImages;
    private ProductInfo productInfo = null;
    private WorkbenchOperationSupport operationSupport;
    private BundleListener bundleListener;
    private HttpServiceTracker httpServiceTracker;

    static {
        DEBUG = false;
        PI_WORKBENCH = "org.eclipse.rap.ui";
        PREFERENCE_PAGE_CATEGORY_SEPARATOR = (char)47;
    }

    public WorkbenchPlugin() {
        inst = this;
    }

    void reset() {
        if (this.decoratorManager != null) {
            this.decoratorManager.shutdown();
            this.decoratorManager = null;
        }
        ProgressManager.shutdownProgressManager();
        this.sharedImages = null;
        this.productInfo = null;
        if (this.operationSupport != null) {
            this.operationSupport.dispose();
            this.operationSupport = null;
        }
        DEBUG = false;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        try {
            if (BundleUtility.isActivated(element.getDeclaringExtension().getNamespace())) {
                return element.createExecutableExtension(classAttribute);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (CoreException core) {
            throw core;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, PI_WORKBENCH, 4, WorkbenchMessages.get().WorkbenchPlugin_extension, (Throwable)e));
        }
    }

    public static boolean hasExecutableExtension(IConfigurationElement element, String extensionName) {
        if (element.getAttribute(extensionName) != null) {
            return true;
        }
        String elementText = element.getValue();
        if (elementText != null && !elementText.equals("")) {
            return true;
        }
        IConfigurationElement[] children = element.getChildren(extensionName);
        return children.length == 1 && children[0].getAttribute("class") != null;
    }

    public static boolean isBundleLoadedForExecutableExtension(IConfigurationElement element, String extensionName) {
        Bundle bundle = WorkbenchPlugin.getBundleForExecutableExtension(element, extensionName);
        if (bundle == null) {
            return true;
        }
        return bundle.getState() == 32;
    }

    public static Bundle getBundleForExecutableExtension(IConfigurationElement element, String extensionName) {
        String prop = null;
        String contributorName = null;
        if (extensionName != null) {
            prop = element.getAttribute(extensionName);
        } else {
            prop = element.getValue();
            if (prop != null && (prop = prop.trim()).equals("")) {
                prop = null;
            }
        }
        if (prop == null) {
            IConfigurationElement[] exec = element.getChildren(extensionName);
            if (exec.length != 0) {
                contributorName = exec[0].getAttribute("plugin");
            }
        } else {
            int i = prop.indexOf(58);
            String executable = i != -1 ? prop.substring(0, i).trim() : prop;
            i = executable.indexOf(47);
            if (i != -1) {
                contributorName = executable.substring(0, i).trim();
            }
        }
        if (contributorName == null) {
            contributorName = element.getContributor().getName();
        }
        return Platform.getBundle(contributorName);
    }

    @Override
    protected ImageRegistry createImageRegistry() {
        return WorkbenchImages.getImageRegistry();
    }

    public ActionSetRegistry getActionSetRegistry() {
        return ActionSetRegistry.getInstance();
    }

    public static WorkbenchPlugin getDefault() {
        return inst;
    }

    public IEditorRegistry getEditorRegistry() {
        return EditorRegistry.getInstance();
    }

    public IElementFactory getElementFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "elementFactories");
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find element factory. Extension point: elementFactories not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (targetID.equals(strID)) {
                targetElement = configElements[j];
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find element factory: " + targetID);
            return null;
        }
        IElementFactory factory = null;
        try {
            factory = (IElementFactory)WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create element factory.", e.getStatus());
            factory = null;
        }
        return factory;
    }

    public AbstractPresentationFactory getPresentationFactory(String targetID) {
        Object o = this.createExtension("presentationFactories", "factory", targetID);
        if (o instanceof AbstractPresentationFactory) {
            return (AbstractPresentationFactory)o;
        }
        WorkbenchPlugin.log("Error creating presentation factory: " + targetID + " -- class is not an AbstractPresentationFactory");
        return null;
    }

    private Object createExtension(String extensionPointId, String elementName, String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", extensionPointId);
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find extension. Extension point: " + extensionPointId + " not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            String strID;
            IConfigurationElement element = elements[j];
            if ((elementName == null || elementName.equals(element.getName())) && targetID.equals(strID = element.getAttribute("id"))) {
                targetElement = element;
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find extension: " + targetID + " in extension point: " + extensionPointId);
            return null;
        }
        try {
            return WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create extension: " + targetID + " in extension point: " + extensionPointId + ", status: ", e.getStatus());
            return null;
        }
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        final PerspectiveRegistry perspRegistry = (PerspectiveRegistry)SingletonUtil.getSessionInstance(PerspectiveRegistry.class);
        UISession uiSession = RWT.getUISession();
        Boolean initialized = (Boolean)uiSession.getAttribute(PERSP_REGISTRY_INITIALIZED);
        if (initialized == null) {
            uiSession.setAttribute(PERSP_REGISTRY_INITIALIZED, (Object)Boolean.TRUE);
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    perspRegistry.load();
                }
            });
        }
        return perspRegistry;
    }

    public IWorkingSetManager getWorkingSetManager() {
        return WorkingSetManagerStore.getInstance().getWorkingSetManager(this.bundleContext);
    }

    public WorkingSetRegistry getWorkingSetRegistry() {
        return WorkingSetRegistryStore.getInstance().getWorkingSetRegistry();
    }

    public IIntroRegistry getIntroRegistry() {
        return (IIntroRegistry)SingletonUtil.getSessionInstance(IntroRegistry.class);
    }

    public IWorkbenchOperationSupport getOperationSupport() {
        if (this.operationSupport == null) {
            this.operationSupport = new WorkbenchOperationSupport();
        }
        return this.operationSupport;
    }

    public PreferenceManager getPreferenceManager() {
        return PreferenceManagerStore.getInstance().getPreferenceManager();
    }

    public ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = new SharedImages();
        }
        return this.sharedImages;
    }

    public IThemeRegistry getThemeRegistry() {
        return ThemeRegistryStore.getInstance().getThemeRegistry();
    }

    public IViewRegistry getViewRegistry() {
        return ViewRegistry.getInstance();
    }

    @Override
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Override
    protected void initializeDefaultPreferences(IPreferenceStore store) {
    }

    public static void log(String message) {
        WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
    }

    public static void log(Throwable t) {
        WorkbenchPlugin.getDefault().getLog().log(WorkbenchPlugin.getStatus(t));
    }

    public static IStatus getStatus(Throwable t) {
        String message = StatusUtil.getLocalizedMessage(t);
        return WorkbenchPlugin.newError(message, t);
    }

    public static IStatus newError(String message, Throwable t) {
        String pluginId = "org.eclipse.ui.workbench";
        int errorCode = 0;
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            pluginId = ce.getStatus().getPlugin();
            errorCode = ce.getStatus().getCode();
        }
        return new Status(4, pluginId, errorCode, message, StatusUtil.getCause(t));
    }

    public static void log(String message, Throwable t) {
        IStatus status = StatusUtil.newStatus(4, message, t);
        WorkbenchPlugin.log(message, status);
    }

    public static void log(Class clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format("Exception in {0}.{1}: {2}", clazz.getName(), methodName, t);
        WorkbenchPlugin.log(msg, t);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        }
        WorkbenchPlugin.getDefault().getLog().log(status);
    }

    public static void log(IStatus status) {
        WorkbenchPlugin.getDefault().getLog().log(status);
    }

    public DecoratorManager getDecoratorManager() {
        return DecoratorManagerStore.getInstance().getDecoratorManager();
    }

    public HttpServiceTracker getHttpServiceTracker() {
        return this.httpServiceTracker;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        context.addBundleListener(this.getBundleListener());
        super.start(context);
        this.bundleContext = context;
        Window.setDefaultOrientation((int)this.getDefaultOrientation());
        JFaceUtil.initializeJFace();
        SessionLocaleProvider localeProvider = new SessionLocaleProvider();
        String localeProviderName = LocaleProvider.class.getName();
        this.localeProviderService = context.registerService(localeProviderName, (Object)localeProvider, new Hashtable());
        JobManagerAdapter.getInstance();
        if (RWTProperties.getBooleanProperty((String)PROP_WORKBENCH_AUTOSTART, (boolean)true)) {
            this.httpServiceTracker = new HttpServiceTracker(context);
            this.httpServiceTracker.open();
        }
    }

    private int getDefaultOrientation() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int orientation = this.getCommandLineOrientation(commandLineArgs);
        if (orientation != 0) {
            return orientation;
        }
        orientation = this.getSystemPropertyOrientation();
        if (orientation != 0) {
            return orientation;
        }
        return 0;
    }

    private int getSystemPropertyOrientation() {
        return 0;
    }

    private int getCommandLineOrientation(String[] commandLineArgs) {
        return 0;
    }

    public Bundle[] getBundles() {
        return this.bundleContext == null ? new Bundle[]{} : this.bundleContext.getBundles();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getAppName() {
        return this.getProductInfo().getAppName();
    }

    public String getAppVersion() {
        return this.getProductInfo().getAppVersion();
    }

    public String getProductName() {
        return this.getProductInfo().getProductName();
    }

    public ImageDescriptor[] getWindowImages() {
        return this.getProductInfo().getWindowImages();
    }

    private ProductInfo getProductInfo() {
        if (this.productInfo == null) {
            this.productInfo = new ProductInfo(Platform.getProduct());
        }
        return this.productInfo;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        if (this.bundleListener != null) {
            context.removeBundleListener(this.bundleListener);
            this.bundleListener = null;
        }
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        this.localeProviderService.unregister();
        super.stop(context);
    }

    public IWizardRegistry getNewWizardRegistry() {
        return NewWizardRegistry.getInstance();
    }

    public IWizardRegistry getImportWizardRegistry() {
        return ImportWizardRegistry.getInstance();
    }

    public IWizardRegistry getExportWizardRegistry() {
        return ExportWizardRegistry.getInstance();
    }

    public IPath getDataLocation() {
        try {
            return this.getStateLocation();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    void addBundleListener(BundleListener bundleListener) {
        this.bundleContext.addBundleListener(bundleListener);
    }

    void removeBundleListener(BundleListener bundleListener) {
        this.bundleContext.removeBundleListener(bundleListener);
    }

    int getBundleCount() {
        return this.bundleContext.getBundles().length;
    }

    OutputStream getSplashStream() {
        ServiceReference[] ref;
        try {
            ref = this.bundleContext.getServiceReferences(OutputStream.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        if (ref == null) {
            return null;
        }
        int i = 0;
        while (i < ref.length) {
            String name = (String)ref[i].getProperty("name");
            if (name != null && name.equals("splashstream")) {
                Object result = this.bundleContext.getService(ref[i]);
                this.bundleContext.ungetService(ref[i]);
                return (OutputStream)result;
            }
            ++i;
        }
        return null;
    }

    private BundleListener getBundleListener() {
        if (this.bundleListener == null) {
            this.bundleListener = new SynchronousBundleListener(){

                public void bundleChanged(BundleEvent event) {
                    WorkbenchPlugin.this.bundleChanged(event);
                }
            };
        }
        return this.bundleListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bundleChanged(BundleEvent event) {
        int eventType = event.getType();
        Collection collection = this.startingBundles;
        synchronized (collection) {
            switch (eventType) {
                case 128: {
                    this.startingBundles.add(event.getBundle());
                    break;
                }
                case 2: 
                case 4: {
                    this.startingBundles.remove(event.getBundle());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarting(Bundle bundle) {
        Collection collection = this.startingBundles;
        synchronized (collection) {
            return this.startingBundles.contains(bundle);
        }
    }

    public static boolean isSplashHandleSpecified() {
        return false;
    }

    private static final class DecoratorManagerStore {
        private final DecoratorManager decoratorManager = new DecoratorManager();

        private DecoratorManagerStore() {
        }

        public static DecoratorManagerStore getInstance() {
            return (DecoratorManagerStore)SingletonUtil.getSessionInstance(DecoratorManagerStore.class);
        }

        public DecoratorManager getDecoratorManager() {
            return this.decoratorManager;
        }
    }

    private static final class PreferenceManagerStore {
        private final WorkbenchPreferenceManager preferenceManager = new WorkbenchPreferenceManager(PREFERENCE_PAGE_CATEGORY_SEPARATOR);

        static PreferenceManagerStore getInstance() {
            return (PreferenceManagerStore)SingletonUtil.getSessionInstance(PreferenceManagerStore.class);
        }

        public PreferenceManagerStore() {
            PreferencePageRegistryReader registryReader = new PreferencePageRegistryReader(PlatformUI.getWorkbench());
            registryReader.loadFromRegistry(Platform.getExtensionRegistry());
            this.preferenceManager.addPages(registryReader.getTopLevelNodes());
        }

        public PreferenceManager getPreferenceManager() {
            return this.preferenceManager;
        }
    }

    private static final class ThemeRegistryStore {
        private final ThemeRegistry themeRegistry = new ThemeRegistry();

        static ThemeRegistryStore getInstance() {
            return (ThemeRegistryStore)SingletonUtil.getSessionInstance(ThemeRegistryStore.class);
        }

        public ThemeRegistryStore() {
            ThemeRegistryReader reader = new ThemeRegistryReader();
            reader.readThemes(Platform.getExtensionRegistry(), this.themeRegistry);
        }

        public IThemeRegistry getThemeRegistry() {
            return this.themeRegistry;
        }
    }

    private static final class WorkingSetManagerStore {
        private WorkingSetManager workingSetManager;

        private WorkingSetManagerStore() {
        }

        static WorkingSetManagerStore getInstance() {
            return (WorkingSetManagerStore)SingletonUtil.getSessionInstance(WorkingSetManagerStore.class);
        }

        public IWorkingSetManager getWorkingSetManager(BundleContext context) {
            if (this.workingSetManager == null) {
                this.workingSetManager = new WorkingSetManager(context);
                this.workingSetManager.restoreState();
            }
            return this.workingSetManager;
        }
    }

    private static final class WorkingSetRegistryStore {
        private WorkingSetRegistry workingSetRegistry = new WorkingSetRegistry();

        static WorkingSetRegistryStore getInstance() {
            return (WorkingSetRegistryStore)SingletonUtil.getSessionInstance(WorkingSetRegistryStore.class);
        }

        public WorkingSetRegistryStore() {
            this.workingSetRegistry.load();
        }

        public WorkingSetRegistry getWorkingSetRegistry() {
            return this.workingSetRegistry;
        }
    }
}

