/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class DefaultDetailsArea
extends AbstractStatusAreaProvider {
    private static final int MINIMUM_HEIGHT = 100;
    private int mask;
    private static final int NESTING_INDENT = 15;
    private Text text;
    private boolean handleOkStatuses;
    private Map dialogState;
    private MenuItem copyAction;

    public DefaultDetailsArea(Map dialogState) {
        this.dialogState = dialogState;
        this.handleOkStatuses = (Boolean)dialogState.get(IStatusDialogConstants.HANDLE_OK_STATUSES);
        this.mask = (Integer)dialogState.get(IStatusDialogConstants.MASK);
    }

    @Override
    public Control createSupportArea(Composite parent, StatusAdapter statusAdapter) {
        Composite area = this.createArea(parent);
        this.setStatusAdapter(statusAdapter);
        return area;
    }

    protected Composite createArea(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text = new Text(parent, 2890);
        this.text.setBackground(parent.getDisplay().getSystemColor(1));
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 250;
        gd.minimumHeight = 100;
        this.text.setLayoutData((Object)gd);
        IBindingService cfr_ignored_0 = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        this.text.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DefaultDetailsArea.this.text.getSelectionText().length() == 0) {
                    if (DefaultDetailsArea.this.copyAction != null && !DefaultDetailsArea.this.copyAction.isDisposed()) {
                        DefaultDetailsArea.this.copyAction.setEnabled(false);
                    }
                } else if (DefaultDetailsArea.this.copyAction != null && !DefaultDetailsArea.this.copyAction.isDisposed()) {
                    DefaultDetailsArea.this.copyAction.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.createDNDSource();
        this.createCopyAction(parent);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void setStatusAdapter(StatusAdapter adapter) {
        Long timestamp;
        this.populateList(this.text, adapter.getStatus(), 0, new int[1]);
        if (!this.isMulti() && (timestamp = (Long)adapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY)) != null) {
            String date = DateFormat.getDateTimeInstance(1, 1).format(new Date(timestamp));
            this.text.append(NLS.bind((String)ProgressMessages.get().JobInfo_Error, (Object[])new Object[]{"", date}));
        }
        int delimiterLength = this.getLineSeparator().length();
        String newText = this.text.getText();
        newText = newText.substring(0, newText.length() - delimiterLength);
        this.text.setText(newText);
        this.adjustHeight(this.text);
    }

    private void adjustHeight(Text text) {
        int lineCount = 2;
        int lineHeight = text.getLineHeight();
        int startPos = text.getLocation().y;
        Composite c = text.getParent();
        while (c != null) {
            startPos += c.getLocation().y;
            c = c.getParent();
        }
        int screenHeight = text.getShell().getMonitor().getBounds().height;
        int availableScreenForText = screenHeight - (startPos += text.getShell().getBounds().height);
        if (availableScreenForText <= 100) {
            return;
        }
        int desiredHeight = lineCount * lineHeight;
        if ((double)desiredHeight > (double)availableScreenForText * 0.75) {
            ((GridData)text.getLayoutData()).heightHint = (int)((double)availableScreenForText * 0.75);
        }
    }

    private void createDNDSource() {
        DragSource ds = new DragSource((Control)this.text, 1);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DefaultDetailsArea.this.text.getSelectionText();
                }
            }

            public void dragStart(DragSourceEvent event) {
            }
        });
    }

    private void createCopyAction(Composite parent) {
    }

    private void populateList(Text text, IStatus status, int nesting, int[] lineNumber) {
        if (!(status.matches(this.mask) || this.handleOkStatuses && status.isOK())) {
            return;
        }
        int n = lineNumber[0];
        lineNumber[0] = n + 1;
        this.appendNewLine(text, status.getMessage(), nesting, n);
        Throwable t = status.getException();
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            this.populateList(text, ce.getStatus(), nesting + 1, lineNumber);
        } else if (t != null) {
            String message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            int n2 = lineNumber[0];
            lineNumber[0] = n2 + 1;
            this.appendNewLine(text, message, nesting, n2);
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            this.populateList(text, children[i], nesting + 1, lineNumber);
            ++i;
        }
    }

    private String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    private void appendNewLine(Text text, String line, int indentLevel, int lineNumber) {
        text.append(String.valueOf(line) + this.getLineSeparator());
        if (lineNumber != 0) {
            // empty if block
        }
    }

    private void copyToClipboard() {
    }

    private boolean isMulti() {
        return ((Collection)this.dialogState.get(IStatusDialogConstants.STATUS_ADAPTERS)).size() != 1;
    }
}

