/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.ICountable;
import org.eclipse.core.expressions.IIterable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SelectionAdapterFactory
implements IAdapterFactory {
    private static final ICountable ICOUNT_0 = new ICountable(){

        public int count() {
            return 0;
        }
    };
    private static final ICountable ICOUNT_1 = new ICountable(){

        public int count() {
            return 1;
        }
    };
    private static final IIterable ITERATE_EMPTY = new IIterable(){

        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }
    };
    private static final Class[] CLASSES = new Class[]{IIterable.class, ICountable.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof ISelection) {
            if (adapterType == IIterable.class) {
                return this.iterable((ISelection)adaptableObject);
            }
            if (adapterType == ICountable.class) {
                return this.countable((ISelection)adaptableObject);
            }
        }
        return null;
    }

    private Object iterable(final ISelection sel) {
        if (sel.isEmpty()) {
            return ITERATE_EMPTY;
        }
        if (sel instanceof IStructuredSelection) {
            return new IIterable(){

                public Iterator iterator() {
                    return ((IStructuredSelection)sel).iterator();
                }
            };
        }
        final List<Object> list = Arrays.asList(sel);
        return new IIterable(){

            public Iterator iterator() {
                return list.iterator();
            }
        };
    }

    private Object countable(ISelection sel) {
        if (sel.isEmpty()) {
            return ICOUNT_0;
        }
        if (sel instanceof IStructuredSelection) {
            final IStructuredSelection ss = (IStructuredSelection)sel;
            return new ICountable(){

                public int count() {
                    return ss.size();
                }
            };
        }
        return ICOUNT_1;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

