/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.theme.CssValue;

public class CssFloat
implements CssValue {
    private static final CssFloat ZERO = new CssFloat(0.0f);
    private static final CssFloat ONE = new CssFloat(1.0f);
    public final float value;

    private CssFloat(float value) {
        this.value = value;
    }

    public static CssFloat create(float value) {
        if (value == 0.0f) {
            return ZERO;
        }
        if (value == 1.0f) {
            return ONE;
        }
        return new CssFloat(value);
    }

    public static CssFloat valueOf(String input) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        return CssFloat.create(Float.parseFloat(input));
    }

    @Override
    public String toDefaultString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssFloat) {
            CssFloat other = (CssFloat)object;
            return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return "CssFloat{ " + String.valueOf(this.value) + " }";
    }
}

