/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rap.rwt.internal.theme.AppearancesUtil;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapterManager;
import org.eclipse.rap.rwt.internal.theme.ThemeDefinitionReader;
import org.eclipse.rap.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rap.rwt.internal.theme.ThemeableWidgetHolder;
import org.eclipse.rap.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rap.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.rwt.widgets.DropDown;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ThemeManager {
    public static final String FALLBACK_THEME_ID = "org.eclipse.rap.rwt.theme.Fallback";
    private static final String FALLBACK_THEME_NAME = "RAP Fallback Theme";
    private static final String DEFAULT_THEME_NAME = "RAP Default Theme";
    public static final ResourceLoader STANDARD_RESOURCE_LOADER = new ResourceLoader(){
        ClassLoader classLoader = this.getClass().getClassLoader();

        @Override
        public InputStream getResourceAsStream(String resourceName) throws IOException {
            return this.classLoader.getResourceAsStream(resourceName);
        }
    };
    private static final String[] THEMEABLE_WIDGETS = new String[]{Widget.class.getName(), Control.class.getName(), Composite.class.getName(), Button.class.getName(), Combo.class.getName(), CoolBar.class.getName(), CTabFolder.class.getName(), Group.class.getName(), Label.class.getName(), Link.class.getName(), org.eclipse.swt.widgets.List.class.getName(), Menu.class.getName(), ProgressBar.class.getName(), Shell.class.getName(), Spinner.class.getName(), TabFolder.class.getName(), Table.class.getName(), Text.class.getName(), ToolBar.class.getName(), Tree.class.getName(), Scale.class.getName(), DateTime.class.getName(), ExpandBar.class.getName(), Sash.class.getName(), Slider.class.getName(), ToolTip.class.getName(), CCombo.class.getName(), CLabel.class.getName(), Browser.class.getName(), ScrolledComposite.class.getName(), ScrollBar.class.getName(), FileUpload.class.getName(), DropDown.class.getName(), "org.eclipse.nebula.widgets.grid.Grid"};
    private final Map<String, Theme> themes = new HashMap<String, Theme>();
    private final ThemeableWidgetHolder themeableWidgets = new ThemeableWidgetHolder();
    private final List<String> appearances = new ArrayList<String>();
    private final ThemeAdapterManager themeAdapterManager = new ThemeAdapterManager();
    private final Map<String, String> resolvedPackageNames = new HashMap<String, String>();
    private Theme fallbackTheme;
    private boolean initialized = false;

    public ThemeManager() {
        this.createAndAddFallbackTheme();
        this.addDefaultThemableWidgets();
    }

    public void initialize() {
        if (!this.hasTheme("org.eclipse.rap.rwt.theme.Default")) {
            StyleSheet defaultStyleSheet = ThemeUtil.readDefaultThemeStyleSheet();
            Theme defaultTheme = new Theme("org.eclipse.rap.rwt.theme.Default", DEFAULT_THEME_NAME, defaultStyleSheet);
            this.registerTheme(defaultTheme);
        }
    }

    public void activate() {
        if (!this.initialized) {
            this.initializeThemeableWidgets();
            Collection<Theme> allThemes = this.themes.values();
            ThemeableWidget[] allThemeableWidgets = this.themeableWidgets.getAll();
            for (Theme theme : allThemes) {
                theme.initialize(allThemeableWidgets);
            }
            this.initialized = true;
        }
    }

    public void deactivate() {
        this.themes.clear();
        this.themeableWidgets.reset();
        this.appearances.clear();
        this.themeAdapterManager.reset();
        this.resolvedPackageNames.clear();
        this.initialized = false;
        this.createAndAddFallbackTheme();
        this.addDefaultThemableWidgets();
    }

    public void addThemeableWidget(String className, ResourceLoader loader) {
        this.checkNotInitialized();
        ParamCheck.notNull(className, "widget");
        ParamCheck.notNull(loader, "loader");
        this.themeableWidgets.add(new ThemeableWidget(className, loader));
    }

    public ThemeAdapterManager getThemeAdapterManager() {
        return this.themeAdapterManager;
    }

    public void registerTheme(Theme theme) {
        this.checkNotInitialized();
        String id = theme.getId();
        if (this.themes.containsKey(id)) {
            String pattern = "Theme with id ''{0}'' exists already";
            Object[] arguments = new Object[]{id};
            String msg = MessageFormat.format(pattern, arguments);
            throw new IllegalArgumentException(msg);
        }
        this.themes.put(id, theme);
    }

    public boolean hasTheme(String themeId) {
        return this.themes.containsKey(themeId);
    }

    public Theme getTheme(String themeId) {
        Theme result = null;
        if (this.themes.containsKey(themeId)) {
            result = this.themes.get(themeId);
        }
        return result;
    }

    public String[] getRegisteredThemeIds() {
        String[] result = new String[this.themes.size()];
        return this.themes.keySet().toArray(result);
    }

    public ThemeableWidget getThemeableWidget(Class<? extends Widget> widget) {
        return this.themeableWidgets.get(widget.getName());
    }

    public List<String> getAppearances() {
        return Collections.unmodifiableList(this.appearances);
    }

    ThemeableWidget[] getAllThemeableWidgets() {
        return this.themeableWidgets.getAll();
    }

    private void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("ThemeManager is already initialized");
        }
    }

    private void createAndAddFallbackTheme() {
        this.fallbackTheme = new Theme(FALLBACK_THEME_ID, FALLBACK_THEME_NAME, null);
        this.themes.put(FALLBACK_THEME_ID, this.fallbackTheme);
    }

    private void initializeThemeableWidgets() {
        ThemeableWidget[] widgets;
        ThemeableWidget[] themeableWidgetArray = widgets = this.themeableWidgets.getAll();
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeableWidget widget = themeableWidgetArray[n2];
            this.loadThemeableWidgetResources(widget);
            ++n2;
        }
    }

    private void addDefaultThemableWidgets() {
        String[] stringArray = THEMEABLE_WIDGETS;
        int n = THEMEABLE_WIDGETS.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            this.addThemeableWidget(className, STANDARD_RESOURCE_LOADER);
            ++n2;
        }
    }

    private void loadThemeableWidgetResources(ThemeableWidget themeWidget) {
        String className = LifeCycleAdapterUtil.getSimpleClassName(themeWidget.className);
        String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(themeWidget.className);
        boolean found = false;
        try {
            int i = 0;
            while (i < variants.length && !found) {
                found |= this.loadThemeDef(themeWidget, variants[i], className);
                found |= this.loadAppearanceJs(themeWidget, variants[i], className);
                found |= this.loadDefaultCss(themeWidget, variants[i], className);
                ++i;
            }
            if (themeWidget.defaultStyleSheet != null) {
                this.fallbackTheme.addStyleSheet(themeWidget.defaultStyleSheet);
            }
        }
        catch (IOException e) {
            String msg = "Failed to initialize themeable widget: " + themeWidget.className;
            throw new ThemeManagerException(msg, e);
        }
    }

    private boolean loadThemeDef(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        String resPkgName = this.resolvePackageName(pkgName);
        String fileName = String.valueOf(resPkgName) + "/" + className + ".theme.xml";
        InputStream inStream = themeWidget.loader.getResourceAsStream(fileName);
        if (inStream != null) {
            result = true;
            try {
                try {
                    ThemeDefinitionReader reader = new ThemeDefinitionReader(inStream, fileName);
                    reader.read();
                    themeWidget.elements = reader.getThemeCssElements();
                }
                catch (Exception e) {
                    String message = "Failed to parse theme definition file " + fileName;
                    throw new ThemeManagerException(message, e);
                }
            }
            finally {
                inStream.close();
            }
        }
        return result;
    }

    private boolean loadAppearanceJs(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        String resPkgName = this.resolvePackageName(pkgName);
        String fileName = String.valueOf(resPkgName) + "/" + className + ".appearances.js";
        InputStream inStream = themeWidget.loader.getResourceAsStream(fileName);
        if (inStream != null) {
            try {
                String content = AppearancesUtil.readAppearanceFile(inStream);
                this.appearances.add(content);
                result = true;
            }
            finally {
                inStream.close();
            }
        }
        return result;
    }

    private boolean loadDefaultCss(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        ResourceLoader resLoader = themeWidget.loader;
        String resPkgName = this.resolvePackageName(pkgName);
        String fileName = String.valueOf(resPkgName) + "/" + className + ".default.css";
        InputStream inStream = resLoader.getResourceAsStream(fileName);
        if (inStream != null) {
            try {
                themeWidget.defaultStyleSheet = CssFileReader.readStyleSheet(inStream, fileName, resLoader);
                result = true;
            }
            finally {
                inStream.close();
            }
        }
        return result;
    }

    private String resolvePackageName(String packageName) {
        String result = this.resolvedPackageNames.get(packageName);
        if (result == null) {
            result = packageName.replace('.', '/');
            this.resolvedPackageNames.put(packageName, result);
        }
        return result;
    }
}

